import  React, { Component } from 'react'
import TopProduct from "./TopProduct";
import Store from '../../../utils/store'


export default class TopProducts extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            topProducts: [],
            store: store

        }
    }

    componentDidMount() {
        this._isMounted = true;

        this.state.store.api_post_call('getTopProducts', {}).then(res=> {
            this.setState({topProducts: res.data.values});
            console.log('topProducts', res.data)

        }).catch(err => {
            console.log(err);
        })
    }


    render () {

        let topProds = this.state.topProducts;
        let currency = this.props.currency;

        return (
                <div className="product-wrapper mt-50" key={'myTopProducts'} >
                    <div className="product-min-title">
                        <h5 className="title">Top produits</h5>
                    </div>
                    <div className="mini-product-active">

                    {
                    topProds.map((topProduct, indexProduct) =>
                            <TopProduct topProduct={topProduct}
                                        indexProduct={indexProduct}
                                        currency={this.props.currency}
                                        calculateCurrencies={this.props.calculateCurrencies}
                            />
                    )
                    }

                    </div>
                </div>
        )
    }
}


