import React, {Component} from "react";
import slider2 from "../../../../../../public/assets/images/cover31.jpg";
import TopProducts from "./TopProducts";
import ProductCardList from "./ProductCard/ProductCardList";
import ProductCardGrid from "./ProductCard/ProductCardGrid";
import Store, {countCartProdsVar, minValueSlider, searchListenerVar} from '../../../utils/store';
import {BrowserRouter, Link, Route, Switch, Redirect} from 'react-router-dom'

import Pagination from "./Pagination";
import Swal from "sweetalert2";
import Carousel, { consts } from "react-elastic-carousel";
import RelatedProduct from "./ProductCard/ProductDetails/RelatedProduct";




export default class ProductsList extends Component {
    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            sortValue: 'Ne pas trier',
            loading: true,
            showValue: '10',
            products: [],
            searchString: '',
            allProducts: [],
            wishlistProds: [],
            filter: {
                size: [],
                color: [],
                priceFrom: 0,
                priceTo: 100000,
                sub_id: '',
                cat_id: '',
                order_by:''
                // category: null,
                // subcategory: null
            },
            store:store,
            nextUrl: null,
            prevUrl: null,
            colorsFilter: [
                {value: 'red', active: false},
                {value: 'brown', active: false},
                {value: 'black', active: false},
                {value: 'blue', active: false},
                {value: 'green', active: false},
                {value: 'white', active: false},
                {value: 'gray', active: false},
                {value: 'pink', active: false},
                {value: 'purple', active: false},
                {value: 'gold', active: false},
                {value: 'silver', active: false},
                {value: 'darkBlue', active: false},
                {value: 'lightBlue', active: false}
                ],
            sizesFilter: [
                {value: 'XXS', active: false},
                {value: 'XS', active: false},
                {value: 'S', active: false},
                {value: 'M', active: false},
                {value: 'L', active: false},
                {value: 'XL', active: false},
                {value: 'XXL', active: false},
                {value: 'XXXL', active: false},
                {value: 'XXXXL', active: false},
                {value: 'XXXXXL', active: false},
            ]

        };
        searchListenerVar.subscribe(data=> {
            let self = this;
            if(data!=null){
                setTimeout(function(){
                    let storeValues = JSON.parse(localStorage.getItem(self.state.store.storeId));
                    storeValues.search = '';
                    localStorage.setItem(self.state.store.storeId, JSON.stringify(storeValues));
                },1000);
            }
        });

        this.getProducts();

        this.handleChangeTwo = this.handleChangeTwo.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        this.handleSort = this.handleSort.bind(this);
        this.handleShow = this.handleShow.bind(this);
        this.addToWishListProduct=this.addToWishListProduct.bind(this);
        this.filterSizeS=this.filterSizeS.bind(this);
        this.filterColor=this.filterColor.bind(this);
        this.filterPrice=this.filterPrice.bind(this);
        this.sortAscending=this.sortAscending.bind(this);
        this.sortDescending=this.sortDescending.bind(this);
        this.doNotSort=this.doNotSort.bind(this);
        this.showFive=this.showFive.bind(this);
        this.showTen=this.showTen.bind(this);
        this.showMany=this.showMany.bind(this);
        this.showCategoryItems=this.showCategoryItems.bind(this);
        this.showSubcategoryItems=this.showSubcategoryItems.bind(this);
        this.reset=this.reset.bind(this);
        this.showNext=this.showNext.bind(this);
        this.showPrev=this.showPrev.bind(this);
        this.checkForCategory = this.checkForCategory.bind(this);
        this.changeActiveColor = this.changeActiveColor.bind(this);
        this.selectedColorClass = this.selectedColorClass.bind(this);
        this.selectedSizeClass = this.selectedSizeClass.bind(this);
        this.changeActiveSize = this.changeActiveSize.bind(this);
        this.addToCartProduct = this.addToCartProduct.bind(this);
        this.refreshPage = this.refreshPage.bind(this);
        //this.getProducts = this.getProducts.bind(this);
        this.orderHighToLow = this.orderHighToLow.bind(this);
        this.orderLowToHigh = this.orderLowToHigh.bind(this);
        this.myArrow = this.myArrow.bind(this);
        // this.load = this.load.bind(this);

        // this.filterCategory=this.filterCategory.bind(this);
        // this.filterSubcategory=this.filterSubcategory.bind(this);
        const self = this;
        setTimeout(function(){
            self.checkForCategory();
        },500);

    }
    componentDidMount() {
        const self = this;
        $("#slider-range").slider({
            range: true,
            min: 0,
            max: 300,
            values: [0, 100],
            slide: function (event, ui) {
                let tmpFilt = self.state.filter;
                tmpFilt.priceFrom = $("#amount1").val();
                tmpFilt.priceTo = $("#amount2").val();
                self.setState({
                    filter: tmpFilt
                })

                $("#amount1").val(ui.values[0] + ".00");

                $("#amount2").val(ui.values[1] + ".00");
            }
        });
        $("#amount1").val($("#slider-range").slider("values", 0) + ".00");
        $("#amount2").val($("#slider-range").slider("values", 1) + ".00");


        setTimeout(function(){
            self.setState({
                    loading: false
                }
            )
        },1300);

    }

    myArrow({ type, onClick, isEdge }) {
        const pointer = type === consts.PREV ? '〈' : '〉'
        return (
            <button style={{border:'0', backgroundColor: 'white', fontSize: '30px', padding: '0 10px', background:'transparent'}} onClick={onClick} disabled={isEdge}>
                {pointer}
            </button>
        )
    }


    getProducts() {

        let storeValues = JSON.parse(localStorage.getItem(this.state.store.storeId));
        let filter = this.state.filter;
        let search = storeValues.search;

        let params={
            filter: JSON.stringify(filter),
            search: search

        }

        this.state.store.api_post_call('getProducts', params).then(res=> {
            this.setState({products:  res.data.values.data, allProducts: res.data.values.data,
                nextUrl:res.data.values.next_page_url,
                prevUrl: res.data.values.prev_page_url
            });
            console.log('prods', res)
        }).catch(err => {
            console.log(err);
        })
    }

    refreshPage(){
        alert('test');
        console.log('refresh')
        window.history.replaceState(null, null, window.location.pathname);

    }
    async doNotSort(changedValue){
        await this.setState({
            ...this.state,
            filter: {
                ...this.state.filter,
                order_by: ""
            },
            sortValue: changedValue

        });

        this.getProducts();
        window.scrollTo(0, 0);
    }

    async orderLowToHigh(changedValue){
        await this.setState({
            ...this.state,
            filter: {
                ...this.state.filter,
                order_by: "low"
            },
            sortValue: changedValue

        });

        this.getProducts();
        window.scrollTo(0, 0);
    }

    async orderHighToLow(changedValue){
        await this.setState({
            ...this.state,
            filter: {
                ...this.state.filter,
                order_by: "high"
            },
            sortValue: changedValue
        });

        this.getProducts();
        window.scrollTo(0, 0);
    }

    // setColor(products){
    //     let prods = products;
    //     for(let i=0;i<prods.length;i++){
    //         for(let j=0;j<prods[i].sizes.length;j++){
    //             for(let k=0;k<prods[i].sizes[j].colors.length;k++){
    //                 if(prods[i].sizes[j].colors[k].color!==null){
    //                     prods[i].sizes[j].colors[k]=prods[i].sizes[j].colors[k].color.toLowerCase();
    //                 }
    //             }
    //         }
    //     }
    //     this.setState({products: prods})
    //     console.log('changed products', this.state.products);
    // }
    // componentWillMount() {
    //     //
    //
    //     this.state.store.api_post_call('getSingleProduct', {id: 1}).then(res=> {
    //         console.log('product', res.data)
    //     }).catch(err => {
    //         console.log(err);
    //     })
    //
    // }
    showNext(){
        let next = this.state.nextUrl;

        let storeValues = JSON.parse(localStorage.getItem(this.state.store.storeId));
        let filter = this.state.filter;
        let search = storeValues.search;

        let params={
            filter: JSON.stringify(filter),
            search: search

        }

        this.state.store.api_post_call_wl(next, params).then(res=> {
            this.setState({products:  res.data.values.data,
                prevUrl:res.data.values.prev_page_url,
                nextUrl:res.data.values.next_page_url});
            console.log('prods2', res)

        }).catch(err => {
            console.log(err);
        })
    }
    showPrev(){
        let prev = this.state.prevUrl;
        let storeValues = JSON.parse(localStorage.getItem(this.state.store.storeId));
        let filter = this.state.filter;
        let search = storeValues.search;

        let params= {
            filter: JSON.stringify(filter),
            search: search
        }

        this.state.store.api_post_call_wl(prev, params).then(res=> {
            this.setState({products:  res.data.values.data,
                 prevUrl:res.data.values.prev_page_url,
                nextUrl:res.data.values.next_page_url});

        }).catch(err => {
            console.log(err);
        })
    }
    // filterCategory(){
    //     let filteredProducts = this.state.allProducts;
    //     let prd = [];
    //     filteredProducts.filter(p =>
    //         p.category.includes(this.state.filter.category) ? prd.push(p): false;
    //     )
    //     this.setState({products: prd});
    // }s
    // filterSubcategory(){
    //     let filteredProducts = this.state.allProducts;
    //     let prd = [];
    //     filteredProducts.filter(p =>
    //         p.sub_category_id.includes(this.state.filter.subcategory) ? prd.push(p): false;
    //     )
    //     this.setState({products: prd});
    // }
    reset(){
        let prods = this.state.allProducts;
        this.setState({
            products: prods
        })

        window.scrollTo(0, 0);


    }
    // async showCategoryItems(category) {
    //     let id=category.id;
    //
    //
    //     await this.setState({
    //         ...this.state,
    //         filter: {
    //             ...this.state.filter,
    //             cat_id: id
    //         }
    //     });
    //
    //     this.getProducts();
    //
    //     // window.scrollTo(0, 0);
    // }


    // async showCategoryItems(category) {
    //     await this.reset();
    //     let id=category.id;
    //     let subcategories = [];
    //     let prods=[];
    //     await this.state.store.api_post_call('getSingleCategory', {cat_id: id}).then(res=> {
    //         subcategories= res.data.values;
    //         console.log('subcategorieess', subcategories);
    //
    //
    //     }).catch(err => {
    //         console.log(err);
    //     })
    //
    //
    //     for(let i=0;i<subcategories.length;i++){
    //         console.log('testetstetst',subcategories[i] )
    //         for(let j=0;j<subcategories[i].products.length;j++){
    //             prods.push(subcategories[i].products[j])
    //         }
    //     }
    //
    //     console.log('filtered prodssss', prods);
    //     this.setState({
    //         products: prods
    //     })
    //
    //
    //     window.scrollTo(0, 0);
    // }
    async showCategoryItems(category) {


        let id=category.id;


        await this.setState({
            ...this.state,
            filter: {
                ...this.state.filter,
                cat_id: id
            }
        });

        this.getProducts();

        // window.scrollTo(0, 0);
    }




    async showSubcategoryItems(subcategory) {
        let id=subcategory.id;


        await this.setState({
            ...this.state,
            filter: {
                ...this.state.filter,
                sub_id: id
            }
        });

        this.getProducts();

        // window.scrollTo(0, 0);
    }
    // async showSubcategoryItems(subcategory) {
    //     await this.reset();
    //     let prods = [];
    //     let products = this.state.products;
    //
    //     for (let k = 0; k < products.length; k++) {
    //             if (products[k].sub_category_id === subcategory.id)
    //                 prods.push(products[k]);
    //     }
    //     this.setState({products: prods})
    //
    //     window.scrollTo(0, 0);
    // }


    sortAscending(changedValue){
        let sortedProducts = this.state.products;
        let sorted = [];
        sortedProducts.sort((a,b) => a.price - b.price);
        this.setState({products: sortedProducts,
            sortValue: changedValue});
        // console.log('sortirani', this.state.products);
    }
    sortDescending(changedValue){
        let sortedProducts = this.state.products;
        let sorted = [];
        sortedProducts.sort((a,b) => a.price - b.price);
        sortedProducts.reverse();
        this.setState({products: sortedProducts,
            sortValue: changedValue});
        // console.log('sortirani', this.state.products);
    }
    // doNotSort(changedValue){
    //     let sortedProducts = this.state.products;
    //     this.setState({products: sortedProducts,
    //         sortValue: changedValue
    //     });
    //
    // }
    // doNotSort(changedValue){
    //     let sortedProducts = this.state.products;
    //     this.setState({products: sortedProducts,
    //         sortValue: changedValue
    //     });
    //
    // }
    showFive(showedValue){
        let showed = this.state.products;
        let showfive = showed.slice(0,5);
        this.setState({products: showfive,
            showValue: showedValue
        });

        let params = {
            number:5
        }
        this.state.store.api_post_call('getProducts', params).then(res=> {
            console.log('show number', res.data.values);

        }).catch(err => {
            console.log(err);
        })

    }
    showTen(showedValue){
        let showed = this.state.products;
        let showten = showed.slice(0,10);
        this.setState({products: showten,
            showValue: showedValue
        });
        let params = {
            number:10
        }
        this.state.store.api_post_call('getProducts', params).then(res=> {
            console.log('show number', res.data.values);

        }).catch(err => {
            console.log(err);
        })
    }
    showMany(showedValue){
        let showed = this.state.products;
        let showmany= showed.slice(0,30);
        this.setState({products: showmany,
            showValue: showedValue
        });
        let params = {
            number:30
        }
        this.state.store.api_post_call('getProducts', params).then(res=> {
            console.log('show number', res.data.values);

        }).catch(err => {
            console.log(err);
        })
    }
    filterPrice(){
        // let filteredProducts = this.state.products;
        // let prd = [];
        // tmpFilt.priceFrom =  $("#amount1").val();
        // tmpFilt.priceTo =  $("#amount2").val();
        let minPrice = parseInt($("#amount1").val().split(this.props.currency)[0]);
        let maxPrice = parseInt($("#amount2").val().split(this.props.currency)[0]);
        this.setState({
            ...this.state,
            filter: {
                ...this.state.filter,
                priceFrom: minPrice,
                priceTo: maxPrice
            }
        })
        console.log('ovie od maja', minPrice, maxPrice);
        this.getProducts();

        // filteredProducts.filter(p =>  {
        //     parseInt(p.price)>=minPrice && parseInt(p.price)<=maxPrice ? prd.push(p): false;
        // })
        //
        // this.setState({products: prd});

    }
    filterSizeS(str, sizeIndex){
        // let filteredProducts = this.state.products;
        // let prd = [];
        // filteredProducts.filter(p => p.sizes.map(s => {
        //         s.size = s.size.toLowerCase();
        //         s.size.includes(str.toLowerCase()) ? prd.push(p): false;
        //     })
        // )
        // this.setState({products: prd});
        let sizeArray = this.state.filter.size;
        // console.log(str);
        // console.log(sizeArray);
        let flag=true;
        this.changeActiveSize(sizeIndex);
        let index=0;


        if(sizeArray.length!=null){
        for(let i=0;i<sizeArray.length;i++){
            if(sizeArray[i]===str) {
                // console.log('vleze')
                flag = false;
                index=i;
                break;
            }
        }
        if(flag===false){
            sizeArray.splice(index);
        }
        else
            sizeArray.push(str);}
        else
            sizeArray.push(str);


        this.setState({
            ...this.state,
            filter: {
                ...this.state.filter,
                size: sizeArray
            }
        });

        this.getProducts();
    }
    filterColor(str, colorIndex){
        // let filteredProducts = this.state.products;
        // let prd = [];
        // filteredProducts.filter(p => p.sizes.map(size => {
        //     size.colors.map(color => {
        //         color.color = color.color.toLowerCase();
        //         if(color.color.includes(str.toLowerCase())) {
        //             if(!prd.includes(p)){
        //                 prd.push(p);
        //             }
        //         }
        //     })
        // }))
        //
        //
        //
        // this.setState({products: prd});

        let colorArray = this.state.filter.color;
        let flag=true;
        this.changeActiveColor(colorIndex);

        if(colorArray.length!==null) {
            for (let i = 0; i < colorArray.length; i++) {
                if (colorArray[i] === str) {
                    flag = false;
                    break;
                }
            }
            if (flag === false) {
                for (let i = 0; i < colorArray.length; i++) {
                    if (colorArray[i] === str)
                        colorArray.splice(i);
                }
            } else
                colorArray.push(str);
        }
        else
            colorArray.push(str);

        this.setState({
            ...this.state,
            filter: {
                ...this.state.filter,
                color: colorArray
            }
        });

        this.getProducts();
    }
    handleSort( changedValue) {
        //console.log(changedValue);
        this.setState({sortValue: changedValue});
    }
    handleShow( showedValue) {
        this.setState({showValue: showedValue});
    }
    handleSubmit(event) {
        event.preventDefault();
    }
    handleChangeTwo(event) {
        this.setState({showValue: event.target.value});
    }
    selectedColorClass(colorIndex){
        const self = this;
        let returnValue = '';
        if(self.state.colorsFilter != null){
            if(self.state.colorsFilter[colorIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    changeActiveColor(colorIndex) {
        let colorsFilter = this.state.colorsFilter;
        // colorsFilter.map((color)=>{
        //             color.active = false;
        //         });
        if(colorsFilter[colorIndex].active === true) {

            colorsFilter[colorIndex].active = false;

        }
        else
            colorsFilter[colorIndex].active = true;



        this.setState({colorsFilter: colorsFilter});
    }

    selectedSizeClass(sizeIndex){
        const self = this;
        let returnValue = '';
        if(self.state.sizesFilter != null){
            if(self.state.sizesFilter[sizeIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    changeActiveSize( sizeIndex) {
        let sizesFilter = this.state.sizesFilter;
        // sizesFilter.map((size)=>{
        //     size.active =false;
        // });
            if(sizesFilter[sizeIndex].active === true) {

                sizesFilter[sizeIndex].active = false;

            }
            else
                sizesFilter[sizeIndex].active = true;




        this.setState({sizesFilter: sizesFilter});
    }

    addToWishListProduct(product){
        let storeData = this.state.store.addToWishListProduct(product);
        this.setState({wishlistProds: storeData.wishList,});
    }

    addToCartProduct(product, index){
        let storeData = this.state.store.addToCartProductOnCLick(product, index);
        this.setState({cartProds: storeData.cart});
        console.log('testAddToCart', this.state.cartProds );
    }



    checkForCategory(){
        const self = this;
        let categories = this.props.categories;

        let currentUrl = window.location.href;

        let checkForCategory = currentUrl.split("/list/");
        if(typeof checkForCategory[1] != 'undefined'){
            let category = checkForCategory[1];

            let checkForSubategory = category.split("/");
            if(typeof checkForSubategory[1]!='undefined'){
                //call function with category and subcategory to filter
                category = checkForSubategory[0];
                let subCategory = checkForSubategory[1];
                //filters
                let myCC = null;
                let mySub = null;
                categories.map(function (c, catId) {
                    if (c.title === category) {
                        myCC = c;
                    }
                    c.sub_categories.map(function(sub, subId)
                        {
                            if (sub.title === subCategory) {
                                mySub = sub;
                            }
                        }
                    )
                });
                if(myCC!=null) {
                    console.log(category, ' ------- ');
                    self.showCategoryItems(myCC);
                }
                if(mySub!=null) {
                    console.log(subCategory, ' ------- ');
                    self.showSubcategoryItems(mySub);
                }



            }
            else{
                //call function with category to filter
                category = checkForSubategory[0];
                let myCC = null;
                categories.map(function (c, catId) {
                    if (c.title === category) {
                        myCC = c;
                    }
                });
                if(myCC!=null) {
                    console.log(category, ' ------- ');
                        self.showCategoryItems(myCC);

                }
            }

        }
    }
    render() {
        const self = this;
        let products = this.state.products;
        // let categories = this.state.store.categories;
        let categories = this.props.categories;
        let wishlistProds = this.state.wishlistProds;
        let visibleProducts = products;
        let currency = this.props.currency;


        console.log('filterrrs', this.state.filter)

        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Accueil</a></li>
                            <li className="breadcrumb-item active">Des produits</li>
                        </ol>
                    </div>
                </section>

                <section className="shop-grid-page pt-30 pb-100">
                    <div className="container" >
                        <div className="row flex-lg-row-reverse">

                            <div className="col-lg-9">
                                <div className="shop-top pt-35 pb-20 d-sm-flex justify-content-between align-items-center">
                                    <div className="shop-left">
                                        <div className="item d-flex align-items-center">
                                            <span>Voir comme :</span>
                                            <ul className="nav">
                                                <li>
                                                    <a className="active" data-toggle="tab" href="#grid"><i
                                                        className="fas fa-th-large"> </i></a>
                                                </li>
                                                <li>
                                                    <a data-toggle="tab" href="#list"><i
                                                        className="fas fa-list"> </i></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div className="shop-right d-flex flex-wrap">
                                        <div className="item d-flex align-items-center">


                                        <span>Trier: </span>

                                            <div type="button" className="nice-select open"
                                                    data-toggle="dropdown" aria-haspopup="true"
                                                    aria-expanded="false">
                                                {this.state.sortValue}
                                                <i style={{paddingLeft: '5px'}} className="fa fa-angle-down" aria-hidden="true"> </i>
                                            </div>
                                            <div className="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <a style={{cursor:'pointer'}} className="dropdown-item"  onClick={() => this.doNotSort('Ne pas trier')} >Ne pas trier</a>
                                                <a style={{cursor:'pointer'}} className="dropdown-item"  onClick={() => this.orderLowToHigh('Prix croissant')}>Prix croissant</a>
                                                <a style={{cursor:'pointer'}} className="dropdown-item"  onClick={() => this.orderHighToLow('Prix decroissant')}>Prix decroissant</a>
                                            </div>


                                        </div>
                                            {/*<div className="item d-flex align-items-center">*/}
                                            {/*<span>Show : </span>*/}
                                            {/*    <button  type="button"*/}
                                            {/*            id="dropdownMenuButton" className="nice-select open" data-toggle="dropdown" aria-haspopup="true"*/}
                                            {/*            aria-expanded="false">*/}
                                            {/*        {this.state.showValue}*/}
                                            {/*    </button>*/}
                                            {/*    <div className="dropdown-menu" aria-labelledby="dropdownMenuButton">*/}
                                            {/*        <a className="dropdown-item"  onClick={() => this.showFive('5')} >5</a>*/}
                                            {/*        <a className="dropdown-item"  onClick={() => this.showTen('10')}>10</a>*/}
                                            {/*        <a className="dropdown-item"  onClick={() => this.showMany('30')}>30</a>*/}
                                            {/*    </div>*/}
                                            {/*</div>*/}
                                    </div>
                                </div>
                                {
                                    categories.length > 3 ?
                                        <React.Fragment>
                                            <div className="row" >
                                                <div className="row" style={{padding: '15px', margin:'0', width:'100%', backgroundColor:'#FFF7FB'}}>
                                                    <div className="col-12">
                                                        <Carousel className='d-none d-lg-block' renderArrow={this.myArrow} itemPadding={[0, 20]} itemsToShow={4} pagination={false}  itemsToScroll={1} enableSwipe enableMouseSwipe>
                                                            {
                                                                categories.map((cat,catId)=>
                                                                    <React.Fragment>
                                                                        {/*<div className="col-lg-2 col-6 col-sm-4" key={catId} style={{cursor: 'pointer'}}>*/}
                                                                        <a href={'/list/'+cat.title} className="single-product-category" style={{backgroundColor:'#f5efe9'}} onClick={()=>{this.showCategoryItems(cat)}}>
                                                                            {/*<a href="shop.html">*/}
                                                                            <img src={cat.icon} alt="category"  />
                                                                            <div className="category-content">
                                                                                <h6 className="title">  {cat.title}</h6>
                                                                                {/*<p>20 Items</p>*/}
                                                                            </div>
                                                                            {/*</a>*/}
                                                                        </a>
                                                                        {/*</div>*/}

                                                                    </React.Fragment>
                                                                )
                                                            }
                                                        </Carousel>
                                                        <Carousel className='d-block d-sm-none' renderArrow={this.myArrow} itemPadding={[0, 20]} itemsToShow={2} pagination={false}  itemsToScroll={1} enableSwipe enableMouseSwipe>
                                                            {
                                                                categories.map((cat,catId)=>
                                                                    <React.Fragment>
                                                                        {/*<div className="col-lg-2 col-6 col-sm-4" key={catId} style={{cursor: 'pointer'}}>*/}
                                                                        <div className="single-product-category" style={{backgroundColor:'#f5efe9'}} onClick={()=>{this.showCategoryItems(cat)}}>
                                                                            {/*<a href="shop.html">*/}
                                                                            <img src={cat.icon} alt="category"  />
                                                                            <div className="category-content">
                                                                                <h6 className="title">  {cat.title}</h6>
                                                                                {/*<p>20 Items</p>*/}
                                                                            </div>
                                                                            {/*</a>*/}
                                                                        </div>
                                                                        {/*</div>*/}

                                                                    </React.Fragment>
                                                                )
                                                            }
                                                        </Carousel>
                                                        <Carousel className='d-none d-lg-none d-sm-block d-md-block'  renderArrow={this.myArrow} itemPadding={[0, 20]} pagination={false} itemsToShow={3}   itemsToScroll={1} enableSwipe enableMouseSwipe>
                                                            {
                                                                categories.map((cat,catId)=>
                                                                    <React.Fragment>
                                                                        {/*<div className="col-lg-2 col-6 col-sm-4" key={catId} style={{cursor: 'pointer'}}>*/}
                                                                        <div className="single-product-category " style={{backgroundColor:'#f5efe9'}} onClick={()=>{this.showCategoryItems(cat)}}>
                                                                            {/*<a href="shop.html">*/}
                                                                            <img src={cat.icon} alt="category"  />
                                                                            <div className="category-content">
                                                                                <h6 className="title">  {cat.title}</h6>
                                                                                {/*<p>20 Items</p>*/}
                                                                            </div>
                                                                            {/*</a>*/}
                                                                        </div>
                                                                        {/*</div>*/}

                                                                    </React.Fragment>
                                                                )
                                                            }
                                                        </Carousel>
                                                    </div>
                                                </div>
                                            </div>
                                        </React.Fragment>
                                        :
                                        null

                                }


                                {
                                    this.state.loading===true?
                                        <React.Fragment>
                                        <div className="justify-content-center" style={{textAlign: 'center'}}>
                                            <img style={{height: '100px', width: '100px'}} src="https://snoopgame.com/wp-content/uploads/2019/08/dots.gif" alt="loading"/>
                                        </div>
                                    </React.Fragment>
                                        :
                                        <React.Fragment>
                                            <div className="tab-content">
                                                <div className="tab-pane fade show active" id="grid">
                                                    <div className="row">
                                                        {visibleProducts && visibleProducts.map((product, index) =>
                                                            <div className="col-lg-4 col-sm-6" key={product.id}>
                                                                <ProductCardGrid product={product}
                                                                                 currency={this.props.currency}
                                                                                 key={product.id}
                                                                                 addToCartProduct={this.addToCartProduct}
                                                                                 wishlistProducts={wishlistProds}
                                                                                 calculateCurrencies = {this.props.calculateCurrencies} /> </div >)}
                                                    </div>
                                                </div>
                                                <div className="tab-pane fade" id="list">
                                                    {visibleProducts && visibleProducts.map((product, index) =>
                                                        <div key={product.id} >
                                                            <ProductCardList  product={product}
                                                                              currency={this.props.currency}
                                                                              key={product.id}
                                                                              addToWishListProduct={this.addToWishListProduct}
                                                                              wishlistProducts={wishlistProds}
                                                                              calculateCurrencies = {this.props.calculateCurrencies}/> </div>)}
                                                </div>
                                            </div>
                                        </React.Fragment>


                                }

                                {
                                    visibleProducts.length > 0 ?
                                        <React.Fragment>
                                            <div className="emoll-pagination mt-50">
                                                <ul className="pagination justify-content-center">
                                                    {/*<li><a href="#" className="prev"><i className="far fa-chevron-left"> </i></a>*/}
                                                    {/*</li>*/}
                                                    {/*<li><a className="active" href="#">1</a></li>*/}
                                                    {/*<li><a href="#">2</a></li>*/}
                                                    {/*<li><a href="#">3</a></li>*/}
                                                    {/*<li><a href="#" className="next"><i className="far fa-chevron-right"> </i></a>*/}
                                                    {/*</li>*/}
                                                    <li style={{width: '50%', cursor: 'pointer'}} onClick={this.showPrev}><a  style={{width: '100px'}} className="prev"><i className="far fa-chevron-left"> </i></a></li>
                                                    <li style={{ cursor: 'pointer'}} onClick={this.showNext}><a  style={{width: '100px'}} className="next"><i className="far fa-chevron-right"> </i></a></li>

                                                </ul>
                                            </div>
                                        </React.Fragment>
                                        :
                                        <React.Fragment>
                                            <table className="table table-bordered" style={{border: '1px solid #dee2e6',
                                                padding: '15px'}}>
                                                <tr style={{backgroundColor: 'rgb(235, 241, 246)'}}>
                                                    <i style={{padding: '15px',
                                                        marginBottom: '0',
                                                        fontSize: '25px',
                                                        color: '#555'}}
                                                       className="fas fa-exclamation-triangle"> </i> <span> <h5 style={{color: '#555', padding: '15px 0 0 10px'}} >There is no related products.</h5></span>
                                                </tr>
                                            </table>
                                        </React.Fragment>
                                }

                            </div>
                            <div className="col-lg-3">
                                <div className="shop-sidebar pt-20">
                                    <div className="category-sidebar mt-30" id="top">
                                        <div className="category-title">
                                            <h4 className="title"> <i className="fal fa-bars"> </i> Collection </h4>
                                        </div>
                                        <ul className="category-menu menu-expand">

                                            {
                                                categories.map((category, catIndex) =>
                                                        <li  key={catIndex} className="active">
                                                            <a href={"#homeSubmenu" + catIndex} data-toggle="collapse" aria-expanded="false"
                                                               className="dropdown-toggle" style={{cursor: 'pointer', textTransform: 'uppercase'}} onClick={()=>{this.showCategoryItems(category)}}>{category.title}</a>
                                                            <ul className="collapse list-unstyled" id={"homeSubmenu"+ catIndex} >
                                                                {
                                                                    category.sub_categories.map((subcategory, catIndex) =>
                                                                        <li key={catIndex} style={{paddingLeft: '15px'}}><a style={{cursor: 'pointer'}}
                                                                             onClick={()=>{this.showSubcategoryItems(subcategory)}}>{subcategory.title}</a>
                                                                        </li>
                                                                    )
                                                                }
                                                            </ul>
                                                        </li>
                                                )
                                            }
                                        </ul>
                                    </div>





                                                    {/*<li key={catIndex}*/}
                                                    {/*//     style={{cursor: 'pointer'}} data-toggle="collapse" aria-expanded="false" className="menu-item-has-children">*/}
                                                    {/*//*/}
                                                    {/*//     <a className="menu-title" href={'/list/' + category.title}*/}
                                                    {/*//        onClick={() => {*/}
                                                    {/*//            this.showCategoryItems(category)*/}
                                                    {/*//        }} style={{textTransform: 'uppercase'}}>{category.title}</a>*/}
                                                    {/*//     <ul className="sub-mega-menu flex-wrap">*/}
                                                    {/*        {*/}
                                                    {/*            category.sub_categories.map((subcategory, catIndex) =>*/}
                                                            {/*        <li key={catIndex}><a*/}
                                                            {/*            href={'/list/' + category.title + '/' + subcategory.title}>{subcategory.title}</a>*/}
                                                            {/*        </li>*/}
                                                            {/*    )*/}
                                                            {/*}*/}
                                                    {/*</ul>*/}
                                                    {/*</li>*/}






                                            {/*// categories.map((category, catId) =>*/}
                                            {/*//     <li style={{cursor: 'pointer'}} key={catId}><a onClick={()=>{this.showCategoryItems(category)}} style={{textTransform: 'uppercase'}}> {category.title}</a></li>*/}
                                            {/*// )*/}
                                            {/*// }*/}


                                            {/*<li><a href="#"><i className="icofont-home"> </i> Home</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-business-man-alt-3"> </i> Men</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-woman-in-glasses"> </i> Women</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-school-bag"> </i> Bages</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-jersey"> </i> Dresses</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-boot-alt-1"> </i> Footwear</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-diamond"> </i> Jewelry</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-football"> </i> Play Items</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-stopwatch"> </i> Watches</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-game-controller"> </i> Games</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-baby-cloth"> </i> Kids Wear</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-ui-touch-phone"> </i> Smart Phone</a></li>*/}
                                            {/*<li><a href="#"><i className="icofont-laptop"> </i> Laptop</a></li>*/}


                                    {/*Filter spored cena, boja, broj*/}

                                    <div className="sidebar-wrapper mt-30">
                                        <div className="sidebar-title">
                                            <h5 className="title"><i className="far fa-list-ul"> </i> Filtre</h5>
                                        </div>
                                        <div className="price-range">
                                            <h5 className="catalog-title">Prix</h5>
                                            <div className="price-range-wrapper">
                                                <div id="slider-range" className="slider-range"> </div>

                                                <div className="range">
                                                    <input type="text" id="amount1"  readOnly />
                                                    <input type="text" id="amount2" readOnly />
                                                    <button onClick={this.filterPrice} >Filtre</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {/*    <div className="sidebar-size">*/}
                                    {/*        <h5 className="catalog-title">Size</h5>*/}
                                    {/*        <ul className="product-size">*/}


                                    {/*            {*/}
                                    {/*                this.state.sizesFilter.map((size, sizeIndex) =>*/}
                                    {/*                    <li className={this.selectedSizeClass(sizeIndex)} onClick={()=>this.filterSizeS(size.value, sizeIndex)}> {size.value} </li>*/}
                                    {/*                )*/}
                                    {/*            }*/}

                                    {/*            /!*<li onClick={()=>this.filterSizeS('XXS')}>XXS </li>*!/*/}
                                    {/*            /!*<li className="active" onClick={()=>this.filterSizeS('S')}>S</li>*!/*/}
                                    {/*            /!*<li onClick={()=>this.filterSizeS('M')}>M</li>*!/*/}
                                    {/*            /!*<li onClick={()=>this.filterSizeS('L')}>L</li>*!/*/}
                                    {/*            /!*<li onClick={()=>this.filterSizeS('XL')}>XL</li>*!/*/}
                                    {/*            /!*<li onClick={()=>this.filterSizeS('XXL')}>XXL</li>*!/*/}
                                    {/*            /!*<li onClick={()=>this.filterSizeS('XXXL')}>XXXL</li>*!/*/}
                                    {/*        </ul>*/}
                                    {/*    </div>*/}
                                    {/*    <div className="sidebar-color">*/}
                                    {/*        <h5 className="catalog-title">Color</h5>*/}
                                    {/*        <ul className="product-color">*/}

                                    {/*            {*/}
                                    {/*                this.state.colorsFilter.map((color, colorIndex) =>*/}
                                    {/*                    <li className={this.selectedColorClass(colorIndex)} style={{backgroundColor: color.value, border: '1px solid lightgray' }} onClick={()=>this.filterColor(color.value, colorIndex)}> </li>*/}

                                    {/*                )*/}
                                    {/*            }*/}

                                    {/*            /!*<li style={{backgroundColor: "red" }} data-color="#e35858" onClick={()=>this.filterColor('red')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} style={{backgroundColor: "black" }} onClick={()=>this.filterColor('black')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#ffe400" style={{backgroundColor: "yellow" }} onClick={()=>this.filterColor('yellow')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#00C2FE" style={{backgroundColor: "blue" }} onClick={()=>this.filterColor('blue')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#8B4513" style={{backgroundColor: "brown" }} onClick={()=>this.filterColor('brown')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#ffffff" style={{backgroundColor: "white", border: '1px solid gray' }} onClick={()=>this.filterColor('white')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#8B4513" style={{backgroundColor: "purple" }} onClick={()=>this.filterColor('purple')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#8B4513" style={{backgroundColor: "darkblue" }} onClick={()=>this.filterColor('darkblue')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#8B4513" style={{backgroundColor: "lightblue" }} onClick={()=>this.filterColor('lightblue')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#8B4513" style={{backgroundColor: "green" }} onClick={()=>this.filterColor('green')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#8B4513" style={{backgroundColor: "gray" }} onClick={()=>this.filterColor('gray')}> </li>*!/*/}
                                    {/*            /!*<li className={this.selectedColorClass(color, colorIndex)} data-color="#8B4513" style={{backgroundColor: "darkgray" }} onClick={()=>this.filterColor('darkgray')}> </li>*!/*/}
                                    {/*        </ul>*/}
                                    {/*    </div>*/}
                                    {/*    <span className="cart-btn" style={{cursor: 'pointer', fontSize:'12px', paddingBottom:'0',  border:'white', color: '#e06377'}} onClick={this.reset}> RESET FILTER </span>*/}
                                    {/*</div>*/}

                                    {/*Najkupuvani proizvodi, so klik detalen prikaz na izbran produkt*/}
                                    {/*<TopProductsTest/>*/}
                                    <TopProducts currency={this.props.currency} calculateCurrencies = {this.props.calculateCurrencies}/>


                                </div>
                            </div>
                        </div>
                    </div>

                </section>


            </div>
        )
    }
}

// export default connect((state) => ({products: state.products.items}), {
//     fetchProducts
//     }) (ProductsList) ;
