import React, {Component, useLayoutEffect} from 'react'
import PropTypes from 'prop-types';
import Swal from "sweetalert2";
import Carousel from "react-elastic-carousel";
import Store from "../../../../utils/store";




    // let stars = [];
    // for (let i = 1; i <= 5; i++) {
    //     if (i <= product.stars) {
    //         stars.push(<li key={'stars_top_product_'+product.id+'_'+i} className="rating-on"><i className="flaticon-star"> </i></li>);
    //     } else {
    //         stars.push(<li key={'stars_top_product_'+product.id+'_'+i} ><i className="flaticon-star"> </i></li>);
    //     }
    // }
export default class ProductCardList extends Component {
        constructor(props) {
            super(props);
            this.state = {
                product: null,
                errorMessage: '',
                status: ''
            };

            //this.changeActiveSize = this.changeActiveSize.bind(this);
            this.changeActiveColor = this.changeActiveColor.bind(this);
            this.selectedColorClass = this.selectedColorClass.bind(this);
            this.selectedSizeClass = this.selectedSizeClass.bind(this);
            this.addToWish = this.addToWish.bind(this);
            this.calcPrice = this.calcPrice.bind(this);
            this.handleSubmit = this.handleSubmit.bind(this);
            //this.addActive = this.addActive.bind(this);

        }

    componentDidMount(){
            const self = this;
            setTimeout(function(){

            let product = self.props.product;
            product.active=false;
            product.sizes.map(function(size){
                size.active=false;
                // product.colors.map(function(color){
                //     color.active=false;
                // });
            });
                self.setState({product: product});
                //console.log('products will mount',self.state.product);
        },100);
        setTimeout(function () {
            let sizes = this.state.product.sizes;
            let min=0;
            for(let i=0;i<sizes.length;i++){
                if(sizes[i].stock > min){
                    min=sizes[i].stock;
                }
                if(min>0)
                {
                    this.setState({status: "EN STOCK"})
                }
                else
                {
                    this.setState({status: "EN RUPTURE DE STOCK"})
                }
            }
        }, 150);
    }

    changeActiveSize(sizeIndex) {
        const self = this;
        let product = this.state.product;
        product.sizes.map((size)=>{
            size.active =false;
        });
        product.sizes[sizeIndex].active = true;

        this.setState({product: product});
    }

    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }

    changeActiveColor(sizeIndex, colorIndex) {
        let product = this.state.product;
        console.log(product);
        product.sizes.map((size)=>{
            if(size.active===true) {
                size.colors.map((color) => {
                    color.active = false;
                }); }
            });
        product.sizes[sizeIndex].colors[colorIndex].active = true;

        this.setState({product: product});
    }

    selectedColorClass(sizeIndex, colorIndex){
        const self = this;
        let returnValue = '';
        // console.log('funkcija',this.state.product.sizes[sizeIndex]);
        // if(this.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
        //     return 'active';
        // }
        // else return '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    selectedSizeClass(sizeIndex){
        const self = this;
        let returnValue = '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    addToWish(){
            const product = this.props.product;
            this.props.addToWishListProduct(product);
        Swal.fire("Bon travail!", "Le produit a été ajouté à votre liste de souhaits!", "success");
    }

    handleSubmit(){
        let valid = true;
        let product = this.props.product;
        for(let i = 0; i <product.sizes.length; i++) {
            if (product.sizes[i].active === true) {
                for (let k = 0; k < product.sizes[i].colors.length; k++) {
                    if (product.sizes[i].colors[k].active === true) {
                        this.setState({
                            ...this.state,
                            errorMessage: ""
                        });
                        valid=true;
                        break;
                    } else {
                        this.setState({
                            ...this.state,
                            errorMessage: "Veuillez sélectionner la couleur"
                        });
                        valid = false;
                    }
                }
                break;
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: "Veuillez sélectionner la taille"
                });
                valid = false;
            }
        }
        if(this.state.status === "EN RUPTURE DE STOCK"){
            valid = false;
            Swal.fire("L'article est en rupture de stock");
        }

        if(valid){
           this.addToWish();
            Swal.fire({
                title: '<strong>Ajouté à la liste de souhaits<strong>',
                icon: 'success',
                showCloseButton: true,
                showCancelButton: true,
                focusConfirm: false,
                confirmButtonText:
                    '<a className="white" href="/list">Continuez vos achats</a>' ,
                confirmButtonColor: '#fff',
                cancelButtonText:
                    '<a className="white" href="/wishlist">Aller à la liste de souhaits</a>'
            });

            // add(product);
        }

    }



render(){
    let product = this.props.product;
    // console.log(',eden proizvod', product);
    let sizes = product.sizes;
    // console.log('sizes', sizes);
    let title = product.title;
    if (title.length > 33) {
        title = title.substring(0, 30) + "...";
    }
    let description = product.description;
    if (description.length > 50) {
        description = description.substring(0, 47) + "...";
    }
    let currency=this.props.currency;


    return (

        <div className="single-product-list d-sm-flex mt-30">
            <div className="product-image">
                <a href={`/detailed/${product.id}`} >
                    <img className="product-1" style={{objectFit: 'contain', height:'302px', maxHeight: '302px'}}
                         src={product.image} alt="product"/>

                        { product.images.length>1 ?
                                <React.Fragment>
                                    <img className="product-2" style={{objectFit: 'contain', height:'302px', maxHeight: '302px'}}
                                         src={product.images[1].image} alt="product"/>
                                </React.Fragment> :
                                <React.Fragment>
                                    <img className="product-2" style={{objectFit: 'contain', height:'312px', maxHeight: '312px'}}
                                         src={product.image} alt="product"/>
                                </React.Fragment>

                        }

                </a>
            </div>
            <div className="product-content media-body">
                <div className="product-content-top">
                    <h4 className="titleList" key={product.id}> <a href={`/detailed/${product.id}`} style={{textTransform: 'uppercase'}} >{title} </a></h4>

                    {/*<div className="product-rating d-flex">*/}
                    {/*    <ul className="rating starsSize">*/}
                    {/*        /!*{stars}*!/*/}
                    {/*    </ul>*/}
                    {/*    /!*<span className="reviewStars">5 Reviews</span>*!/*/}
                    {/*</div>*/}

                    <span className="sale-price" style={{fontSize: '14px'}}>{product.price} {currency}</span>
                    {/*<span className="regular-price">${product.price}</span>*/}

                    <p className="listDescr" style={{fontSize: '12px'}}>{description}</p>
                    {/*<p style={{color: "red", fontSize:'12px'}} >{this.state.errorMessage}</p>*/}


                    <div className="product-size-color d-flex justify-content-between">

                        <ul className="product-size">
                        {sizes.map((size, sizeIndex) =>

                                <li onClick={() => { this.changeActiveSize(sizeIndex) }}
                                    className={this.selectedSizeClass(sizeIndex)} >
                                    <span style={{minWidth: '22px !important', width: 'auto'}}>{size.size}</span>
                                </li>

                            )

                        }
                        </ul>
                        <ul className="product-color">
                            {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                <li key={product.id} style={{backgroundColor: color.color_code,  border: '1px solid #bebebe', height: '18px', width: '18px'}} onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}
                                className={this.selectedColorClass(sizeIndex, colorIndex)}>
                                <span>  </span>
                            </li>
                            ) : null
                            )}
                        </ul>
                    </div>
                    <div>
                        {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                color.active ?
                                    <React.Fragment>
                                        {color.stock > 0 ?
                                            <React.Fragment>
                                                <label style={{
                                                    color: '#008000',
                                                    fontSize: '12px'
                                                }}> disponible: {color.stock} </label>
                                            </React.Fragment>
                                            :
                                            <React.Fragment>
                                                <label style={{
                                                    color: 'rgb(255, 57, 65)',
                                                    fontSize: '12px'
                                                }}> disponible: {color.stock} </label>
                                            </React.Fragment>
                                        }

                                    </React.Fragment>
                                    :
                                    null

                            )
                            :
                            null
                        )}
                    </div>
                    <span style={{color: "red"}} >{this.state.errorMessage}</span>

                    <div className="product-cart-btn">
                        <a className="cart-btn"><i
                            className="flaticon-heart"> </i>
                            <span className="listProductBtn" onClick={() => { this.handleSubmit() }}>Ajouter à la liste de souhaits</span></a>
                    </div>
                </div>
            </div>
        </div>
    )}

}

ProductCardList.propTypes = {
    product: PropTypes.shape({
        id: PropTypes.number,
        title: PropTypes.string,
        price: PropTypes.string,
        sizes: PropTypes.array,
        description: PropTypes.string,
        status: PropTypes.number
    })
};


