import React, { Component } from 'react'
import slider2 from "../../../../../public/assets/images/slider-2.jpg"
import PropTypes from 'prop-types';
import shop1 from "../../../../../public/assets/images/shop-details/shop-1.jpg";
import shop2 from "../../../../../public/assets/images/shop-details/shop-2.jpg";
import shop3 from "../../../../../public/assets/images/shop-details/shop-3.jpg";
import shop4 from "../../../../../public/assets/images/shop-details/shop-4.jpg";
import shop5 from "../../../../../public/assets/images/shop-details/shop-5.jpg";
import product13 from "../../../../../public/assets/images/product/product-13.jpg";
import product2 from "../../../../../public/assets/images/product/product-2.jpg";
import product4 from "../../../../../public/assets/images/product/product-4.jpg";
import product6 from "../../../../../public/assets/images/product/product-6.jpg";
import product7 from "../../../../../public/assets/images/product/product-7.jpg";
import axios from 'axios';


export default class ProductCardDetails extends Component {
    constructor(props) {
        super(props);
        this.state = {
            product: null
        };

        //this.changeActiveSize = this.changeActiveSize.bind(this);
        this.changeActiveColor = this.changeActiveColor.bind(this);
        this.selectedColorClass = this.selectedColorClass.bind(this);
        this.selectedSizeClass = this.selectedSizeClass.bind(this);
        //this.addActive = this.addActive.bind(this);

    }

    componentWillMount() {
        const self = this;
        setTimeout(function () {

            let product = self.props.product;
            product.active = false;
            product.sizes.map(function (size) {
                size.active = false;
                // product.colors.map(function(color){
                //     color.active=false;
                // });
            });
            self.setState({product: product});
            console.log('products will mount', self.state.product);
        }, 100);
    }

    changeActiveSize(sizeIndex) {
        const self = this;
        let product = this.state.product;
        product.sizes.map((size) => {
            size.active = false;
        });
        product.sizes[sizeIndex].active = true;

        this.setState({product: product});
    }

    changeActiveColor(sizeIndex, colorIndex) {
        let product = this.state.product;
        console.log(product);
        product.sizes.map((size) => {
            if (size.active === true) {
                size.colors.map((color) => {
                    color.active = false;
                });
            }
        });
        product.sizes[sizeIndex].colors[colorIndex].active = true;

        this.setState({product: product});
    }

    selectedColorClass(sizeIndex, colorIndex) {
        const self = this;
        let returnValue = '';
        // console.log('funkcija',this.state.product.sizes[sizeIndex]);
        // if(this.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
        //     return 'active';
        // }
        // else return '';
        if (self.state.product != null) {
            if (self.state.product.sizes[sizeIndex].colors[colorIndex].active === true) {
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    selectedSizeClass(sizeIndex) {
        const self = this;
        let returnValue = '';
        if (self.state.product != null) {
            if (self.state.product.sizes[sizeIndex].active === true) {
                returnValue = 'active';
            }
        }
        return returnValue;
    }


    componentDidMount() {
        let product = this.props.product;

        axios.post('http://127.0.0.1:8000/getSingleProduct', {id: product.id}).then(res => {
            console.log('product', res.data.values);
            product = res.data.values
        }).catch(res => {

        });
    }



    render()
        {
            // this.props.match.params.id;


            // const product = this.props.product;
            // console.log(this.props);
            const product = this.props.products.map((product) =>
                <div key={product.id}>
                </div>
            );

            return (
                <div>
                    {/*<HeaderPart/>*/}
                    <section className="page-banner bg_cover" style={{backgroundImage: "url(" + slider2 + ")"}}>
                        {/*<img src={slider2} alt="slider"/>*/}

                        <div className="container">
                            <ol className="breadcrumb">
                                <li className="breadcrumb-item"><a href="/">Home</a></li>
                                <li className="breadcrumb-item"><a href="/list">Products</a></li>
                                <li className="breadcrumb-item active">Shop Details</li>
                            </ol>
                        </div>
                    </section>
                    <section className="shop-details-page pt-30">
                        <div className="container">
                            <div className="row">
                                <div className="col-lg-6">
                                    <div className="shop-details-image mt-50">
                                        <div className="shop-slid-image">
                                            <div className="single-shop-image">
                                                <img src={product.image} alt="details"/>
                                            </div>
                                            <div className="single-shop-image">
                                                <img src={product.image} alt="details"/>
                                            </div>
                                            <div className="single-shop-image">
                                                <img src={product.image} alt="details"/>
                                            </div>
                                            <div className="single-shop-image">
                                                <img src={product.image} alt="details"/>
                                            </div>
                                            <div className="single-shop-image">
                                                <img src={product.image} alt="details"/>
                                            </div>
                                        </div>
                                        <div className="shop-thumb">
                                            <div className="single-thumb">
                                                <img src={product.image} alt="Thumb"/>
                                            </div>
                                            <div className="single-thumb">
                                                <img src={product.image2} alt="Thumb"/>
                                            </div>
                                            <div className="single-thumb">
                                                <img src={product.image3} alt="Thumb"/>
                                            </div>
                                            <div className="single-thumb">
                                                <img src={product.image4} alt="Thumb"/>
                                            </div>
                                            <div className="single-thumb">
                                                <img src={product.image5} alt="Thumb"/>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div className="col-lg-6">
                                    <div className="shop-details-content">
                                        <div className="shop-details-content mt-45">
                                            <h4 className="title">{product.title} <br/> T-shirt Point</h4>
                                            <div className="rating-review d-flex">
                                                {/*<ul className="rating">*/}
                                                {/*    {star}*/}
                                                {/*</ul>*/}
                                                <p className="review">Reviews</p>
                                            </div>
                                            {/*<p className="interested">Interested : <span>05</span></p>*/}

                                            <div className="price">
                                                <span className="sale-price">{product.salePrice}</span>
                                                <span className="regular-price">{product.sellPrice}</span>
                                            </div>
                                            <div className="product-size-color d-flex justify-content-between">
                                                <ul className="product-size">
                                                    {sizes.map((size, sizeIndex) =>

                                                        <li onClick={() => { this.changeActiveSize(sizeIndex) }}
                                                            className={this.selectedSizeClass(sizeIndex)} >
                                                            <span>{size.size}</span>
                                                        </li>

                                                    )

                                                    }
                                                </ul>
                                                <ul className="product-color">
                                                    {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                                            <li style={{backgroundColor: color.color.toLowerCase()}} onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}
                                                                className={this.selectedColorClass(sizeIndex, colorIndex)}>
                                                                <span> </span>
                                                            </li>
                                                        ) : null
                                                    )}
                                                </ul>
                                            </div>

                                            <div className="quantity-stock d-sm-flex align-items-center">
                                                <div className="quantity d-flex align-items-center">
                                                    <p>Quantity:</p>
                                                    <div className="quantity-form">
                                                        <div className="product-quantity d-flex" id="quantity">
                                                            {/*<button type="button" className="sub">-</button>*/}
                                                            {/*<input type="text" id="1" value="1"/>*/}
                                                            {/*<button type="button" className="add">+</button>*/}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div className="product-stock d-flex">
                                                    <p className="value">Availability :</p>
                                                    <p className="stock">IN STOCK</p>
                                                </div>
                                            </div>
                                            <div className="product-share">
                                                <ul>
                                                    <li className="head">Share :</li>
                                                    <li><a href="#"><i className="fab fa-facebook-f"> </i></a></li>
                                                    <li><a href="#"><i className="fab fa-google-plus-g"> </i></a></li>
                                                    <li><a href="#"><i className="fab fa-twitter"> </i></a></li>
                                                    <li><a href="#"><i className="fab fa-skype"> </i></a></li>
                                                    <li><a href="#"><i className="fas fa-rss"> </i></a></li>
                                                </ul>
                                            </div>
                                            <div className="product-cart-btn">
                                                <a className="cart-btn" href="#"><i
                                                    className="flaticon-shopping-cart"> </i>
                                                    <span>Add to cart</span></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>


                    <a href="#" className="back-to-top"><i className="fal fa-chevron-up"> </i></a>


                </div>

            )
        }
};


ProductCardDetails.propTypes = {
    product: PropTypes.shape({
        image: PropTypes.string,
        image2: PropTypes.string,
        image3: PropTypes.string,
        image4: PropTypes.string,
        image5: PropTypes.string,
        id: PropTypes.string,
        title: PropTypes.string,
        salePrice: PropTypes.number,
        sellPrice: PropTypes.number,
        description: PropTypes.string,
        stars: PropTypes.number
    })
};

