import  React, { Component } from 'react'
import footerLogo from '../../../../../public/assets/images/footer-logo.png';
import payments from '../../../../../public/assets/images/payments.png';

export default class FooterPart extends Component {

    constructor(props) {
        super(props);
        this.state = {

        }
        // this.handleClick = this.handleClick.bind(this);
    }


    render () {
        const logo = this.props.logo;
        const companyName = this.props.company;
        const tel = this.props.tel;
        const address = this.props.address;
        const email = this.props.email;
        let isLogged = this.props.isLogged;
        let conf = this.props.config;
        return (
            <section className="footer-area footer-3">
                <div className="container">
                    <div className="footer-widget pt-30 pb-80">
                        <div className="row">
                            <div className="col-lg-4">
                                <div className="footer-about pt-50">
                                    <a href="/">
                                        <img src={logo} alt="Logo"/>
                                        <span className="companyName">{companyName}</span>
                                    </a>
                                    <ul className="footer-info">
                                        <li>
                                            <div className="single-info d-flex">
                                                <div className="info-icon">
                                                    <i className="far fa-map-marker-alt"> </i>
                                                </div>
                                                <div className="info-content media-body">
                                                    <p>{address}</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div className="single-info d-flex">
                                                <div className="info-icon">
                                                    <i className="fal fa-envelope"> </i>
                                                </div>
                                                <div className="info-content media-body">
                                                    <p><a
                                                        href={`mailto:${email}`}>{email}</a>
                                                    </p>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div className="single-info d-flex">
                                                <div className="info-icon">
                                                    <i className="far fa-phone"> </i>
                                                </div>
                                                <div className="info-content media-body">
                                                    <p><a href={`tel:${tel}`}>{tel}</a></p>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div className="col-lg-5">
                                <div className="footer-link d-flex flex-wrap">
                                    <div className="footer-link-wrapper pt-50">
                                        <h5 className="footer-title">NOS SERVICES</h5>
                                        <ul className="link-list mt-30">
                                            <li><a href="/about">Qui sommes nous</a></li>
                                            <li><a href="/privacy">Politique de confidentialité</a></li>
                                            {/*<li><a href="#">FAQ</a></li>*/}
                                            <li><a href="/termsConditions">Termes et conditions</a></li>
                                            <li><a href="/contact"> Support et informations de livraison</a></li></ul>
                                    </div>
                                    {
                                        isLogged ?
                                            <React.Fragment>
                                                <div className="footer-link-wrapper pt-50">
                                                    <h5 className="footer-title">Mon compte</h5>
                                                    <ul className="link-list mt-30">
                                                        <li><a href="/myprofile">Mon compte</a></li>
                                                        <li><a href="/orders">Mes commandes</a></li>
                                                        <li><a href="/changePass">Changer le mot de passe</a></li>
                                                        <li><a href="/updateInfo">Informations personnelles</a></li>
                                                    </ul>
                                                </div>
                                            </React.Fragment>
                                            :
                                            null
                                    }

                                </div>
                            </div>
                            <div className="col-lg-3">
                                <div className="footer-follow mt-50">
                                    <h5 className="footer-title">SUIVEZ NOUS</h5>
                                    <ul className="footer-social">
                                        { conf.facebook!=null ?
                                        <li style={{cursor: 'pointer'}}><a href={conf.facebook}><i className="fab fa-facebook-f"> </i></a></li> :  null}
                                        { conf.instagram!=null ?
                                            <li style={{cursor: 'pointer', left: '-5%'}}><a href={conf.instagram}><i className="fab fa-instagram"></i></a></li> :  null}
                                            { conf.twitter!=null ?
                                                <li style={{cursor: 'pointer'}}><a href={conf.twitter}><i className="fab fa-twitter"> </i></a></li> : null}

                                    </ul>
                                </div>
                                {/*<div className="footer-payments">*/}
                                {/*    <img src={payments} alt="payments"/>*/}
                                {/*</div>*/}


                            </div>
                        </div>
                    </div>
                    <div className="footer-copyright text-center">
                        <p>&copy; 2021 <a href="http://mangopaid.com/">Mangopaid</a> Tous les droits sont réservés.</p>
                    </div>
                </div>
            </section>
        )
    }
}


