import React, { Component } from 'react'
import Store from '../../../utils/store'
import SingleTopProduct from "./SingleTopProduct";



export default class TopProductPart extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            topProducts: [],
            wishlistProds: [],
            cartProds: [],
            store: store
        }
        this.addToWishListProduct = this.addToWishListProduct.bind(this);
        this.addToCartProduct = this.addToCartProduct.bind(this);

    }

    UNSAFE_componentWillMount() {

        this.state.store.api_post_call('getTopProducts', {}).then(res=> {
            this.setState({topProducts: res.data.values});
            // console.log('topProducts', res.data)

        }).catch(err => {
            console.log(err);
        })

    }

    addToWishListProduct(topProduct){
        let storeData = this.state.store.addToWishListProduct(topProduct);
        this.setState({wishlistProds: storeData.wishList});
        // console.log('testsStorage', this.state.wishlistProds );
    }

    addToCartProduct(topProduct, index){
        let storeData = this.state.store.addToCartProductOnCLick(topProduct, index);
        this.setState({cartProds: storeData.cart});
        // console.log('testAddToCart', this.state.cartProds );
    }
    calculateCurrencies(price) {
        let val = this.state.store.calculateCurrencies(this.props.calculateCurrencies, price);
        return val;
    }




    render () {
        let topProds = this.state.topProducts;
        let wishlistProds = this.state.wishlistProds;
        let cartProds = this.state.cartProds;
        let currency = this.props.currency;


        let changedCurrency = this.state.store.get().currency;
        console.log('changed currencyyyyyyyy', changedCurrency);


        return (
            // <section className="product-area pt-75 ">
            //     <div className="container">
            //         <div className="row justify-content-center">
            //             <div className="col-lg-8">
            //                 <div className="section-title text-center pb-25">
            //                     <h4 className="title">Deals Products</h4>
            //                     <p>Get last chance to buy our top products with special price.</p>
            //                 </div>
            //             </div>
            //         </div>
            //         <div className="row">
            //             {/*product*/}
            //
            //             {
            //                 topProds.map((topProduct, indexProduct)=>
            //                     <div  className="col-lg-6" key={'home_top_product_'+topProduct.id}>
            //                         <SingleTopProduct key={indexProduct}
            //                                           topProduct={topProduct}
            //                                           indexProduct={indexProduct}
            //                                           addToWishListProduct={this.addToWishListProduct}
            //                                           addToCartProduct={this.addToCartProduct}
            //                                           wishlistProds={wishlistProds}
            //                                           cartProds={cartProds}/>
            //                     </div>
            //                 )
            //             }
            //
            //         </div>
            //     </div>
            // </section>
        <section className="product-area pt-70 pb-75">
            <div className="container">
                <div className="row justify-content-center">
                    <div className="col-lg-8">
                        <div className="section-title text-center pb-25">
                            <h4 className="title mont">Meilleures ventes</h4>
                        </div>
                    </div>
                </div>
                <div className="row">
                    {
                        topProds.map((topProduct, indexProduct)=>
                            // <div  key={'home_top_product_'+topProduct.id}>
                                <SingleTopProduct key={'home_top_product_'+topProduct.id}
                                                  topProduct={topProduct}
                                                  currency={currency}
                                                  indexProduct={indexProduct}
                                                  addToWishListProduct={this.addToWishListProduct}
                                                  addToCartProduct={this.addToCartProduct}
                                                  wishlistProds={wishlistProds}
                                                  cartProds={cartProds}
                                                  calculateCurrencies = {this.props.calculateCurrencies}

                                />
                            // </div>
                        )
                    }

                </div>
                <div className="more-product text-center mt-30">
                    <a href="/list" className="more">Voir tous les produits</a>
                </div>
            </div>
        </section>

        )
    }
}


