import React, { Component } from 'react'
import Store from "../../../utils/store";
import Swal from "sweetalert2";



export default class SingleTopProduct extends Component {

    constructor(props) {
        super(props);
        this.state = {
            topProduct: null,
            errorMessage: '',
            status:''
        }
        this.changeActiveColor = this.changeActiveColor.bind(this);
        this.changeActiveSize = this.changeActiveSize.bind(this);
        this.calcPrice = this.calcPrice.bind(this);
        this.selectedColorClass = this.selectedColorClass.bind(this);
        this.selectedSizeClass = this.selectedSizeClass.bind(this);
        this.addToCart = this.addToCart.bind(this);
        this.handleSubmit=this.handleSubmit.bind(this);
        this.wishHandleSubmit=this.wishHandleSubmit.bind(this);

    }

    UNSAFE_componentWillMount() {
        const self = this;
        setTimeout(function(){

            let topProduct = self.props.topProduct;
            topProduct.active=false;
            topProduct.sizes.map(function(size){
                size.active=false;
                // product.colors.map(function(color){
                //     color.active=false;
                // });
            });
            self.setState({topProduct: topProduct});
            console.log('products will mount',self.state.topProduct);
        },100);

        setTimeout(function () {
            let sizes = this.state.topProduct.sizes;
            let min=0;
            for(let i=0;i<sizes.length;i++){
                if(sizes[i].stock > min){
                    min=sizes[i].stock;
                }
                if(min>0)
                {
                    this.setState({status: "EN STOCK"})
                }
                else
                {
                    this.setState({status: "EN RUPTURE DE STOCK"})
                }
            }
        }, 150);
    }



    changeActiveSize(sizeIndex) {
        const self = this;
        let topProduct = this.state.topProduct;
        topProduct.sizes.map((size)=>{
            size.active =false;
        });
        topProduct.sizes[sizeIndex].active = true;

        this.setState({topProduct: topProduct});
    }

    changeActiveColor(sizeIndex, colorIndex) {
        let topProduct = this.state.topProduct;
        console.log(topProduct);
        topProduct.sizes.map((size)=>{
            if(size.active===true) {
                size.colors.map((color) => {
                    color.active = false;
                }); }
        });
        topProduct.sizes[sizeIndex].colors[colorIndex].active = true;

        this.setState({topProduct: topProduct});
    }

    selectedColorClass(sizeIndex, colorIndex){
        const self = this;
        let returnValue = '';
        // console.log('funkcija',this.state.product.sizes[sizeIndex]);
        // if(this.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
        //     return 'active';
        // }
        // else return '';
        if(self.state.topProduct != null){
            if(self.state.topProduct.sizes[sizeIndex].colors[colorIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    selectedSizeClass(sizeIndex){
        const self = this;
        let returnValue = '';
        if(self.state.topProduct != null){
            if(self.state.topProduct.sizes[sizeIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    addToWishList(){
        const topProduct = this.props.topProduct;
        this.props.addToWishListProduct(topProduct);
    }


    addToCart(index){
        const topProduct = this.props.topProduct;
        this.props.addToCartProduct(topProduct, index);
    }
    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }


    handleSubmit(index){
        let valid = true;
        let topProduct = this.props.topProduct;
        for(let i = 0; i <topProduct.sizes.length; i++) {
            if (topProduct.sizes[i].active === true) {
                for (let k = 0; k < topProduct.sizes[i].colors.length; k++) {
                    if (topProduct.sizes[i].colors[k].active === true) {
                        this.setState({
                            ...this.state,
                            errorMessage: ""
                        });
                        valid=true;
                        break;
                    } else {
                        this.setState({
                            ...this.state,
                            errorMessage: "Veuillez sélectionner la couleur"
                        });
                        valid = false;
                    }
                }
                break;
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: "Veuillez sélectionner la taille"
                });
                valid = false;
            }
        }
        if(this.state.status === "EN RUPTURE DE STOCK"){
            valid = false;
            Swal.fire("L'article est en rupture de stock");
        }

        if(valid){
            this.addToCart(index);
            Swal.fire({
                title: '<strong>Added to cart<strong>',
                icon: 'success',
                showCloseButton: true,
                showCancelButton: true,
                focusConfirm: false,
                confirmButtonText:
                    '<a className="white" href="/list">Continue shopping</a>' ,
                confirmButtonColor: '#fff',
                cancelButtonText:
                    '<a className="white" href="/cart">Go to cart</a>'
            });
        }

    }

    wishHandleSubmit(index){
        let valid = true;
        let topProduct = this.props.topProduct;
        for(let i = 0; i <topProduct.sizes.length; i++) {
            if (topProduct.sizes[i].active === true) {
                for (let k = 0; k < topProduct.sizes[i].colors.length; k++) {
                    if (topProduct.sizes[i].colors[k].active === true) {
                        this.setState({
                            ...this.state,
                            errorMessage: ""
                        });
                        valid=true;
                        break;
                    } else {
                        this.setState({
                            ...this.state,
                            errorMessage: "Veuillez sélectionner la couleur"
                        });
                        valid = false;
                    }
                }
                break;
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: "Veuillez sélectionner la taille"
                });
                valid = false;
            }
        }

        if(valid){
            this.addToWishList();

        }

    }


    render () {
        let topProduct = this.props.topProduct;
        let indexProduct = this.props.indexProduct;
        let sizes = topProduct.sizes;
        let description = topProduct.description;
        let title = topProduct.title;
        if (description.length > 5) {
            description = description.substring(0, 5) + "...";
        }
        if (title.length > 10) {
            title = title.substring(0, 10) + "...";
        }

        let currency = this.props.currency;




        return (

            // <div className="single-product-horizontal d-flex flex-wrap mt-30">
            //     <div className="product-image">
            //         <a href="#">
            //             <img className="product-1 product1-size" src={topProduct.image} alt="product"/>
            //             {/*<img className="product-1 product1-size" src={topProduct.image} alt="product"/>*/}
            //             <img className="product-2 product2-size" src={topProduct.image} alt="product"/>
            //         </a>
            //     </div>
            //     {/*<div className="product-content pt-0">*/}
            //     <div className="product-content">
            //         <h4 className="title" key={topProduct.id}><a href={`/detailed/${topProduct.id}`} style={{textTransform: 'uppercase'}} >{title}| {description}</a></h4>
            //         <span className="sale-price">${topProduct.price}</span>
            //         {/*<span className="regular-price">${topProduct.price}</span>*/}
            //
            //         <div className="product-rating-color d-flex flex-wrap">
            //             <ul className="product-rating">
            //                 {sizes.map((size, sizeIndex) =>
            //
            //                     <li onClick={() => { this.changeActiveSize(sizeIndex) }}
            //                         key={'top_product_color_'+sizeIndex}
            //                         className={this.selectedSizeClass(sizeIndex)} >
            //                         <span>{size.size}</span>
            //                     </li>
            //                 )
            //                 }
            //             </ul>
            //             <ul className="product-color">
            //
            //                 {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
            //                         <li style={{backgroundColor: color.color.toLowerCase()}} onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}
            //                             key={'top_product_color_'+sizeIndex+'_'+colorIndex}
            //                             className={this.selectedColorClass(sizeIndex, colorIndex)}>
            //                             <span>  </span>
            //                         </li>
            //                     ) : null
            //                 )}
            //             </ul>
            //         </div>
            //         <span style={{color: "red"}} >{this.state.errorMessage}</span>
            //
            //         <div className="product-cart-btn">
            //             <a className="cart-btn" onClick={() => { this.handleSubmit() }}><i className="flaticon-shopping-cart"> </i>
            //                 <span className="flaticon-shopping-cart">Add to cart</span></a>
            //             <a className="wishlist"  onClick={() => { this.wishHandleSubmit() }}><i className="flaticon-heart"> </i></a>
            //         </div>
            //
            //
            //         <div className="product-countdown">
            //             <div data-countdown="2020/11/20"> </div>
            //         </div>
            //     </div>
            // </div>

            <div className="col-lg-3 col-sm-6">
                <div className="single-product mt-30">
                    <div className="product-image">
                        <a href={`/detailed/${topProduct.id}`}>
                            <img className="product-1" style={{objectFit: 'contain', height: '302px', maxHeight: '302px'}} src={topProduct.image} alt="product"/>
                            { topProduct.images.length>0 ?
                                <React.Fragment>
                                    <img className="product-2" style={{objectFit: 'contain', height:'302px', maxHeight: '302px'}}
                                         src={topProduct.images[0].image} alt="product"/>
                                </React.Fragment> :
                                <React.Fragment>
                                    <img className="product-2" style={{objectFit: 'contain', height:'312px', maxHeight: '312px'}}
                                         src={topProduct.image} alt="product"/>
                                </React.Fragment>

                            }
                        </a>
                    </div>
                    <div className="product-content text-center">
                        <div className="product-content-top">

                            <h4 className="title"><a href={`/detailed/${topProduct.id}`} style={{textTransform: 'uppercase'}}>{title}| {description} </a>
                            </h4>
                            <span className="sale-price" style={{color: '#6e6e6e', fontSize: '14px'}}>{topProduct.price} {currency}</span>
                            {/*<span className="regular-price">$299</span>*/}
                            <p style={{color: "red", fontSize:'12px'}} >{this.state.errorMessage}</p>

                        </div>
                        <div className="product-cart">
                            <div className="product-size-color d-flex justify-content-between mt-0 pt-0" >
                                <ul className="product-size center-elem">
                                    {sizes.map((size, sizeIndex) =>

                                                            <li onClick={() => { this.changeActiveSize(sizeIndex) }}
                                                                key={'top_product_color_'+sizeIndex}
                                                                className={this.selectedSizeClass(sizeIndex)} >
                                                                <span  style={{padding: '15px !important'}} >{size.size}</span>
                                                            </li>
                                                        )
                                                        }
                                </ul>
                                <ul className="product-color">
                                    {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                            <li style={{backgroundColor: color.color_code, border: '1px solid #bebebe', height: '18px', width: '18px'}} onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}
                                                key={'top_product_color_'+sizeIndex+'_'+colorIndex}
                                                className={this.selectedColorClass(sizeIndex, colorIndex)}>
                                                <span>  </span>
                                            </li>
                                        ) : null
                                    )}
                                </ul>
                            </div>

                            <div>
                                {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                        color.active ?
                                            <React.Fragment>
                                                {color.stock > 0 ?
                                                    <React.Fragment>
                                                        <label style={{
                                                            color: '#008000',
                                                            fontSize: '12px'
                                                        }}> disponible: {color.stock} </label>
                                                    </React.Fragment>
                                                    :
                                                    <React.Fragment>
                                                        <label style={{
                                                            color: 'rgb(255, 57, 65)',
                                                            fontSize: '12px'
                                                        }}> disponible: {color.stock} </label>
                                                    </React.Fragment>
                                                }

                                            </React.Fragment>
                                            :
                                            null

                                    )
                                    :
                                    null
                                )}
                            </div>

                            <div style={{cursor: 'pointer'}} className="product-cart-btn mt-0 pt-0" onClick={() => { this.handleSubmit() }}>
                                <a className="cart-btn" ><i className="flaticon-shopping-cart"> </i>
                                    <span>Ajouter au chariot</span></a>
                            </div>
                        </div>
                    </div>
                    <div className="product-countdown">
                        <div data-countdown="2020/11/20"> </div>
                    </div>
                </div>
            </div>
        )
    }
}


