import React, { Component } from 'react'
import HomeProduct from "./HomeProduct";
import Store from '../../../../utils/store'



export default class HomeProductsList extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            errorMessage: '',
            products: [],
            wishlistProds: [],
            store: store
        }

        this.addToWishListProduct = this.addToWishListProduct.bind(this);
        // this.handleClick = this.handleClick.bind(this);
    }

    UNSAFE_componentWillMount() {

        let storeValues = JSON.parse(localStorage.getItem(this.state.store.storeId));
        let filter = '';
        // let search = storeValues.search;
        let search = '';

        let params={
            filter: JSON.stringify(filter),
            search: search

        }

        this.state.store.api_post_call('getProducts', params).then(res=> {
            this.setState({products:  res.data.values.data, allProducts: res.data.values.data});
            console.log('products', res.data)

        }).catch(err => {
            console.log(err);
        })

        this.state.store.api_post_call('getSingleProduct', {id: 1}).then(res=> {
            console.log('product', res.data)

        }).catch(err => {
            console.log(err);
        })

    }



    addToWishListProduct(product){
        let storeData = this.state.store.addToWishListProduct(product);
        this.setState({wishlistProds: storeData.wishList});
        console.log('testsStorage', this.state.wishlistProds );
    }



    render () {
        let products = this.state.products;
        let wishlistProds = this.state.wishlistProds;
        let currency = this.props.currency;
        return (
            <section className="product-area pt-25" style={{backgroundColor: 'rgb(255, 247, 251)'}}>
                <div className="container">
                    <div className="row justify-content-center">
                        <div className="col-lg-8">
                            <div className="section-title text-center pb-5">
                                <h4 className="title mont">Collection</h4>
                                <p> <a style={{color: '#222'}} href="/list"> <u> Cliquez ici
                                </u>  </a>  pour voir notre nouvelle collection.</p>
                            </div>
                        </div>
                    </div>
                    <div className="row">


                        {products && products.slice(0, 6).map((product, index) => <div className="col-lg-4 col-sm-6" key={'home_product_'+product.id}><HomeProduct
                            product={product} currency={currency} id={product.id} addToWishListProduct={this.addToWishListProduct} wishlistProds={wishlistProds}
                            calculateCurrencies = {this.props.calculateCurrencies} /> </div>)}


                    </div>
                    <div className="more-product text-center mt-30 mb-30">
                        <a href="/list" className="more">Voir tous les produits</a>
                    </div>
                    {/*<div className="more-product text-center">*/}
                    {/*    <a href="/list" className="more pb-50">Voir tous les produits</a>*/}
                    {/*</div>*/}
                </div>
            </section>
        )
    }
}


