import React, { Component } from 'react'
import slider2 from "../../../../../public/assets/images/cover31.jpg";
import WishProduct from "./WishProduct";
import Store from '../../utils/store'
import {Link} from "react-router-dom";

export default class Wishlist extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            inputValue: 1,
            wishlistProds:[],
            cartProds:[],
            store:store
        }
        this.deleteWishProduct=this.deleteWishProduct.bind(this);
        this.addToCartProduct=this.addToCartProduct.bind(this);

    }

    async componentDidMount() {
        let storeData = await this.state.store.get();
        const self = this;
        self.setState({wishlistProds: storeData.wishList});
    }

    deleteWishProduct(index){
        let storeData = this.state.store.deleteWishProduct(index);
        this.setState({wishlistProds: storeData.wishList});
    }


    addToCartProduct(product, index){
        let storeData = this.state.store.addToCartProduct(product, index);
        this.setState({cartProds: storeData.cart});
    }



    render () {
        let currency = this.props.currency;

        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Accueil</a></li>
                            <li className="breadcrumb-item active">Liste de souhaits</li>
                        </ol>
                    </div>
                </section>
                <section className="cart-page pt-80 pb-100">
                    <div className="container">
                        <div>
                            <Link to="/list"  className="continue-shopping-button"> Continuer vos achats <i className="fal fa-chevron-right pl-2 small"> </i></Link>
                        </div>
                        <div className="row">
                            <div className="col-lg-12">

                                <div className="cart-table table-responsive">

                                    {this.state.wishlistProds.length === 0 ?
                                        <table className="table table-bordered" style={{border: '1px solid #dee2e6',
                                            padding: '15px'}}>
                                            <tr style={{backgroundColor: 'rgb(235, 241, 246)'}}>
                                                <i style={{padding: '15px',
                                                    marginBottom: '0',
                                                    fontSize: '25px',
                                                    color: '#555'}}
                                                   className="fas fa-exclamation-triangle"> </i> <span> <h5 style={{color: '#555', padding: '15px 0 0 10px'}} >
                                                Tu n'as pas de favoris, <a href='/list'>
                                                découvre tout ce que nous avons pour toi!</a></h5></span>
                                            </tr>
                                        </table>

                                        :

                                        <table className="table table-bordered">
                                            <thead>
                                            <tr style={{backgroundColor: '#252321',
                                                color: '#fff'}}>
                                                <th className="product">Produit</th>
                                                <th className="description">La description</th>
                                                <th className="model">Modèle</th>
                                                {/*<th className="quantite">Quantite</th>*/}
                                                <th className="price">Prix</th>
                                                {/*<th className="total">Total</th>*/}
                                                <th className="total">Ajouter au chariot</th>
                                                <th className="delete">Effacer</th>

                                            </tr>
                                            </thead>
                                            <tbody>
                                            {this.state.wishlistProds.map((product, indexProduct) =>

                                                <WishProduct key={'product_' + indexProduct}
                                                             product={product}
                                                             currency={currency}
                                                             indexProduct={indexProduct}
                                                             addToCartProduct = {this.addToCartProduct}
                                                             deleteWishProduct={this.deleteWishProduct}
                                                             calculateCurrencies={this.props.calculateCurrencies}
                                                />
                                            )
                                            }

                                            </tbody>
                                        </table>
                                    }

                                </div>
                                <div className="cart-btn d-sm-flex justify-content-between">
                                    {/*<div className="btn-left">*/}
                                    {/*    <button className="main-btn"><Link to="/list" className="anotherLinkColor">Continue Shopping</Link>*/}
                                    {/*    </button>*/}
                                    {/*</div>*/}
                                        <a className="main-btn" href="/cart">Aller au panier</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        )
    }
}
