import React, { Component } from 'react'
import slider2 from "../../../../../public/assets/images/cover.jpg"
import { Link } from 'react-router-dom';
import WishProduct from "./WishProduct";

export default class Review extends Component {

    constructor(props) {
        super(props);
        this.state = {
            inputValue: 1,
            wishListProducts:[]

        }

        this.decrement=this.decrement.bind(this);
        this.increment=this.increment.bind(this);
        this.deleteWishProduct=this.deleteWishProduct.bind(this);

    }

    componentDidMount(){

        let localState = JSON.parse(localStorage.getItem('state'));
        let wishlistProds = localState.wishlistProds;
        this.setState({wishListProducts: wishlistProds});
    }

    deleteWishProduct(index){
        let localState = JSON.parse(localStorage.getItem('state'));
        localState.wishlistProds.splice(index, 1);
        localStorage.setItem('state', JSON.stringify(localState));
        this.setState({wishListProducts: localState.wishlistProds});
    }



    decrement(){
        const defaultValue = this.state.inputValue;
        this.setState({
            inputValue: defaultValue - 1
        });
    }

    increment(){
        const defaultValue = this.state.inputValue;
        this.setState({
            inputValue: defaultValue + 1
        });
    }



    render () {
        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                <div className="container">
                    <ol className="breadcrumb">
                        <li className="breadcrumb-item"><a href="/">Home</a></li>
                        <li className="breadcrumb-item active">Cart</li>
                    </ol>
                </div>
            </section>
                <section className="cart-page pt-80">
                    <div className="container">
                        <div className="row">
                            <div className="col-lg-12">
                                <div className="cart-table table-responsive">
                                    <table className="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th className="product">Product</th>
                                            <th className="description">Description</th>
                                            <th className="model">Model</th>
                                            <th className="edit">Edit</th>
                                            <th className="quantite">Quantite</th>
                                            <th className="price">Unit Price</th>
                                            <th className="total">Total</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        {this.state.wishListProducts.map((product, indexProduct) =>

                                            <WishProduct key={'product_'+indexProduct}
                                                         p={product}
                                                         indexProduct={indexProduct}
                                                         deleteWishProduct={this.deleteWishProduct}
                                            />
                                        )}


                                        </tbody>
                                    </table>
                                </div>
                                <div className="cart-btn d-sm-flex justify-content-between">
                                    <div className="btn-left">
                                        <button className="main-btn" > <Link to="/list">Continue Shopping</Link> </button>
                                    </div>
                                    <div className="btn-right">
                                        <a className="main-btn" href="#">Update Shopping Cart</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-lg-4">
                                <div className="cart-form mt-50">
                                    <h5 className="cart-title"> Estimate Shopping And Tax</h5>
                                    <div className="single-cart-form">
                                        <label>Country</label>
                                        <input type="text"/>
                                    </div>
                                    <div className="single-cart-form">
                                        <label>State/Province</label>
                                        <input type="text"/>
                                    </div>
                                    <div className="single-cart-form">
                                        <label>Zip/Postal Code</label>
                                        <input type="text"/>
                                    </div>
                                    <div className="single-cart-form">
                                        <button className="main-btn">Get Quote</button>
                                    </div>
                                </div>
                            </div>
                            <div className="col-lg-4">
                                <div className="cart-form mt-50">
                                    <h5 className="cart-title"> Discount Code</h5>
                                    <div className="single-cart-form">
                                        <label>Enter your coupon code if you have one.</label>
                                        <input type="text"/>
                                    </div>
                                    <div className="single-cart-form">
                                        <button className="main-btn">Apply</button>
                                    </div>
                                </div>
                            </div>
                            <div className="col-lg-4">
                                <div className="cart-total text-right mt-50">
                                    <p>Subtotal <span>$999.00</span></p>
                                    <p>Grand Total <span>$999.00</span></p>
                                    <a href="#" className="main-btn">Product to Checkout</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>






            </div>


        )
    }
}


