import React, { Component } from 'react'
import Store from '../../utils/store'



export default class CartProduct extends Component {

    constructor(props) {
        const store = new Store('mangopaid');

        super(props);

        this.state = {
            store:store,
            quantity: 1,
            totalPrice: this.props.product.price

        }

        this.decrement=this.decrement.bind(this);
        this.increment=this.increment.bind(this);
        this.setStore=this.setStore.bind(this);
        this.calcPrice=this.calcPrice.bind(this);

    }

    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }


    decrement(product) {

        if(product.quantity===1)
            product.quantity = 1;
        else
            product.quantity = product.quantity - 1;
        product.totalPrice = product.price * product.quantity;

        this.setState({quantity:product.quantity,
            totalPrice: product.totalPrice
        });
        this.setStore(product)

    }



    increment(product){
        product.quantity = product.quantity + 1;
        product.totalPrice = product.price * product.quantity;

        this.setState({quantity:product.quantity,
            totalPrice: product.totalPrice
        });
        this.setStore(product)
    }


    setStore(product){
        this.state.store.editProduct(product, this.props.indexProduct);
    }

    render () {

        let product = this.props.product;
        console.log('quantity', product.quantity);

        let indexProduct = this.props.indexProduct;
        let currency=this.props.currency;

        let description = product.description;
        let title = product.title;

        if (description.length > 30) {
            description = description.substring(0, 30) + "...";
        }
        if (title.length > 15) {
            title = title.substring(0, 15) + "...";
        }


        return (

            <tr>
                <td>
                    <div className="product-img"><img
                        src={product.image} alt="Product"/></div>
                </td>
                <td>
                    <div className="product-description">
                        {/*a href da vodi do linkot na komponentata ProductCardDetails koja gi prima parametrite od soodvetniot produkt*/}
                        <h6 className="product-title"><a href="#">
                            {description}{product.quantity}
                        </a></h6>
                        {/*{product.description}*/}


                        <div><i className="sizes-size">Taille: {product.sizes.map((s,sizeIndex) =>
                            <span>
                                {s.active === true ?
                                    <span>  {s.size} </span> : null
                                }
                            </span>
                        )
                        }
                        </i>
                        </div>
                        <div className="product-size-color">
                            <ul className="product-color">
                                <i className="sizes-size">{product.sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                        <React.Fragment>
                                            {color.active ?
                                                <li style={{backgroundColor: color.color_code, border: '1px solid lightgray'}}
                                                    className='color-circle'>
                                                    <span>  </span>
                                                </li> : null
                                            }
                                        </React.Fragment>

                                    ) : null
                                )}
                                </i>
                            </ul>

                        </div>

                    </div>
                </td>
                <td>
                    <div className="product-model">
                        <p>
                            {title}
                        </p>
                    </div>
                </td>
                <td>
                    <div className="product-quantity">
                        <div className="quantity-form">
                            <div className="product-quantity d-flex">
                                <button type="button" className="sub" onClick={()=>this.decrement(product)}>-</button>
                                <input type="text" id="1" value={product.quantity}/>
                                <button type="button" className="add" onClick={()=>this.increment(product)}>+</button>
                            </div>
                        </div>
                    </div>
                </td>
                <td>
                    <div className="product-price">
                        <p> {product.price} {currency}
                            {/*{wishProduct.sellPrice}*/}
                        </p>
                    </div>
                </td>
                {product.totalPrice===null ?

                    <td>
                        <div className="product-total">
                            <p> {product.price} {currency}</p>
                        </div>
                    </td> :
                    <td>
                        <div className="product-total">
                            <p> {product.totalPrice} {currency}</p>
                        </div>
                    </td>
                }

                <td style={{width:'7%'}}>
                    <div className="product-edit">
                        <button className='btn btn-sm bin' onClick={()=>this.props.deleteCartProduct(indexProduct)}><i className="fal fa-trash-alt"> </i></button>
                        <ul>
                            {/*<li><a href="#"><i className="fal fa-pencil-alt"> </i></a></li>*/}
                            <li></li>
                        </ul>
                    </div>
                </td>

            </tr>
        )


    }

}
