import React, { Component } from 'react'
import slider2 from "../../../../../public/assets/images/cover31.jpg"
import { Link } from 'react-router-dom';
import Store from '../../utils/store'
import CartProduct from "./CartProduct";

export default class Cart extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            inputValue: 1,
            wishlistProds:[],
            cartProds: [],
            store: store,
            grandTotal: 0,
            sh_fee: 0,
            superTotal: 0


        }
        this.deleteCartProduct=this.deleteCartProduct.bind(this);

    }

    async componentDidMount() {
        let storeData = await this.state.store.get();
        const self = this;
        self.setState({cartProds: storeData.cart});
        console.log('cart', this.state.cartProds);
    }


    deleteCartProduct(index){
        let storeData = this.state.store.deleteCartProduct(index);
        this.setState({cartProds: storeData.cart});
    }



    render () {

        let cartProds = this.state.cartProds;
        let currency = this.props.currency;
        let processing_fee = parseFloat(this.props.processing_fee);


        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                <div className="container">
                    <ol className="breadcrumb">
                        <li className="breadcrumb-item"><a href="/">Accueil</a></li>
                        <li className="breadcrumb-item active">Chariot</li>
                    </ol>
                </div>
            </section>
                <section className="cart-page pt-80 pb-100">
                    <div className="container">
                        <div>
                            <Link to="/list"  className="continue-shopping-button">Continuer vos achats <i className="fal fa-chevron-right pl-2 small"> </i></Link>
                        </div>
                        <div className="row">
                            <div className="col-lg-12">

                                <div className="cart-table table-responsive">

                                    {this.state.cartProds.length === 0 ?
                                        <table className="table table-bordered" style={{
                                            border: '1px solid #dee2e6',
                                            padding: '15px'
                                        }}>
                                            <tr style={{backgroundColor: 'rgb(235, 241, 246)'}}>
                                                <i style={{
                                                    padding: '15px',
                                                    marginBottom: '0',
                                                    fontSize: '25px',
                                                    color: '#555'
                                                }}
                                                   className="fas fa-exclamation-triangle"> </i> <span> <h5
                                                style={{color: '#555', padding: '15px 0 0 10px'}}>Ton panier est encore vide, <a href='/list'> découvre tout ce que nous avons pour toi! </a> </h5></span>
                                            </tr>
                                        </table>

                                        :

                                        <table className="table table-bordered">
                                            <thead>
                                            <tr style={{
                                                backgroundColor: '#252321',
                                                color: '#fff'
                                            }}>

                                                <th className="product">Produit</th>
                                                <th className="description">Description</th>
                                                <th className="model">Modèle</th>
                                                <th className="quantite">Quantité</th>
                                                <th className="price">Prix</th>
                                                <th className="total">Prix Total</th>
                                                <th className="edit">Effacer</th>
                                            </tr>
                                            </thead>
                                            <tbody>

                                            {this.state.cartProds.map((product, indexProduct) =>

                                                <CartProduct key={'product_' + indexProduct + '_color'}
                                                             product={product}
                                                             indexProduct={indexProduct}
                                                             currency={currency}
                                                             deleteCartProduct={this.deleteCartProduct}
                                                             calculateCurrencies={this.props.calculateCurrencies}
                                                />
                                            )}
                                            </tbody>
                                        </table>
                                    }
                                    </div>

                                </div>
                            </div>
                        <div className="cart-btn d-sm-flex justify-content-between" style={{float: 'right', border: 0}}>
                                    {/*<a style={{float:'right', paddingRight: '20px'}} className='continue'  href="/checkout" ><i style={{paddingRight: '20px'}}  className="fal fa-chevron-right pt-5"> </i></a>*/}
                                <a className="main-btn" href="/checkout" style={{float: 'right'}}>CHECK-OUT</a>                            </div>
                        </div>
                    </section>
                }

            </div>

        )
    }
}
