import React, { Component } from 'react';
import details from "../../../../../public/assets/images/blog-details.jpg";
import slider2 from "../../../../../public/assets/images/cover31.jpg";
import Store from "../../utils/store";
import TCNoImage from "../TermsAndConditionsPage/TCNoImage";
import TCLeftImage from "../TermsAndConditionsPage/TCLeftImage";
import TCRightImage from "../TermsAndConditionsPage/TCRightImage";
import TCBottomImage from "./TCBottomImage";






export default class TermsAndConditions extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            contentTerms: '',
            store: store
        }
        // this.handleClick = this.handleClick.bind(this);
    }


    async UNSAFE_componentWillMount() {

        await this.state.store.api_post_call('getTerms', {}).then(res=> {
            this.setState({contentTerms: res.data.values});
            console.log('contentTerms', res.data.values)

        }).catch(err => {
            console.log(err);
        })

    }


    render () {
        let contentTerms = this.state.contentTerms;
        console.log('-----Render Content contentTerms-----', contentTerms)

        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Home</a></li>
                            <li className="breadcrumb-item active">Privacy Policy</li>
                        </ol>
                    </div>
                </section>

                <section className="blog-details-area pt-80 pb-100">
                    <div className="container">
                        <div className="blog-details-content">
                            <h2 style={{color: '#555', margin: '50px 0', textAlign: 'left', textTransform: 'uppercase'}}> Privacy Polices</h2>

                            {
                                contentTerms.length > 0 ?

                                    <React.Fragment>
                                        {
                                            this.state.contentTerms.map((part, partIndex) =>
                                                <React.Fragment>
                                                    {part.styling === "No Image" ?
                                                        <React.Fragment>
                                                            <TCNoImage part={part}/>
                                                        </React.Fragment> :
                                                        part.styling === "Image Left" ?
                                                            <React.Fragment>
                                                                <TCLeftImage part={part}/>
                                                            </React.Fragment> :
                                                            part.styling === "Image Right" ?
                                                                <React.Fragment>
                                                                    <TCRightImage part={part}/>
                                                                </React.Fragment> :
                                                                part.styling === "Image Bottom" ?
                                                                    <React.Fragment>
                                                                        <TCBottomImage part={part}/>
                                                                    </React.Fragment>

                                                                : null
                                                    }
                                                </React.Fragment>
                                            )}

                                    </React.Fragment>
                                    : null
                            }
                            <div style={{borderTop: '1px solid #e8e8e8'}}>

                            </div>
                        </div>
                    </div>
                </section>

            </div>


        )
    }
}


