import React, { Component } from 'react'
import Store from "../../utils/store";
import slider2 from "../../../../../public/assets/images/cover.jpg";

export default class Ticket extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            store: store,
            cartProds: [],
            errorMessage: '',
            ticket:{
                subject: '',
                message: ''
            }

        }
        this.inputSubject = this.inputSubject.bind(this);
        this.inputMessage = this.inputMessage.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    inputSubject(event) {
        console.log('subject', event.target.value);
        this.setState({
            ...this.state,
            ticket: {
                ...this.state.ticket,
                subject:event.target.value
            }
        });
    }

    inputMessage(event) {
        console.log('message', event.target.value);
        this.setState({
            ...this.state,
            ticket: {
                ...this.state.ticket,
                message:event.target.value
            }
        });
    }
    handleSubmit(event) {
        let valid=true;
        const subject = this.state.ticket.subject;
        const message = this.state.ticket.message;
        if (!subject || !message) {
            this.setState({
                        ...this.state,
                        errorMessage: "Please fill in all required fields."
                    });
                    valid = false;
        }
    }



        UNSAFE_componentWillMount() {
        // console.log('lista cart', this.state.store.cart )

        let storeData =  this.state.store.get();
        const self = this;
        self.setState({cartProds: storeData.cart});
    }


    render () {

        const dataCart = this.state.cartProds;
        console.log('produkti',dataCart)
        let total = 0;

        for(let i=0;i<dataCart.length;i++)
        {
            total+=parseInt(dataCart[i].quantity*dataCart[i].price);

        }


        return (
            <section>

                <section className="page-banner bg_cover" style={{backgroundImage: "url(" + slider2 + ")"}}>
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Home</a></li>
                            <li className="breadcrumb-item"><a href="/list">My profile</a></li>
                            <li className="breadcrumb-item active">Support</li>
                        </ol>
                    </div>
                </section>
                <div className="container">
                    <div className="checkout-box mt-50 pl-30 ">
                        <div className="checkout-title">
                                <h5 className="title"> CREATE A SUPPORT TICKET</h5>
                        </div>



                        <section>

                            <div className="flex  justify-content-between mb-20 mt-30 mr-30"  >
                                <div>
                                    <span style={{color: "red"}} >{this.state.errorMessage}</span>

                                </div>
                                <br/>

                                <form>
                                    <div className="form-group row">
                                        <label className="col-sm-2 col-form-label">Subject</label>
                                        <div className="col-sm-10">
                                            <input type="text"  className="form-control"  style={{width: "100%"}} onChange={this.inputSubject}
                                                    placeholder="Subject"/>
                                        </div>
                                    </div>
                                    <div className="form-group row">
                                        <label className="col-sm-2 col-form-label">Message</label>
                                        <div className="col-sm-10">
                                            <textarea name="content" type="text" className="form-control" onChange={this.inputMessage}
                                                   placeholder="Message" rows="7"> </textarea>
                                        </div>
                                    </div>
                                    {/*<div className="single-form">*/}
                                    {/*    <button className="main-btn" type="submit">Update</button>*/}
                                    {/*</div>*/}
                                    <button className="main-btn" type="button" onClick={this.handleSubmit}>SEND</button>

                                </form>


                            </div>



                        </section>


                    </div>

                </div>

            </section>

        )
    }
}


