import React, { Component } from 'react'
import Store from "../../utils/store";
import slider2 from "../../../../../public/assets/images/cover.jpg";
import Swal from "sweetalert2";
// import TicketInChat from "./TicketInChat";

export default class Chat extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');

        this.state = {
            errorMessage: '',
                message: '',
            store:store,
            listMessages: [],
            config: {
                address: '',
                tel: '',
                main_email: '',
                hotline_support: '',
                hotline_num: ''
            }

            }

        this.inputMessage = this.inputMessage.bind(this);
        this.sendMessage = this.sendMessage.bind(this);
        this.showTicketInChat = this.showTicketInChat.bind(this);
    }


    async componentDidMount () {
        await this.state.store.api_post_call('getShopConfig', {}).then(res=> {
            this.setState({config:  res.data.values});
            // console.log('config', res.data.values);

        }).catch(err => {
            console.log(err);
        })

    }


    inputMessage(event) {
        this.setState({
            ...this.state,
            message:event.target.value

        });
    }

    // inputMessage = (event) => event.keyCode === 13 ? this.sendMessage() :
    //     this.setState({
    //         ...this.state,
    //         message:event.target.value
    //     });


    showTicketInChat() {
        const subject = this.state.ticket.subject;
        const message = this.state.ticket.message;

        this.props.addTicket({
            subject,
            message
        });
    }

    sendMessage() {
        let valid=true;
        const message = this.state.message;
        // if(!message ^^ message.replace(/\s/g), '').length;
        if (!message) {
            this.setState({
                ...this.state,
                errorMessage: "Please fill in all required fields."
            });
            valid = false;
        }
        if (valid) {
            console.log(this.state.message);
            const message = {
                id: 1+Math.random(),
                value: this.state.message.slice()
            };

            const list = [];
            list.push(message);

            this.setState({
                ...this.state,
                errorMessage: "",
                message:"",
                listMessages: message
            });


            // Swal.fire("Your message has been successfully sent!", "We will contact you very soon! Thank you for contacting us.", "success");
            //prikazi poraka vo chat
            // const add = this.showTicketInChat;
            // add();
        }
    }


    render () {
        const { tickets } = this.props.tickets;
        let nums = this.state.config.hotline_num;
       let numbers = nums.split(",");
       console.log('numbers', numbers);

        return (
            <section>

                <section className="page-banner bg_cover" style={{backgroundImage: "url(" + slider2 + ")"}}>
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ul className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Home</a></li>
                            <li className="breadcrumb-item active"><a>Support</a></li>
                        </ul>
                    </div>
                </section>
                <section className="contact-area pt-30 pb-100">
                <div className="container">

                    <div className='row'>
                            <div className="col-lg-6">
                                <div className="contact-info pt-45">
                                    <h4 className="contact-title">Support Info</h4>
                                    <p className="pt-30">Contact us for additional information.</p>
                                    <ul className="pt-15">
                                        <li>
                                            <div className="single-info d-flex align-items-center">
                                                <div className="icon">
                                                    <i className="fal fa-map-marker-alt"></i>
                                                </div>
                                                <div className="content pl-15">
                                                    <p>{this.state.config.address}</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div className="single-info d-flex align-items-center">
                                                <div className="icon">
                                                    <i className="fal fa-envelope-open-text"></i>
                                                </div>
                                                <div className="content pl-15">
                                                    <p>{this.state.config.main_email}</p>
                                                </div>
                                            </div>
                                        </li>
                                        {this.state.config.hotline_support !== 0 ?
                                            <React.Fragment>
                                                <li>
                                                    <div className="single-info d-flex">
                                                        <div className="icon">
                                                            <i className="fal fa-phone"></i>
                                                        </div>
                                                        <div className=" pl-15">
                                                            {numbers.map(number =>
                                                                <p>{number}</p>
                                                            )}
                                                        </div>
                                                    </div>
                                                </li>
                                            </React.Fragment> : null
                                        }
                                    </ul>
                                </div>
                            </div>

                        <div className="col-lg-6">
                            <div className="contact-form pt-45">
                            <h3 className="contact-title text-center" >HELP CENTER</h3>
                            <div className="messaging">
                                <div className="inbox_msg">
                                    <div className="mesgs">
                                        <div className="msg_history">
                                            <div className="incoming_msg">
                                                {/*<div className="incoming_msg_img">*/}
                                                {/*    /!*<img src="https://ptetutorials.com/images/user-profile.png" alt="sunil"/>*!/*/}
                                                {/*</div>*/}
                                                <div className="received_msg">
                                                    <div className="received_withd_msg">
                                                        <p>Ova e avtomatski generirana poraka. Koj e vasiot problem? </p>
                                                        <span className="time_date"> 11:01 AM    |    June 9</span></div>
                                                </div>
                                                <div className="outgoing_msg">
                                                    <div className="sent_msg">
                                                        <p >Zdravo :) sakam da napravam naracka no imam problem pri vnesuvanje na podatoci za mojata karticka. Dali ke moze da mi pomognete?</p>
                                                        <span className="time_date"> 11:01 AM    |    June 9</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="received_msg">
                                                <div className="received_withd_msg">
                                                    <p>Zdravo Maja, kako mozeme da vi pomogneme?</p>
                                                    <span className="time_date"> 11:01 AM    |    June 9</span></div>
                                            </div>
                                            <div className="outgoing_msg">
                                                <div className="sent_msg">
                                                    {/*<img*/}
                                                    {/*src="https://ptetutorials.com/images/user-profile.png" alt="sunil"/>*/}
                                                </div>
                                                <div className="outgoing_msg">
                                                    <div className="sent_msg">
                                                        <p>Vnesuvam validni podatoci, no vasiot sistem javuva greska.Sto da napravam? </p>
                                                        <span className="time_date"> 11:01 AM    |    Yesterday</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="received_msg">
                                                <div className="received_withd_msg">
                                                    <p>Ve molime kontaktirajte ne na telefonskiot broj ili preku email za podetalni informacii.</p>
                                                    <span className="time_date"> 11:01 AM    |    Today</span></div>
                                            </div>
                                            <div className="incoming_msg">
                                                <div className="incoming_msg_img">
                                                    {/*<img*/}
                                                    {/*src="https://ptetutorials.com/images/user-profile.png" alt="sunil"/>*/}
                                                </div>
                                                <div className="outgoing_msg">
                                                    <div className="sent_msg">
                                                        <p>Vi blagodaram. </p>
                                                        <span className="time_date"> 11:01 AM    |    Today</span></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div className="type_msg">
                                                <div className="input_msg_write">

                                                    <input type="text" className="write_msg" value={this.state.message} onChange={this.inputMessage} placeholder="Type a message"/>

                                                    {/*<span> <i style={{color:"#222", fontSize: "30px", marginTop: "18px"}}  className="fa fa-paperclip attachment" aria-hidden="true"> </i></span>*/}
                                                    <button className="msg_send_btn" type="button" onClick={()=>this.sendMessage()}><i
                                                        className="fa fa-paper-plane" aria-hidden="true"> </i>
                                                    </button>
                                                </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
                </section>

                {/*<div className="blog-details-comment">*/}
                {/*    <div className="row">*/}
                {/*        <div className="col-lg-9">*/}
                {/*            <div className="blog-comment pt-65">*/}
                {/*                <h4 className="comment-title">Support</h4>*/}
                {/*                <ul>*/}
                {/*                    <li>*/}


                {/*                        /!*{*!/*/}
                {/*                        /!*    tickets.map((ticket) => <TicketInChat ticket={ticket} />)}*!/*/}


                {/*                        <ul className="comment-replay">*/}
                {/*                            <li>*/}
                {/*                                <div className="single-comment d-sm-flex align-items-center">*/}
                {/*                                    <div className="comment-author">*/}
                {/*                                        /!*<img src="assets/images/author-2.jpg" alt="Author">*!/*/}
                {/*                                    </div>*/}
                {/*                                    <div className="comment-text media-body">*/}
                {/*                                        <h5 className="author-name">Client</h5>*/}
                {/*                                        <p className="text">What should I do.. (admin reply message)</p>*/}
                {/*                                        <ul className="meta">*/}
                {/*                                            <li><a href="#">Replay</a></li>*/}
                {/*                                        </ul>*/}
                {/*                                    </div>*/}
                {/*                                </div>*/}
                {/*                            </li>*/}
                {/*                        </ul>*/}
                {/*                    </li>*/}
                {/*                </ul>*/}
                {/*            </div>*/}
                {/*        </div>*/}
                {/*    </div>*/}
                {/*</div>*/}


            </section>

        )
    }
}


