import  from 'react'
import './AddEvent.css'
import {  MDBRow, MDBCol, MDBIcon,  MDBInput, MDBBtn  } from "mdbreact"
import { Fragment } from "react"
import './Donate.css'
import {Link} from 'react-router-dom'
import FooterPart from "../mainComponents/FooterPart"


export default class AddProduct extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            name: '',
            description: '',
            price: '',
            status: '',
            image: '',
            errorMessage: ''
        };

        this.inputName = this.inputName.bind(this);
        this.inputDescription = this.inputDescription.bind(this);
        this.inputPrice = this.inputPrice.bind(this);
        this.inputStatus = this.inputStatus.bind(this);
        this.inputImage = this.inputImage.bind(this);
        this.addProduct = this.addProduct.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        this.alertMessage = this.alertMessage.bind(this);



    }


    addProduct() {
        const { name, description, price, status, image } = this.state;

        console.log("Submit ", {
            name,
            description,
            price,
            status,
            image
        })
        this.props.addNewProduct({
            name,
            description,
            price,
            status,
            image
        });
        const alert = this.alertMessage;
        alert();
    }

    inputName(event) {
        this.setState({
            ...this.state,
            name: event.target.value
        });
    }

    inputDescription(event) {
        this.setState({
            ...this.state,
            description: event.target.value
        });
    }

    inputPrice(event) {
        this.setState({
            ...this.state,
            price: event.target.value
        });
    }

    inputStatus(event) {
        this.setState({
            ...this.state,
            status: event.target.value
        });
    }

    inputImage(event) {
        this.setState({
            ...this.state,
            image: event.target.value
        });
    }





    alertMessage=()=>{alert('The product has been added!')}



    handleSubmit() {

        let valid = true;

        const name = this.state.name;
        const description = this.state.description;
        const price = this.state.price;
        const status = this.state.status;
        const image = this.state.image;

        if (!name || !description || !price || !status || !image) {
            this.setState({
                ...this.state,
                errorMessage: "Please fill in all required fields to login."
            });
            valid = false;
        } else if (description.length > 150) {
            this.setState({
                ...this.state,
                errorMessage: "Your description is too long"
            });
            valid = false;
        }

        if (valid) {
            const add = this.addProduct;
            add();
        }


    }


    render() {

        const { errorMessage } = this.state.errorMessage;


        return (
            <div>
                <div className="add-event-container">
                    <div className="add-event-title lead grey-text w-responsive text-center mx-auto mb-5" style={{  fontSize: 40, width: 'bold' }}><b>Add a product:</b></div>
                    <hr/>


                    {/* <div className="lead grey-text w-responsive text-center mx-auto mb-5">
                    Name: <input className="add-event-options" placeholder="Add a short, clear name" type='text'
                                 name='name'
                                 value={this.state.name} onChange={this.inputName} required/><br/>

                    Date: <input className="add-event-options" placeholder="DD/MM/YY" type='text' name='date'
                                 value={this.state.date} onChange={this.inputDate} required/><br/>
                    Time: <input className="add-event-options" placeholder="00:00" type='text' name='time'
                                 value={this.state.time} onChange={this.inputTime} required/><br/>
                    Location: <input className="add-event-options" placeholder="location" type='text' name='time'
                                 value={this.state.place} onChange={this.inputPlace} required/><br/>
                    Description: <input className="add-event-options description"
                                        placeholder="Tell people more about the event.."
                                        type='text'
                                        name='description'
                                        value={this.state.description} onChange={this.inputDescription} required/><br/>
                </div> */}
                    <h1 className="h5 text-center mb-4">  </h1>
                    <div>
                        <span style={{color: "red"}} >{this.state.errorMessage}</span>
                    </div>
                    <MDBRow>

                        <MDBCol md="6">
                            <form>

                                <div className="grey-text">
                                    <MDBInput
                                        onChange={this.inputName}
                                        label="Name"
                                        icon="calendar-check"
                                        group
                                        type="text"
                                        validate
                                        error="wrong"
                                        success="right"
                                    />


                                    <MDBInput
                                        onChange={this.inputDescription}
                                        label="Description"
                                        icon="pencil-alt"
                                        rows="3"
                                        type="textarea"
                                        error="wrong"
                                        success="right"
                                        />
                                        <MDBInput
                                            onChange={this.inputPrice}
                                            label="Price"
                                            icon="textarea"
                                            group
                                            type="text"
                                            validate
                                            error="wrong"
                                            success="right"
                                            />
                                            <MDBInput
                                                onChange={this.inputStatus}
                                                label="Status"
                                                group
                                                type="text"
                                                validate
                                                error="wrong"
                                                success="right"
                                            />
                                            <MDBInput
                                                onChange={this.inputImage}
                                                type="image"
                                                label="Insert an image"
                                                success="right"
                                            />

                                </div>

                            </form>
                        </MDBCol>
                    </MDBRow>



                    <hr/>
                    <br/>
                    {/* <div>
                    <button className="add-event-button" onClick={this.handleSubmit}>Add Event</button>
                </div> */}
                    <Fragment>
                        <MDBBtn outline color="secondary" onClick={this.handleSubmit}>


                            <MDBIcon icon="plus-square" className="mr-1" /> Add
                        </MDBBtn>
                    </Fragment>
                    <Fragment>
                        <MDBBtn outline color="secondary" >

                            <Link to="/products/">Back to products </Link>

                        </MDBBtn>
                    </Fragment>
                    {/* <Link to="/events">

                </Link> */}


                </div>
                <FooterPart/>
            </div>
    );
    }
    }

