import React, { Component } from 'react';
import details from "../../../../../public/assets/images/blog-details.jpg";
import slider2 from "../../../../../public/assets/images/cover31.jpg";
import Store from "../../utils/store";
import PolicyNoImage from "../PrivacyPolices/PolicyNoImage";
import PolicyLeftImage from "../PrivacyPolices/PolicyLeftImage";
import PolicyRightImage from "../PrivacyPolices/PolicyRightImage";
import PolicyBottomImage from "../PrivacyPolices/PolicyBottomImage";





export default class PrivacyPolices extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            contentPrivacy: '',
            store: store
        }
        // this.handleClick = this.handleClick.bind(this);
    }


    async UNSAFE_componentWillMount() {

        await this.state.store.api_post_call('getPrivacy', {}).then(res=> {
            this.setState({contentPrivacy: res.data.values});
            console.log('contentPrivacy', res.data.values)

        }).catch(err => {
            console.log(err);
        })

    }


    render () {
        let contentPrivacy = this.state.contentPrivacy;
        console.log('-----Render Content Privacy-----', contentPrivacy)

        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Home</a></li>
                            <li className="breadcrumb-item active">Privacy Policy</li>
                        </ol>
                    </div>
                </section>

                <section className="blog-details-area pt-80 pb-100">
                    <div className="container">
                        <div className="blog-details-content">
                            <h2 style={{color: '#555', margin: '50px 0', textAlign: 'left', textTransform: 'uppercase'}}> Privacy Polices</h2>

                            {
                                contentPrivacy.length > 0 ?

                                    <React.Fragment>
                                        {
                                            this.state.contentPrivacy.map((part, partIndex) =>
                                                <React.Fragment>
                                                    {part.styling === "No Image" ?
                                                        <React.Fragment>
                                                            <PolicyNoImage part={part}/>
                                                        </React.Fragment> :
                                                        part.styling === "Image Left" ?
                                                            <React.Fragment>
                                                                <PolicyLeftImage part={part}/>
                                                            </React.Fragment> :
                                                            part.styling === "Image Right" ?
                                                                <React.Fragment>
                                                                    <PolicyRightImage part={part}/>
                                                                </React.Fragment>  :
                                                                part.styling === "Image Bottom" ?
                                                                    <React.Fragment>
                                                                        <PolicyBottomImage part={part}/>
                                                                    </React.Fragment>

                                                                : null
                                                    }
                                                </React.Fragment>
                                            )}

                                    </React.Fragment>
                                    : null
                            }
                            <div style={{borderTop: '1px solid #e8e8e8'}}> </div>

                            </div>
                    </div>
                </section>

            </div>


        )
    }
}


