import React, { Component } from 'react'
import { Link } from 'react-router-dom';
import Store from '../../../utils/store'
import slider2 from "../../../../../../public/assets/images/cover31.jpg";
import MyProfileSideBar from "./MyProfileSideBar";
import axios from 'axios';
import Swal from 'sweetalert2';

export default class UpdatePersonalInfo extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            errorMessage: '',
            store: store,
            loggUser:{
                name: '',
                address: '',
                city: '',
                email: '',
                tel: '',
                zip: ''

            },
        }

        this.inputName = this.inputName.bind(this);
        this.inputAddress = this.inputAddress.bind(this);
        this.inputPhone = this.inputPhone.bind(this);
        this.inputCity = this.inputCity.bind(this);
        this.inputZip = this.inputZip.bind(this);
        this.inputEmail = this.inputEmail.bind(this);
        this.inputPassword = this.inputPassword.bind(this);
        this.inputConfirm = this.inputConfirm.bind(this);
        this.updateInfo = this.updateInfo.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        // this.alertMessage = this.alertMessage.bind(this);

    }

    async componentDidMount(){
            this.state.store.api_post_call('getUser', {}).then(res=> {
                this.setState({loggUser: res.data.values});
                console.log('loggUser', res.data)
            }).catch(err => {
                console.log(err);
            })

    }

    inputName(event) {
        console.log('name', event.target.value);
        this.setState({
            ...this.state,
            loggUser: {
                ...this.state.loggUser,
                name: event.target.value
            }
        });
    }

    inputAddress(event) {
        this.setState({
            ...this.state,
            loggUser: {
                ...this.state.loggUser,
                address:event.target.value
            }
        });
    }

    inputCity(event) {
        this.setState({
            ...this.state,
            loggUser: {
                ...this.state.loggUser,
                city:event.target.value
            }
        });
    }

    inputPhone(event) {
        this.setState({
            ...this.state,
            loggUser: {
                ...this.state.loggUser,
                tel:event.target.value
            }
        });
    }

    inputZip(event) {
        this.setState({
            ...this.state,
            loggUser: {
                ...this.state.loggUser,
                zip:event.target.value
            }
        });
    }

    inputEmail(event) {
        this.setState({
            ...this.state,
            loggUser: {
                ...this.state.loggUser,
                email:event.target.value
            }
        });
    }

    inputPassword(event) {
        this.setState({
            ...this.state,
            newPassword: event.target.value
        });
    }


    inputConfirm(event) {
        this.setState({
            ...this.state,
            newConfirm: event.target.value
        });
    }

    // alertMessage() {
    //     swal('Your profile has been updated!');
    // }



    updateInfo(){

        let newUser = this.state.loggUser;
        newUser.phone = this.state.loggUser.tel;
        this.state.store.api_post_call('updateUser', newUser).then(res => {
            if (res.data.status) {
                this.state.store.saveLoggedUser(res.data.values);
                Swal.fire('Success!', res.data.message, 'success');
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: res.data.message
                })
                Swal.fire('Error!', res.data.message, 'error');
                // alert(res.data.message);
            }
        }).catch(err => {
            console.log('some error thing for maya naumoska od ohrid', err)
        });

    }

    // addEvent() {
    //     const { name, date, time, place, description } = this.state;
    //
    //     console.log("Submit ", {
    //         name,
    //         date,
    //         time,
    //         place,
    //         description
    //     })





    handleSubmit() {

        let valid = true;

        // const name = this.state.loggedUser.name;
        // const city = this.state.loggedUser.city;
        // const address = this.state.loggedUser.address;
        // const tel = this.state.loggedUser.tel;
        // const zip = this.state.loggedUser.zip;
        // const email = this.state.loggedUser.email;
        // const newPassword = this.state.newPassword;
        // const newConfirm = this.state.newConfirm;

        // if (!name || !address || !city || !tel || !zip  || !email) {
        //     this.setState({
        //         ...this.state,
        //         errorMessage: "Please fill in all required fields to login."
        //     });
        //     valid = false;
        // }
        // else if (newPassword !== newConfirm) {
        //     this.setState({
        //         ...this.state,
        //         errorMessage: "Password does not match"
        //     });
        //     valid = false;
        // }

        if (valid) {
            this.setState({
                ...this.state,
                errorMessage: ""
            });
            this.updateInfo();
        }


    }


    render () {
        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Accueil</a></li>
                            <li className="breadcrumb-item"><a href="/myprofile">Profil</a></li>
                            <li className="breadcrumb-item active">Mettre à jour</li>
                        </ol>
                    </div>
                </section>

                <section className="login-area pb-100">
                    <div className="container">

                        <div className="row flex-lg-row-reverse">
                            <div className="col-lg-9 mt-30">



                                <h3 className="my-profile">METTEZ À JOUR VOS INFORMATIONS PERSONNELLES</h3>

                                <div>
                                    <div className="myProfile-container">
                                        <div className="myProfile-description">Vous pouvez accéder et modifier vos données personnelles (nom, adresse, numéro de téléphone, etc.) afin de faciliter vos futurs achats et de nous signaler tout changement de vos coordonnées.</div>
                                    </div>
                                </div>

                                <div className="login-form text-center ml-30">

                                    <div>
                                        <span style={{color: "red"}} >{this.state.errorMessage}</span>
                                    </div>

                                    <form>
                                        <div className="form-row">
                                            <div className="form-group col-md-6">
                                                <label>Nom</label>
                                                <input type="text"  className="form-control" value={this.state.loggUser.name} onChange={this.inputName}/>
                                            </div>
                                            <div className="form-group col-md-6">
                                                <label>Email</label>
                                                <input type="email" className="form-control" value={this.state.loggUser.email} onChange={this.inputEmail}/>
                                            </div>
                                        </div>

                                        <div className="form-group">
                                            <label>Addresse</label>
                                            <input type="text" className="form-control"
                                                   placeholder="1234 Main St" value={this.state.loggUser.address} onChange={this.inputAddress}/>
                                        </div>

                                        <div className="form-row">
                                            <div className="form-group col-md-6">
                                                <label>Ville</label>
                                                <input type="text" className="form-control" value={this.state.loggUser.city} onChange={this.inputCity}/>
                                            </div>
                                            <div className="form-group col-md-4">
                                                <label>Téléphone</label>
                                                <input type="text" className="form-control" value={this.state.loggUser.tel} onChange={this.inputPhone}/>
                                            </div>
                                            <div className="form-group col-md-2">
                                                <label>Code Postal</label>
                                                <input type="text" className="form-control" value={this.state.loggUser.zip} onChange={this.inputZip} />
                                            </div>
                                        </div>

                                        <button className="main-btn" type="button" onClick={this.handleSubmit}>Mettre à jour</button>
                                    </form>









                        </div></div>

                        <MyProfileSideBar/>
                    </div>


                    </div>
                </section>


            </div>

        )
    }
}
