import React, { Component } from 'react'
import Store from '../../../utils/store'
import slider2 from "../../../../../../public/assets/images/cover31.jpg";
import MyProfileSideBar from "./MyProfileSideBar";
import {getCurrentDate} from "../../../utils/getCurrentDate";

export default class OrdersAndReturns extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            store:store,
            orders: []
        }

        this.downloadInvoice = this.downloadInvoice.bind(this);
        this.calcPrice = this.calcPrice.bind(this);
    }


    UNSAFE_componentWillMount()
{

    this.state.store.api_post_call('getOrders', {}).then(res => {
        this.setState({orders: res.data.values});
        console.log('orders', res.data.values);


    }).catch(err => {
        console.log(err);
    })
}
    downloadInvoice(id){
        this.state.store.api_post_call('downloadInvoice', {id:id}).then(res => {
            // this.setState({orders: res.data.values});
            console.log('downloadInvoice', res);


        }).catch(err => {
            console.log(err);
        })
    }

    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }

    render () {
        let orders = this.state.orders;
        for(let i=0; i<orders.length;i++)
        {
            orders[i].updated_at  = orders[i].updated_at.substring(0, 10);
            orders[i].created_at  = orders[i].created_at.substring(0, 10);
        }

        let currency = this.props.currency;


        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Accueil</a></li>
                            <li className="breadcrumb-item"><a href="/myprofile">Profil</a></li>
                            <li className="breadcrumb-item active">Commandes et Retours</li>
                        </ol>
                    </div>
                </section>

                <section className="shop-grid-page pt-30 pb-100">
                    <div className="container">
                        <div className="row flex-lg-row-reverse">
                            <div className="col-lg-9">
                                <div className="tab-content mt-30" >
                                    <div>
                                        <h3 className="my-profile">COMMANDES ET RETOURS</h3>
                                        <div className="card">
                                            <div className="card-header">
                                                <strong>{getCurrentDate()}</strong>
                                                <span className="float-right"> <strong>Commandes</strong> </span>

                                            </div>
                                            <div className="card-body">
                                                <div className="table-responsive-sm">
                                                    <table className="table table-striped">
                                                        <thead>
                                                        <tr>
                                                            <th className="center">#</th>
                                                            <th>Code de commande (id)</th>
                                                            <th>Remise</th>

                                                            <th className="right">Coupon</th>
                                                            <th className="center" style={{textAlign: 'center'}}>Statut</th>
                                                            <th className="center" style={{textAlign: 'center'}}>Daté</th>
                                                            <th className="right" style={{textAlign: 'right'}}>Prix total</th>
                                                            <th className="right" style={{textAlign: 'right'}}>Facture d'achat</th>
                                                            {/*<th className="right">download</th>*/}
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        {
                                                            orders.map(
                                                                (order, orderIndex)=>
                                                                    <tr key={orderIndex}>
                                                                        <td className="center"> </td>
                                                                        <td className="left strong">{order.id}</td>
                                                                        <td className="left">{order.discount}</td>
                                                                        <td className="right">{order.coupon} </td>
                                                                        <td style={{textAlign: 'center'}}>
                                                                            <div className="center">{order.status}</div>
                                                                        </td>
                                                                        <td style={{textAlign: 'center'}}>
                                                                            <div className="center">{order.created_at}</div>
                                                                        </td>

                                                                        <td style={{textAlign: 'right'}}>
                                                                            <div className="right"><span>{order.sum} {currency}</span></div>
                                                                        </td>
                                                                        <td style={{textAlign: 'right'}}>
                                                                            <div className="right">
                                                                                <a href={`/invoices/${order.id}`}>
                                                                                    <i className="fas fa-file-invoice"> </i>
                                                                                </a>
                                                                            </div>
                                                                        </td>
                                                                        {/*<td>*/}
                                                                        {/*    <div className="right">*/}
                                                                        {/*        <button onClick={() => this.downloadInvoice(order.id)}>*/}
                                                                        {/*            <i className="fas fa-file-invoice"> </i>*/}
                                                                        {/*        </button>*/}
                                                                        {/*    </div>*/}
                                                                        {/*</td>*/}
                                                                    </tr>
                                                            )
                                                        }
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <div className="row">
                                                    <div className="col-lg-4 col-sm-5">

                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            <MyProfileSideBar/>
                        </div>

                    </div>
                </section>



            </div>



        )
    }
}
