import React, { Component } from 'react'
import Store from '../../../utils/store'
import slider2 from "../../../../../../public/assets/images/cover31.jpg";
import MyProfileSideBar from "./MyProfileSideBar";
import Pdf from "react-to-pdf";
import 'react-router-dom'
import {getCurrentDate} from '../../../utils/getCurrentDate'
import Swal from "sweetalert2";

const ref = React.createRef();

export default class Invoices extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            secondStore: store,
            store:{
                loggedUser:{
                    name: '',
                    address: '',
                    email:'',
                    city: '',
                    zip: '',
                    tel: ''
                }
            },
            cartProds: [],
            order: null,
            orders: null,
            productsPrice:'',
            totalPrice: '',
            downloadUrl: ''

        }
        this.getOrderInvoice = this.getOrderInvoice.bind(this);
        this.downloadPdf=this.downloadPdf.bind(this);
        this.calcPrice = this.calcPrice.bind(this);
        // this.handleClick = this.handleClick.bind(this);
    }

    async componentWillMount(){
        let currentUrl = window.location.href;
        let invoiceId = currentUrl.split("/invoices/")[1];
        const store = new Store('mangopaid');
        await this.setState({store: store.get()});
        const user = this.state.store.loggedUser;
        this.getOrderInvoice(invoiceId);
        // this.state.secondStore.api_post_call('getOrders', {}).then(res=> {
        //     this.setState({orders : res.data.values})
        //     console.log('orders', res.data.values);
        //
        //
        // }).catch(err => {
        //     console.log(err);
        // });
    }

    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }

    async getOrderInvoice(invoiceId){
        let order = null;
        await this.state.secondStore.api_post_call('getOrders', {id: invoiceId}).then(res=> {
            console.log('order', res.data.values);
            order = res.data.values;
        }).catch(err => {
            console.log(err);
        });

        if(order!=null){
            this.setState({order : order})
            console.log('updated');
        }

        }

    async UNSAFE_componentWillMount() {

        // let storeData =  this.state.store.get();
        const store = new Store('mangopaid');
        await this.setState({store: store.get()});
        const self = this;
        self.setState({cartProds: self.state.store.cart});
    }

    downloadPdf(){
        let token = this.props.token;
        let order_id = this.state.order.id;
        let params={
            id:order_id
        }
        this.state.secondStore.api_post_call('downloadInvoice', params).then(res=> {
            // return res.data.values;
            window.location = res.data.values;
            console.log('downloaded', res.data.values);
            // if (res.data.status) {
            //     Swal.fire("Good choice!", "Your order was successful!", "success");
            // }

        }).catch(err => {
            // Swal.fire("Invalid data!", "An error has occurred", "warning");
            // console.log(err);
        })
        console.log('my params', params);

    }

    render () {
        let dataCart = this.state.cartProds;
        // for(let i=0;i<this.state.orders.length;i++){
        //     let order = this.state.orders[i];
        //     let products = order.items;
        //     console.log('products', products);
        //
        //
        // }

        const logo = this.props.logo;
        const companyName = this.props.company;
        const tel = this.props.tel;
        const address = this.props.address;
        const email = this.props.email;
        let currency = this.props.currency;
        let orders = this.state.orders;
        let shipping_fee = this.props.shipping_fee;





        // let total = 0;
        // let products= this.state.order.items;
        //
        // for(let i=0;i<products.length;i++)
        // {
        //     total+=parseInt(products[i].quantity*products[i].product.price);
        //
        // }
        //
        // let discount = total*0.2;
        // let VAT = total*0.1;

        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Accueil</a></li>
                            <li className="breadcrumb-item"><a href="/myprofile">Profil</a></li>
                            <li className="breadcrumb-item active">Les factures</li>
                        </ol>
                    </div>
                </section>
                {this.state.order != null ?
                    <React.Fragment>
                        <section className="shop-grid-page pt-30 pb-100">
                            <div className="container">
                                <div  style={{ position:'relative', display: 'flex', flexDirection: 'column', minWidth: '0', backgroundColor: '#fff',
                                backgroundClip: 'border-box', border: '1px solid rgba(0, 0, 0, 0.125)', borderRadius: '0.25rem'
                                }}>
                                    <div className="card-header" style={{padding: '0.75rem 1.25rem', cursor: 'pointer'}}>
                                        <strong>{ this.state.order.created_at.substring(0, 10)}</strong>
                                        <span className="float-right"> <a><i
                                            className="fas fa-download" onClick={this.downloadPdf}> </i>
                                        </a>
                                            {/*<a href={this.state.downloadUrl} download> PDF </a>*/}
                                        </span>

                                    </div>
                                    <div className="card-body">
                                        <div className="row mb-4">
                                            <div className="col-sm-6">
                                                <div className="header-logo">
                                                    <img src={logo} alt="logo"/>
                                                </div>
                                                <div>
                                                    <strong>{companyName}</strong>
                                                </div>
                                                <div>{address}</div>
                                                <div>Email: {email}</div>
                                                <div>Téléphone: {tel}</div>
                                            </div>

                                            <div className="col-sm-6">
                                                <h6 className="mb-3">To:</h6>
                                                <div>
                                                    <strong>{this.state.store.loggedUser.name}</strong>
                                                </div>
                                                <div>{this.state.store.loggedUser.address}</div>
                                                <div>{this.state.store.loggedUser.city}</div>
                                                <div>Email: {this.state.store.loggedUser.email}</div>
                                                <div>Téléphone: {this.state.store.loggedUser.tel}</div>
                                            </div>
                                        </div>

                                        <div className="table-responsive-sm">
                                            <table className="table table-striped" style={{marginBottom: '120px'}}>
                                                <thead>
                                                <tr>
                                                    <th className="center">#</th>
                                                    <th>Article</th>
                                                    <th>La description
                                                    </th>

                                                    <th className="right" style={{width:'15%',
                                                        textAlign: 'right'}}>Coût unitaire</th>
                                                    <th style={{textAlign: 'center'}} className="center">Quantité</th>
                                                    <th  className="right" style={{width:'15%', textAlign: 'right'}}>Total</th>
                                                </tr>
                                                </thead>
                                                <tbody>

                                                {
                                                    this.state.order.items.map((product, indexProduct) =>

                                                        <tr>
                                                            <td style={{textAlign: 'left'}} className="center" key={indexProduct}>
                                                                {product.product.code}</td>
                                                            <td style={{textAlign: 'left'}} className="left strong">{product.product.title}</td>
                                                            {
                                                                product.product.description.length > 200 ?
                                                                    <React.Fragment>
                                                                        <td style={{textAlign: 'left'}} className="left">{product.product.description.substring(0, 197) + "..."}</td>
                                                                    </React.Fragment> :
                                                                    <React.Fragment>
                                                                        <td style={{textAlign: 'left'}} className="left">{product.product.description}</td>
                                                                    </React.Fragment>



                                                            }


                                                            <td style={{textAlign: 'right'}} className="right">
                                                                <span>{product.product.price} {currency}</span></td>

                                                            <td style={{textAlign: 'center'}}>
                                                                <div className="center"> {product.quantity}</div>
                                                            </td>

                                                            <td style={{textAlign: 'right'}}>
                                                                <div className="right">
                                                                    <span>{product.quantity * product.product.price} {currency}</span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    )
                                                }
                                                </tbody>

                                            </table>
                                        </div>

                                        <div className="row">
                                            <div className="col-lg-4 col-sm-5">

                                            </div>

                                            <div className="col-lg-4 col-sm-5 ml-auto">
                                                <table className="table table-clear">
                                                    <tbody>
                                                    <tr>
                                                        <td className="left">
                                                            <strong>Coût</strong>
                                                        </td>
                                                        <td style={{textAlign: 'right'}} className="right"><span>{this.state.order.subtotal} {currency} </span></td>
                                                    </tr>
                                                    {/*<tr>*/}
                                                    {/*    <td className="left">*/}
                                                    {/*        <strong>Discount </strong>*/}
                                                    {/*    </td>*/}
                                                    {/*    <td style={{textAlign: 'right'}} className="right"><span>{this.state.order.discount} {currency} </span></td>*/}
                                                    {/*</tr>*/}
                                                    {/*<tr>*/}
                                                    {/*    <td className="left">*/}
                                                    {/*        <strong>Processing fee</strong>*/}
                                                    {/*    </td>*/}
                                                    {/*    <td style={{textAlign: 'right'}}  className="right"><span>{this.state.order.processing_fee} {currency} </span></td>*/}
                                                    {/*</tr>*/}
                                                    <tr>
                                                        <td className="left">
                                                            <strong>Frais d'expédition</strong>
                                                        </td>
                                                        <td style={{textAlign: 'right'}} className="right"><span>{shipping_fee} {currency} </span></td>
                                                    </tr>
                                                    <tr>
                                                        <td className="left">
                                                            <strong>Total</strong>
                                                        </td>
                                                        <td style={{textAlign: 'right', fontWeight: '800', color: '#e06377'}} className="right">
                                                            <strong><span> {parseFloat(this.state.order.subtotal) + parseFloat(shipping_fee)} {currency}</span></strong>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </section>
                    </React.Fragment>
                    : null
                }

            </div>



        )
    }
}
