import React,{ Component } from 'react'
import Store from '../../../utils/store'
import slider2 from "../../../../../../public/assets/images/cover31.jpg";
import MyProfileSideBar from "./MyProfileSideBar";
import Swal from "sweetalert2";

export default class AccessDetails extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            store: store,
            newCurrent: '',
            newPassword: '',
            newConfirm: '',
            errorMessage: ''
        }
        this.inputPassword = this.inputPassword.bind(this);
        this.inputCurrent = this.inputCurrent.bind(this);
        this.inputConfirm = this.inputConfirm.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        this.changePassword = this.changePassword.bind(this);
    }



    inputPassword(event) {
        this.setState({
            ...this.state,
            newPassword: event.target.value
        });
    }
    inputCurrent(event) {
        this.setState({
            ...this.state,
            newCurrent: event.target.value
        });
    }


    inputConfirm(event) {
        this.setState({
            ...this.state,
            newConfirm: event.target.value
        });
    }



    changePassword(){
        const params = {current_password: this.state.newCurrent , password: this.state.newPassword, password_confirmation: this.state.newConfirm};
        this.state.store.api_post_call('changePsw', params).then(res => {
            if (res.data.status) {
                Swal.fire('Success!', res.data.message, 'success');
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: res.data.message
                })
                // Swal.fire('Error!', res.data.message, 'error');
                // alert(res.data.message);
            }
        }).catch(err => {
            console.log(err)
        });

    }



    handleSubmit() {

        let valid = true;

        const newPassword = this.state.newPassword;
        const newCurrent = this.state.newCurrent;
        const newConfirm = this.state.newConfirm;
        console.log(this.state);
        if (!newPassword || !newConfirm || !newCurrent  ) {
            this.setState({
                ...this.state,
                errorMessage: "Please fill in all required fields to login."
            });
            valid = false;
        }
        else if (newPassword !== newConfirm) {
            this.setState({
                ...this.state,
                errorMessage: "Password does not match"
            });
            valid = false;
        }

        if (valid) {
            this.setState({
                ...this.state,
                errorMessage: ""
            });
            this.changePassword();
        }


    }



    render () {
        return (
            <div>

                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Accueil</a></li>
                            <li className="breadcrumb-item"><a href="/myprofile">Profil</a></li>
                            <li className="breadcrumb-item active">Modifier le mot de passe</li>

                        </ol>
                    </div>
                </section>

                <section className="shop-grid-page pt-30 pb-100">
                    <div className="container">
                        <div className="row flex-lg-row-reverse">
                            <div className="col-lg-9">
                                <div className="tab-content mt-30" >
                                    <div>
                                        <h3 className="my-profile">LE MOT DE PASSE</h3>
                                        <div>
                                            <div className="myProfile-container">
                                                <h5 className="myProfile-title mt-30">Modifier le mot de passe</h5>
                                                <div className="myProfile-description">Si vous oubliez votre mot de passe ou si quelqu'un tente de pirater votre compte, fournissez-nous les informations suivantes pour réinitialiser le mot de passe:</div>
                                            </div>
                                        </div>
                                    </div>

                                    <div className="ml-30">
                                        <span style={{color: "red"}} >{this.state.errorMessage}</span>
                                    </div>

                                    <form className="ml-30">
                                        <div className="form-row">
                                            <div className="form-group col-md-6">
                                                <label>Mot de passe actuel</label>
                                                <input type="password" className="form-control" onChange={this.inputCurrent}/>
                                            </div>

                                        </div>

                                        <div className="form-row">
                                            <div className="form-group col-md-6">
                                                <label>Nouveau mot de passe</label>
                                                <input type="password" className="form-control" onChange={this.inputPassword}/>
                                            </div>
                                            <div className="form-group col-md-6">
                                                <label>Confirmez le mot de passe</label>
                                                <input type="password" className="form-control" onChange={this.inputConfirm}/>
                                            </div>
                                        </div>


                                        <button className="main-btn" type="button" onClick={this.handleSubmit}>Mettre à jour</button>
                                    </form>




                                </div>
                            </div>
                            <MyProfileSideBar/>
                        </div>

                    </div>
                </section>



            </div>



        )
    }
}
