import React,{ Component } from 'react'
import slider2 from "../../../../../public/assets/images/slider-2.jpg";
import gift from "../../../../../public/assets/images/gift.png";
// import Swal from "sweetalert2";
import SentMessage from "../Support/SentMessage";
import Store from "../../utils/store";
import copy from "copy-to-clipboard";
// import './CopyBoard.css';



export default class SingleOfferCard extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');

        this.state = {
            store: store,
            coupons: [{
                type: '',
                code: '',
                price: '',
                end_date: ''
            }],
            config: {
                address: '',
                tel: '',
                main_email: '',
                hotline_support: '',
                hotline_num: ''
            },
            textToCopy: this.props.coupon.code,
            copyStatus: 'Copy'

        }

        this.copytext = this.copytext.bind(this);
        this.handleInputChange = this.handleInputChange.bind(this);
    }

    copytext() {
        copy(this.props.coupon.code);
        this.setState({
            copyStatus: 'Copied'
        })
    }

    handleInputChange() {
        this.setState({
            textToCopy: this.props.coupon.code
        });
    }



    render () {
        let coupon = this.props.coupon;
        let couponIndex = this.props.couponIndex;
        let price = parseInt(this.props.coupon.price);
        return (
            <div>
                <div className="checkout-box mt-50 offer-card-size cardCoupon ">
                     <div className="offer-title " >
                         <a href='/offer' className="checkoutOffer" style={{marginBottom: '0', color: 'white', fontSize: '70px'
                         }}><span>{price}</span><span style={{fontSize: '25px', paddingLeft: '0'}}> {coupon.type} OFF </span></a>
                     </div>
                    <div className="offersDetails ">
                        <div className="order-list">
                            <ul>
                                <li className="offer-list"> Any Purchase
                                    <span style={{float: 'right', color:'white'}}>
                                        <i style={{fontSize: '70px'}} className='fa fa-gift' aria-hidden='true'> </i>
                                    </span>
                                </li>
                                <li className="offer-list"> {coupon.end_date} </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div className='row' style={{padding: '10px 30px'}}>
                    <div className='codeDiv txt'>
                        {coupon.code} <span  onClick={this.copytext} className='copy'> {this.state.copyStatus}</span>
                        {/*<textarea className="form-control"  value={coupon.code}>*/}
                        {/*    {coupon.code}*/}
                        {/*</textarea>*/}
                        {/*<button className="btn btn-info" onClick={this.copytext}>*/}
                        {/*    Copy*/}
                        {/*</button>*/}
                    </div>
                </div>
            </div>
        )
    }
}


