
$(function() {

    "use strict";


    /*=============================================
    =                 Search                   =
    =============================================*/

	$('.search').on('click', function(event) {
        $('.header-search').addClass('open');
    });

	$('.search-close').on('click', function(event) {
        $('.header-search').removeClass('open');
    });

    /*=====  End of Prealoder  ======*/


    /*=============================================
    =                  Sticky                     =
    =============================================*/

	$(window).on('scroll', function(event) {
        var scroll = $(window).scrollTop();
        if (scroll < 110) {
            $(".header-area").removeClass("sticky");
            //$(".header-navbar img").attr("src", "assets/images/logo.png");
        } else{
            $(".header-area").addClass("sticky");
            //$(".header-navbar img").attr("src", "assets/images/logo-2.png");
        }
    });

    /*=====  End of Sticky  ======*/


    /*=============================================
    =            Mobile Menu Script               =
    =============================================*/

    /*-------- Mobile Menu Sidebar 1 --------*/

    $('.toggle').on('click', function(){
        $('.header-menu').addClass('menu-open')
        $('.overlay').addClass('open')
    });

    $('.menu-close').on('click', function(){
        $('.header-menu').removeClass('menu-open')
        $('.overlay').removeClass('open')
    });

    $('.overlay').on('click', function(){
        $('.header-menu').removeClass('menu-open')
        $('.overlay').removeClass('open')
    });

    /*-------- Window Resize javascript Responsive Function --------*/

    let body = document.querySelector('body');
    function displayWindowSize(){
       var w = document.documentElement.clientWidth;

       if (w > 991) {
           // YOUR CODE...

            /*-------- Mobile Menu javascript Function --------*/

            var $offCanvasNav = $('.header-menu'),
            $offCanvasNavSubMenu = $offCanvasNav.find('.sub-menu, .sub-mega-menu, .sub-mega-menu ul');

            /*Add Toggle Button With Off Canvas Sub Menu*/
            $offCanvasNavSubMenu.parent().prepend('');

            /*Close Off Canvas Sub Menu*/
            $offCanvasNavSubMenu.slideDown();

            /*Category Sub Menu Toggle*/
            $offCanvasNav.on('click', 'li a, li .menu-expand', function(e) {
                var $this = $(this);
                if (($this.parent().attr('class').match(/\b(menu-item-has-children|has-children|has-sub-menu)\b/)) && ($this.attr('href') === '#' || $this.hasClass('menu-expand'))) {
                    e.preventDefault();
                    if ($this.siblings('ul:visible').length) {
                        $this.parent('li').removeClass('active');
                        $this.siblings('ul').slideDown();
                    } else {
                        $this.parent('li').addClass('active');
                        $this.closest('li').siblings('li').find('ul:visible').slideDown();
                        $this.closest('li').siblings('li').removeClass('active');
                        $this.siblings('ul').slid();
                    }
                }
            });

       }
       else{
           // YOUR CODE...

            /*-------- Mobile Menu javascript Function --------*/

            var $offCanvasNav = $('.header-menu'),
            $offCanvasNavSubMenu = $offCanvasNav.find('.sub-menu, .sub-mega-menu, .sub-mega-menu ul');

            /*Add Toggle Button With Off Canvas Sub Menu*/
            $offCanvasNavSubMenu.parent().prepend('<span class="menu-expand d-lg-none"></span>');

            /*Close Off Canvas Sub Menu*/
            $offCanvasNavSubMenu.slideUp();

            /*Category Sub Menu Toggle*/
            $offCanvasNav.on('click', 'li a, li .menu-expand', function(e) {
                var $this = $(this);
                if (($this.parent().attr('class').match(/\b(menu-item-has-children|has-children|has-sub-menu)\b/)) && ($this.attr('href') === '#' || $this.hasClass('menu-expand'))) {
                    e.preventDefault();
                    if ($this.siblings('ul:visible').length) {
                        $this.parent('li').removeClass('active');
                        $this.siblings('ul').slideUp();
                    } else {
                        $this.parent('li').addClass('active');
                        $this.closest('li').siblings('li').find('ul:visible').slideUp();
                        $this.closest('li').siblings('li').removeClass('active');
                        $this.siblings('ul').slideDown();
                    }
                }
            });

       }
    }
    window.addEventListener("resize", displayWindowSize);
    displayWindowSize();

    /*=====  End of Mobile Menu Script  ======*/


    /*=============================================
    =               Magnific Popup                =
    =============================================*/

	$('.video-popup').magnificPopup({
        type: 'iframe'
        // other options
    });

    $('.image-popup').magnificPopup({
      type: 'image',
      gallery:{
        enabled:true
      }
    });

    /*=====  End of Magnific Popup  ======*/


    /*=============================================
    =               Slick Slider                  =
    =============================================*/

    function mainSlider() {
        var BasicSlider = $('.slider-active');

        BasicSlider.on('init', function (e, slick) {
            var $firstAnimatingElements = $('.single-slider:first-child').find('[data-animation]');
            doAnimations($firstAnimatingElements);
        });

        BasicSlider.on('beforeChange', function (e, slick, currentSlide, nextSlide) {
            var $animatingElements = $('.single-slider[data-slick-index="' + nextSlide + '"]').find('[data-animation]');
            doAnimations($animatingElements);
        });

        BasicSlider.slick({
            autoplay: true,
            autoplaySpeed: 13000,
            dots: true,
            fade: true,
            arrows: false,
            pauseOnHover: false,
            prevArrow: '<span class="prev"><i class="fa fa-angle-left"></i></span>',
            nextArrow: '<span class="next"><i class="fa fa-angle-right"></i></span>',
            customPaging : function(slider, i) {
                var thumb = jQuery(slider.$slides[i]).data();
                return '<button>'+('0'+(i+1))+'</button>';
            },
            responsive: [
                {
                    breakpoint: 767,
                    settings: {
                        arrows: false
                    }
                }
            ]
        });

        function doAnimations(elements) {
            var animationEndEvents = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
            elements.each(function () {
                var $this = $(this);
                var $animationDelay = $this.data('delay');
                var $animationType = 'animated ' + $this.data('animation');
                $this.css({
                    'animation-delay': $animationDelay,
                    '-webkit-animation-delay': $animationDelay
                });
                $this.addClass($animationType).one(animationEndEvents, function () {
                    $this.removeClass($animationType);
                });
            });
        }
    }
    mainSlider();

    /*=====  End of Slick Slider  ======*/


    /*=============================================
    =           ProductCard Size Active               =
    =============================================*/

	$('.product-size li').on("click", function() {
		$(this).siblings(this).removeClass('active').end().addClass('active');
	});

    /*=====  End of ProductCard Size Active ======*/


    /*=============================================
    =           ProductCard Color Active               =
    =============================================*/

    $('.product-color li').each(function() {
		var get_color = $(this).attr('data-color');
		$(this).css("background-color", get_color);
    });

	$('.product-color li').on("click", function() {
		$(this).siblings(this).removeClass('active').end().addClass('active');
    });

    /*=====  End of ProductCard Size Active ======*/


    /*=============================================
    =         Slick Mini ProductCard Active           =
    =============================================*/

	$('.mini-product-active').slick({
        dots: true,
        autoplay: true,
        arrows: false,
        infinite: true,
        speed: 800,
        autoplaySpeed: 5000,
        slidesToShow: 1,
    });


    /*=====  End of   ======*/


    /*=============================================
    =             Slick Brand Active              =
    =============================================*/

	$('.brand-active').slick({
        dots: false,
        autoplay: true,
        arrows: false,
        infinite: true,
        speed: 800,
        autoplaySpeed: 5000,
        slidesToShow: 6,
        responsive: [
            {
                breakpoint: 992,
                settings: {
                    slidesToShow: 4,
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 3,
                }
            },
            {
                breakpoint: 576,
                settings: {
                    slidesToShow: 2,
                }
            }
        ]
    });


    /*=====  End of   ======*/


    /*=============================================
    =               Back to top                   =
    =============================================*/

	// Show or hide the sticky footer button
    $(window).on('scroll', function(event) {
        if($(this).scrollTop() > 600){
            $('.back-to-top').fadeIn(200)
        } else{
            $('.back-to-top').fadeOut(200)
        }
    });


    //Animate the scroll to yop
    $('.back-to-top').on('click', function(event) {
        event.preventDefault();

        $('html, body').animate({
            scrollTop: 0,
        }, 1500);
    });

    /*=====  End of Back to top  ======*/


    /*=============================================
    =                Countdown                    =
    =============================================*/

	$('[data-countdown]').each(function() {
        var $this = $(this), finalDate = $(this).data('countdown');
        $this.countdown(finalDate, function(event) {
            $this.html(event.strftime(' <div class="countdown-wrapper d-flex flex-wrap"><div class="single-countdown"><span class="count">%D</span><p>DAYS</p></div><div class="single-countdown"><span class="count">%H</span><p>Hrs</p></div><div class="single-countdown"><span class="count">%M</span><p>Min</p></div><div class="single-countdown"><span class="count">%S</span><p>Sec</p></div></div>'));
        });
    });

    /*=====  End of   ======*/


    /*=============================================
    =           Menu More Categories              =
    =============================================*/

	$('.menu-expand').each(function(){
        var $ul = $(this),
            $lis = $ul.find('li:gt(10)'),
            isExpanded = $ul.hasClass('expanded');
        $lis[isExpanded ? 'show' : 'hide']();

        if($lis.length > 0){
            $ul
            .append($('<li class="expand">' + (isExpanded ? '<a href="javascript:;" class="more-category">- Close Categories</a>' : '<a href="javascript:;" class="more-category">+ More Categories</a>') + '</li>')
            .click(function(event){
                var isExpanded = $ul.hasClass('expanded');
                event.preventDefault();
                $(this).html(isExpanded ? '<a href="javascript:;" class="more-category">+ More Categories</a>' : '<a href="javascript:;" class="more-category">- Close Categories</a>');
                $ul.toggleClass('expanded');
                $lis.toggle(300);
            }));
        }
    });


    /*=====  End of Menu More Categories  ======*/


    /*=============================================
    =                Slick Blog                   =
    =============================================*/

	$('.blag-active').slick({
        dots: false,
        autoplay: true,
        arrows: false,
        infinite: true,
        centerMode: true,
        centerPadding: '575px',
        pauseOnHover: false,
        speed: 800,
        autoplaySpeed: 3000,
        slidesToShow: 1,
        responsive: [
            {
                breakpoint: 1700,
                settings: {
                    centerPadding: '500px',
                }
            },
            {
                breakpoint: 1600,
                settings: {
                    centerPadding: '500px',
                }
            },
            {
                breakpoint: 1450,
                settings: {
                    centerPadding: '375px',
                }
            },
            {
                breakpoint: 1080,
                settings: {
                    centerPadding: '300px',
                }
            },
            {
                breakpoint: 992,
                settings: {
                    centerPadding: '250px',
                    centerMode: false,
                    slidesToShow: 2,
                }
            },
            {
                breakpoint: 768,
                settings: {
                    centerPadding: '220px',
                    centerMode: false,
                }
            },
            {
                breakpoint: 576,
                settings: {
                    centerPadding: '575px',
                    centerMode: false,
                }
            }
        ]
    });

    /*=====  End of   ======*/


    /*=============================================
    =              Nice Select                    =
    =============================================*/

	$('select').niceSelect();

    /*=====  End of   ======*/


    /*=============================================
    =            Slick Shop Details               =
    =============================================*/

    $(".shop-slid-image").slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        fade: true,
        asNavFor: '.shop-thumb'
    });

    $(".shop-thumb").slick({
        slidesToShow: 4,
        slidesToScroll: 1,
        asNavFor: '.shop-slid-image',
        dots: false,
        infinite: false,
        arrows: true,
        prevArrow: '<span class="prev"><i class="fal fa-chevron-left"></i></span>',
        nextArrow: '<span class="next"><i class="fal fa-chevron-right"></i></span>',
        centerMode: false,
        focusOnSelect: true
    });

    /*=====  End of Slick Shop Details  ======*/


    /*=============================================
    =               Price Range                   =
    =============================================*/

	// $("#slider-range").slider({
    //     range: true,
    //     min: 0,
    //     max: 800,
    //     values: [500, 560],
    //     slide: function (event, ui) {
    //         $("#amount1").val("$" + ui.values[0] + ".00");
    //         $("#amount2").val("$" + ui.values[1] + ".00");
    //     }
    // });
    //
    // $("#amount1").val("$" + $("#slider-range").slider("values", 0) + ".00");
    //
    // $("#amount2").val("$" + $("#slider-range").slider("values", 1) + ".00");

    /*=====  End of   ======*/


    /*=============================================
    =            ProductCard Quantity                 =
    =============================================*/

	$('.add').on("click", function () {
        if ($(this).prev().val()) {
            $(this).prev().val(+$(this).prev().val() + 1);
        }
    });
    $('.sub').on("click", function () {
        if ($(this).next().val() > 1) {
            if ($(this).next().val() > 1) $(this).next().val(+$(this).next().val() - 1);
        }
    });

    /*=====  End of   ======*/


    /*=============================================
    =              Newsletter Popup               =
    =============================================*/

	$('.popup-close').on('click', function(){
        $('.newsletter-popup-area').fadeOut(500)
    });

    /*=====  End of   ======*/
















});
