import React, { Component } from 'react'
import ReactDOM from 'react-dom'
import {BrowserRouter, Link, Route, Switch, Redirect} from 'react-router-dom'
import HeaderPart from "./components/pages/mainComponents/HeaderPart"
import BrandPart from "./components/pages/mainComponents/BrandPart"
import NewsletterPart from "./components/pages/homePage/HomePageParts/NewsletterPart"
import FooterPart from "./components/pages/mainComponents/FooterPart"
import ProductCardDetails from "./components/pages/productPage/productView/ProductCard/ProductDetails/ProductCardDetails";

import './assets/js/vendor/jquery-3.5.1.min'
import './assets/js/vendor/modernizr-3.7.1.min'
import './assets/js/slick.min'
import './assets/js/jquery.magnific-popup.min'
import './assets/js/jquery.countdown.min'
import './assets/js/jquery-ui.min'
import './assets/js/jquery.nice-select.min'
import './assets/js/main'

import ProductsList from "./components/pages/productPage/productView/ProductsList";
import Checkout from "./components/pages/CheckoutPage/Checkout";
import ContactUs from "./components/pages/ContactUsPage/ContactUs";
import AboutUs from "./components/pages/AboutPage/AboutUs";
import Wishlist from "./components/pages/WishList/Wishlist";
import Cart from "./components/pages/UpdateWishlistPage/Cart";
import HomePage from './components/pages/homePage/HomePage';
import Offer from './components/pages/DiscountPage/Offer';
import './assets/css/style.css'
import Store from './components/utils/store'
import MyProfile from "./components/pages/MyProfilePage/MyProfile";
import UpdatePersonalInfo from "./components/pages/MyProfilePage/MyProfileParts/UpdatePersonalInfo";
import Invoices from "./components/pages/MyProfilePage/MyProfileParts/Invoices";
import OrdersAndReturns from "./components/pages/MyProfilePage/MyProfileParts/OrdersAndReturns";
import AccessDetails from "./components/pages/MyProfilePage/MyProfileParts/AccessDetails";
import PageNotFound from "./components/pages/NotFoundPage/PageNotFound";
import OrderView from "./components/pages/CheckoutPage/OrderView";
import Chat from "./components/pages/Support/Chat";
import PrivacyPolices from "./components/pages/PrivacyPolices/PrivacyPolices";
import 'bootstrap/dist/css/bootstrap.min.css';
import TermsAndConditions from "./components/pages/TermsAndConditionsPage/TermsAndConditions";
import Test from "./components/pages/AboutPage/Test";
import Sale from "./components/pages/productPage/productView/Sale/Sale";



export default class MainApp extends Component {

    constructor(props) {
        super(props);
        this.logged = false;
        const store = new Store('mangopaid');

        this.state = {
            user:null,
            store:store,
            conf: JSON.parse(this.props.conf),
            tickets: [],
            categories: [],
            calculateCurrencies: []

        }
        this.updateUserInfo = this.updateUserInfo.bind(this);
        // this.addTicket = this.addTicket.bind(this);

        if (this.props.logged === 'true') {this.logged = true;}
        let storeData = store.get();
        if (this.logged) {
            let testToken = store.saveToken(this.props.data);
            console.log('token', testToken.userToken);

        }
        let tmpUrl = this.props.url  + '/api/V1/';
        store.setUrl(tmpUrl);
        store.setBaseUrl(this.props.url);
        console.log('conf', JSON.parse(this.props.conf) );

    }


    UNSAFE_componentWillMount() {
        let categoriesElem=[];
        this.state.store.api_post_call('getCategories', {}).then(res=> {
            categoriesElem = res.data.values;
                     console.log('storecat', categoriesElem);


            this.setState({
              ...this.state,
              categories: categoriesElem
          })


        }).catch(err => {
            console.log(err);
        })


        this.state.store.api_post_call('calculateCurrencies', {}).then(res=> {
            let calculateCurrencies = res.data.values;
            this.setState({
                calculateCurrencies: calculateCurrencies
            })

        }).catch(err => {
            console.log(err);
        })


    }


    async componentDidMount() {

        // this.state.store.api_post_call('getCategories', {}).then(res=> {
        //     // this.setState({user: res.data.values});
        //     console.log('res', res.data);
        //     // allCategories = res.data.values;
        //      this.setState({ categories: res.data.values});
        //     let testCategories = this.state.store.saveCategories(this.state.categories);
        //
        //     // let testUser = this.state.store.saveLoggedUser(this.state.user);
        // }).catch(err => {
        //     console.log(err);
        // })


         if (this.logged) {
             await this.state.store.api_post_call('getUser', {}).then(res=> {
                this.setState({user: res.data.values});
                console.log('user', res.data)
                let testUser = this.state.store.saveLoggedUser(res.data.values);
            }).catch(err => {
                console.log(err);
            })
        }

    }

    updateUserInfo(newUser){
            const updatedState = {
                ...this.state,
                user: newUsercalculateCurrencies

            };
            // this.updateLocalStorageWithState(updatedState);
            // this.setState(updatedState, console.log(this.state.user));

    }

    // addTicket(ticket) {
    //     const updatedState = {
    //         ...this.state,
    //         tickets: [...this.state.tickets, ticket]
    //     };
    //     this.updateLocalStorageWithState(updatedState);
    //     this.setState(updatedState, console.log(this.state.tickets));
    // }
    //
    //
    // updateLocalStorageWithState(updatedState) {
    //     localStorage.setItem(STATE_STORAGE_KEY, JSON.stringify(updatedState));
    // }
    //

    render () {
        console.log('user info', this.state.log);
        console.log('conf properties', this.state.conf);
        console.log('user properties', this.state.user);


        const routes = ['/','/list','/test','/checkout', '/offer','/contact', '/orders','/privacy', '/termsConditions', '/about', '/wishlist', '/cart','/ticket', '/support', '/myprofile', '/updateInfo', '/returns', '/changePass' ];
        let detailedRoute = '/detailed';
        let invoices = '/invoices';
        let list = '/list';

        let currentUrl = window.location.pathname;
        // let currentcat = this.state.store.categories;
        // console.log('state ' , currentcat);
        return (


            <BrowserRouter>
                {routes.includes(currentUrl) || currentUrl.includes(detailedRoute) || currentUrl.includes(list) || currentUrl.includes(invoices) ?
                    <React.Fragment>


                        <HeaderPart isLogged={this.logged} token={this.props.data} logo={this.state.conf.logo} categories={this.state.categories}/>
                        <Switch>
                            <Route exact path='/' component={()=> <HomePage calculateCurrencies={this.state.calculateCurrencies} currency={this.state.conf.currency} conf={this.state.conf} isLogged={this.logged}/>}/>
                            {/*<Route exact path='/test' component={()=> <Test/>}/>*/}
                            <Route exact path='/list' component={()=> <ProductsList categories={this.state.categories} calculateCurrencies={this.state.calculateCurrencies} currency={this.state.conf.currency}/>}/>
                            <Route exact path='/list/sale' component={()=> <Sale categories={this.state.categories} calculateCurrencies={this.state.calculateCurrencies} currency={this.state.conf.currency}/>}/>
                            <Route exact path='/list/:category' component={()=> <ProductsList categories={this.state.categories} calculateCurrencies={this.state.calculateCurrencies}  currency={this.state.conf.currency}/>}/>
                            <Route exact path='/list/:category/:subcategory' component={()=> <ProductsList categories={this.state.categories} calculateCurrencies={this.state.calculateCurrencies}  currency={this.state.conf.currency}/>}/>
                            <Route exact path='/checkout' component={() => <Checkout isLogged={this.logged} calculateCurrencies={this.state.calculateCurrencies} currency={this.state.conf.currency} cash={this.state.conf.cash_payment} shipping={this.state.conf.shipping_type} min_o_fee={this.state.conf.min_o_free} processing_fee={this.state.conf.processing_fee} shipping_fee={this.state.conf.shipping_fee}/>}/>
                            <Route exact path='/contact' component={()=> <ContactUs isLogged={this.logged}/>}/>
                            <Route exact path='/test' component={()=> <Test/>}/>
                            <Route exact path='/about' component={()=> <AboutUs config={this.state.conf} aboutContent={this.state.conf.about_desc} logo={this.state.conf.logo}/>}/>
                            <Route exact path='/wishlist' component={()=> <Wishlist currency={this.state.conf.currency} calculateCurrencies={this.state.calculateCurrencies}/>}/>
                            <Route exact path='/cart' component={()=> <Cart currency={this.state.conf.currency} calculateCurrencies={this.state.calculateCurrencies} min_o_fee={this.state.conf.min_o_free} processing_fee={this.state.conf.processing_fee} shipping_fee={this.state.conf.shipping_fee} />}/>
                            <Route exact path='/detailed/:id' component={ProductCardDetails }/>
                            <Route exact path='/privacy' component={()=> <PrivacyPolices privacy_policy={this.state.conf.privacy_policy}/>}/>
                            <Route exact path='/termsConditions' component={()=> <TermsAndConditions terms_condition={this.state.conf.terms_condition}/>}/>
                            {/*<Route exact path='/detailed/:id' component={()=> <ProductCardDetails currency={this.state.conf.currency}/>}/>*/}
                            {/*<Route exact path='/detailed/:id' component={ProductCardDetails}/>*/}

                            {this.logged ?

                                <React.Fragment>
                                    <Route exact path='/myprofile' component={() => <MyProfile user = {this.state.user} />} />
                                    <Route exact path='/offer' component={() => <Offer/>} />
                                    <Route exact path='/checkout' component={() => <Checkout isLogged={this.logged} user = {this.state.user} calculateCurrencies={this.state.calculateCurrencies} currency={this.state.conf.currency} cash={this.state.conf.cash_payment} shipping={this.state.conf.shipping_type}/>}/>

                                    {/*<Route exact path='/returns' component={OrderView}/>*/}
                                    <Route exact path='/support' component={() => <Chat tickets={this.state.tickets}/>}/>
                                    {/*<Route exact path='/ticket' component={() => <CreateTicket addTicket={this.addTicket} tickets={this.state.tickets}/>}/>*/}
                                    <Route exact path='/updateInfo' component={() => <UpdatePersonalInfo updateUserInfo={this.updateUserInfo}/>}/>
                                    {/*<Route exact path='/invoices' component={() => <Invoices user = {this.state.user} logo={this.state.conf.logo} company={this.state.conf.company_name} address={this.state.conf.address} tel={this.state.conf.tel} email={this.state.conf.main_email} />}/>*/}
                                    <Route exact path='/invoices/:id' component={() => <Invoices currency = {this.state.conf.currency} calculateCurrencies={this.state.calculateCurrencies} shipping_fee={this.state.conf.shipping_fee} token={this.props.data} user = {this.state.user} logo={this.state.conf.logo} company={this.state.conf.company_name} address={this.state.conf.address} tel={this.state.conf.tel} email={this.state.conf.main_email} />}/>
                                    <Route exact path='/orders' component={()=> <OrdersAndReturns currency = {this.state.conf.currency} calculateCurrencies={this.state.calculateCurrencies}/>}/>
                                    <Route exact path='/changePass' component={() => <AccessDetails/>}/>
                                </React.Fragment>

                                : null}

                        </Switch>
                        <BrandPart/>
                        {/*<NewsletterPart/>*/}
                        <FooterPart isLogged={this.logged} config={this.state.conf} logo={this.state.conf.logo} company={this.state.conf.company_name} address={this.state.conf.address} tel={this.state.conf.tel} email={this.state.conf.main_email}/>
                        <a href="#" className="back-to-top"><i className="fal fa-chevron-up"> </i> </a>

                    </React.Fragment>
                    :

                    <React.Fragment>
                        <Route path='/*' component={PageNotFound}/>
                    </React.Fragment>
                }

            </BrowserRouter>
      )
    }
}

if (document.getElementById('myExp')) {
    const element = document.getElementById('myExp');
    const data = $('#authenticatedToken').attr('data');
    const logged = $('#authenticatedToken').attr('logged');
    const url = $('#authenticatedToken').attr('url');
    const conf = $('#authenticatedToken').attr('conf');
    ReactDOM.render(<MainApp data={data} logged={logged} url={url} conf={conf}/>,
        element);

}
