"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.sizeHeight = exports.sizeWidth = exports.minHeight = exports.maxHeight = exports.height = exports.minWidth = exports.maxWidth = exports.width = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

function transform(value) {
  return value <= 1 ? "".concat(value * 100, "%") : value;
}

var width = (0, _style.default)({
  prop: 'width',
  transform: transform
});
exports.width = width;
var maxWidth = (0, _style.default)({
  prop: 'maxWidth',
  transform: transform
});
exports.maxWidth = maxWidth;
var minWidth = (0, _style.default)({
  prop: 'minWidth',
  transform: transform
});
exports.minWidth = minWidth;
var height = (0, _style.default)({
  prop: 'height',
  transform: transform
});
exports.height = height;
var maxHeight = (0, _style.default)({
  prop: 'maxHeight',
  transform: transform
});
exports.maxHeight = maxHeight;
var minHeight = (0, _style.default)({
  prop: 'minHeight',
  transform: transform
});
exports.minHeight = minHeight;
var sizeWidth = (0, _style.default)({
  prop: 'size',
  cssProperty: 'width',
  transform: transform
});
exports.sizeWidth = sizeWidth;
var sizeHeight = (0, _style.default)({
  prop: 'size',
  cssProperty: 'height',
  transform: transform
});
exports.sizeHeight = sizeHeight;
var sizing = (0, _compose.default)(width, maxWidth, minWidth, height, maxHeight, minHeight);
var _default = sizing;
exports.default = _default;