"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.sheetsManager = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _warning = _interopRequireDefault(require("warning"));

var _hoistNonReactStatics = _interopRequireDefault(require("hoist-non-react-statics"));

var _utils = require("@material-ui/utils");

var _jss = require("jss");

var _reactJssContext = _interopRequireDefault(require("./reactJssContext"));

var _jssPreset = _interopRequireDefault(require("./jssPreset"));

var _mergeClasses = _interopRequireDefault(require("./mergeClasses"));

var _multiKeyStore = _interopRequireDefault(require("./multiKeyStore"));

var _createMuiTheme = _interopRequireDefault(require("./createMuiTheme"));

var _themeListener = _interopRequireDefault(require("./themeListener"));

var _createGenerateClassName = _interopRequireDefault(require("./createGenerateClassName"));

var _getStylesCreator = _interopRequireDefault(require("./getStylesCreator"));

var _getThemeProps = _interopRequireDefault(require("./getThemeProps"));

/* eslint-disable no-underscore-dangle */
// Default JSS instance.
var jss = (0, _jss.create)((0, _jssPreset.default)()); // Use a singleton or the provided one by the context.
//
// The counter-based approach doesn't tolerate any mistake.
// It's much safer to use the same counter everywhere.

var generateClassName = (0, _createGenerateClassName.default)(); // Global index counter to preserve source order.
// We create the style sheet during at the creation of the component,
// children are handled after the parents, so the order of style elements would be parent->child.
// It is a problem though when a parent passes a className
// which needs to override any child's styles.
// StyleSheet of the child has a higher specificity, because of the source order.
// So our solution is to render sheets them in the reverse order child->sheet, so
// that parent has a higher specificity.

var indexCounter = -10e10; // Exported for test purposes

var sheetsManager = new Map(); // We use the same empty object to ref count the styles that don't need a theme object.

exports.sheetsManager = sheetsManager;
var noopTheme = {}; // In order to have self-supporting components, we rely on default theme when not provided.

var defaultTheme = (0, _createMuiTheme.default)({
  typography: {
    suppressWarning: true
  }
}); // Link a style sheet with a component.
// It does not modify the component passed to it;
// instead, it returns a new component, with a `classes` property.

var withStylesOld = function withStylesOld(stylesOrCreator) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return function (Component) {
    var _extends2;

    var _options$withTheme = options.withTheme,
        withTheme = _options$withTheme === void 0 ? false : _options$withTheme,
        _options$flip = options.flip,
        flip = _options$flip === void 0 ? null : _options$flip,
        name = options.name,
        styleSheetOptions = (0, _objectWithoutProperties2.default)(options, ["withTheme", "flip", "name"]);
    var stylesCreator = (0, _getStylesCreator.default)(stylesOrCreator);
    var listenToTheme = stylesCreator.themingEnabled || typeof name === 'string' || withTheme;
    indexCounter += 1;
    stylesCreator.options.index = indexCounter;
    process.env.NODE_ENV !== "production" ? (0, _warning.default)(indexCounter < 0, ['Material-UI: you might have a memory leak.', 'The indexCounter is not supposed to grow that much.'].join('\n')) : void 0;

    var WithStyles =
    /*#__PURE__*/
    function (_React$Component) {
      (0, _inherits2.default)(WithStyles, _React$Component);

      function WithStyles(props, context) {
        var _this;

        (0, _classCallCheck2.default)(this, WithStyles);
        _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(WithStyles).call(this, props, context));
        _this.jss = context[_reactJssContext.default.jss] || jss;
        _this.sheetsManager = sheetsManager;
        _this.unsubscribeId = null;
        var muiThemeProviderOptions = context.muiThemeProviderOptions;

        if (muiThemeProviderOptions) {
          if (muiThemeProviderOptions.sheetsManager) {
            _this.sheetsManager = muiThemeProviderOptions.sheetsManager;
          }

          _this.sheetsCache = muiThemeProviderOptions.sheetsCache;
          _this.disableStylesGeneration = muiThemeProviderOptions.disableStylesGeneration;
        } // Attach the stylesCreator to the instance of the component as in the context
        // of react-hot-loader the hooks can be executed in a different closure context:
        // https://github.com/gaearon/react-hot-loader/blob/master/src/patch.dev.js#L107


        _this.stylesCreatorSaved = stylesCreator;
        _this.sheetOptions = (0, _extends3.default)({
          generateClassName: generateClassName
        }, context[_reactJssContext.default.sheetOptions]); // We use || as the function call is lazy evaluated.

        _this.theme = listenToTheme ? _themeListener.default.initial(context) || defaultTheme : noopTheme;

        _this.attach(_this.theme);

        _this.cacheClasses = {
          // Cache for the finalized classes value.
          value: null,
          // Cache for the last used classes prop pointer.
          lastProp: null,
          // Cache for the last used rendered classes pointer.
          lastJSS: {}
        };
        return _this;
      }

      (0, _createClass2.default)(WithStyles, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          var _this2 = this;

          if (!listenToTheme) {
            return;
          }

          this.unsubscribeId = _themeListener.default.subscribe(this.context, function (theme) {
            var oldTheme = _this2.theme;
            _this2.theme = theme;

            _this2.attach(_this2.theme); // Rerender the component so the underlying component gets the theme update.
            // By theme update we mean receiving and applying the new class names.


            _this2.setState({}, function () {
              _this2.detach(oldTheme);
            });
          });
        }
      }, {
        key: "componentDidUpdate",
        value: function componentDidUpdate() {
          // react-hot-loader specific logic
          if (this.stylesCreatorSaved === stylesCreator || process.env.NODE_ENV === 'production') {
            return;
          }

          this.detach(this.theme);
          this.stylesCreatorSaved = stylesCreator;
          this.attach(this.theme);
          this.forceUpdate();
        }
      }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          this.detach(this.theme);

          if (this.unsubscribeId !== null) {
            _themeListener.default.unsubscribe(this.context, this.unsubscribeId);
          }
        }
      }, {
        key: "getClasses",
        value: function getClasses() {
          if (this.disableStylesGeneration) {
            return this.props.classes || {};
          } // Tracks if either the rendered classes or classes prop has changed,
          // requiring the generation of a new finalized classes object.


          var generate = false;

          var sheetManager = _multiKeyStore.default.get(this.sheetsManager, this.stylesCreatorSaved, this.theme);

          if (sheetManager.sheet.classes !== this.cacheClasses.lastJSS) {
            this.cacheClasses.lastJSS = sheetManager.sheet.classes;
            generate = true;
          }

          if (this.props.classes !== this.cacheClasses.lastProp) {
            this.cacheClasses.lastProp = this.props.classes;
            generate = true;
          }

          if (generate) {
            this.cacheClasses.value = (0, _mergeClasses.default)({
              baseClasses: this.cacheClasses.lastJSS,
              newClasses: this.props.classes,
              Component: Component
            });
          }

          return this.cacheClasses.value;
        }
      }, {
        key: "attach",
        value: function attach(theme) {
          if (this.disableStylesGeneration) {
            return;
          }

          var stylesCreatorSaved = this.stylesCreatorSaved;

          var sheetManager = _multiKeyStore.default.get(this.sheetsManager, stylesCreatorSaved, theme);

          if (!sheetManager) {
            sheetManager = {
              refs: 0,
              sheet: null
            };

            _multiKeyStore.default.set(this.sheetsManager, stylesCreatorSaved, theme, sheetManager);
          }

          if (sheetManager.refs === 0) {
            var sheet;

            if (this.sheetsCache) {
              sheet = _multiKeyStore.default.get(this.sheetsCache, stylesCreatorSaved, theme);
            }

            if (!sheet) {
              sheet = this.createSheet(theme);
              sheet.attach();

              if (this.sheetsCache) {
                _multiKeyStore.default.set(this.sheetsCache, stylesCreatorSaved, theme, sheet);
              }
            }

            sheetManager.sheet = sheet;
            var sheetsRegistry = this.context[_reactJssContext.default.sheetsRegistry];

            if (sheetsRegistry) {
              sheetsRegistry.add(sheet);
            }
          }

          sheetManager.refs += 1;
        }
      }, {
        key: "createSheet",
        value: function createSheet(theme) {
          var styles = this.stylesCreatorSaved.create(theme, name);
          var meta = name;

          if (process.env.NODE_ENV !== 'production' && !meta) {
            // Provide a better DX outside production.
            meta = (0, _utils.getDisplayName)(Component);
            process.env.NODE_ENV !== "production" ? (0, _warning.default)(typeof meta === 'string', ['Material-UI: the component displayName is invalid. It needs to be a string.', "Please fix the following component: ".concat(Component, ".")].join('\n')) : void 0;
          }

          var sheet = this.jss.createStyleSheet(styles, (0, _extends3.default)({
            meta: meta,
            classNamePrefix: meta,
            flip: typeof flip === 'boolean' ? flip : theme.direction === 'rtl',
            link: false
          }, this.sheetOptions, this.stylesCreatorSaved.options, {
            name: name || Component.displayName
          }, styleSheetOptions));
          return sheet;
        }
      }, {
        key: "detach",
        value: function detach(theme) {
          if (this.disableStylesGeneration) {
            return;
          }

          var sheetManager = _multiKeyStore.default.get(this.sheetsManager, this.stylesCreatorSaved, theme);

          sheetManager.refs -= 1;

          if (sheetManager.refs === 0) {
            _multiKeyStore.default.delete(this.sheetsManager, this.stylesCreatorSaved, theme);

            this.jss.removeStyleSheet(sheetManager.sheet);
            var sheetsRegistry = this.context[_reactJssContext.default.sheetsRegistry];

            if (sheetsRegistry) {
              sheetsRegistry.remove(sheetManager.sheet);
            }
          }
        }
      }, {
        key: "render",
        value: function render() {
          var _this$props = this.props,
              classes = _this$props.classes,
              innerRef = _this$props.innerRef,
              other = (0, _objectWithoutProperties2.default)(_this$props, ["classes", "innerRef"]);
          var more = (0, _getThemeProps.default)({
            theme: this.theme,
            name: name,
            props: other
          }); // Provide the theme to the wrapped component.
          // So we don't have to use the `withTheme()` Higher-order Component.

          if (withTheme && !more.theme) {
            more.theme = this.theme;
          }

          return _react.default.createElement(Component, (0, _extends3.default)({}, more, {
            classes: this.getClasses(),
            ref: innerRef
          }));
        }
      }]);
      return WithStyles;
    }(_react.default.Component);

    process.env.NODE_ENV !== "production" ? WithStyles.propTypes = {
      /**
       * Override or extend the styles applied to the component.
       */
      classes: _propTypes.default.object,

      /**
       * Use that property to pass a ref callback to the decorated component.
       */
      innerRef: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object])
    } : void 0;
    WithStyles.contextTypes = (0, _extends3.default)((_extends2 = {
      muiThemeProviderOptions: _propTypes.default.object
    }, (0, _defineProperty2.default)(_extends2, _reactJssContext.default.jss, _propTypes.default.object), (0, _defineProperty2.default)(_extends2, _reactJssContext.default.sheetOptions, _propTypes.default.object), (0, _defineProperty2.default)(_extends2, _reactJssContext.default.sheetsRegistry, _propTypes.default.object), _extends2), listenToTheme ? _themeListener.default.contextTypes : {});

    if (process.env.NODE_ENV !== 'production') {
      WithStyles.displayName = "WithStyles(".concat((0, _utils.getDisplayName)(Component), ")");
    }

    (0, _hoistNonReactStatics.default)(WithStyles, Component);

    if (process.env.NODE_ENV !== 'production') {
      // Exposed for test purposes.
      WithStyles.Naked = Component;
      WithStyles.options = options;
    }

    return WithStyles;
  };
};
/* istanbul ignore if */


if (!_utils.ponyfillGlobal.__MUI_STYLES__) {
  _utils.ponyfillGlobal.__MUI_STYLES__ = {};
}

if (!_utils.ponyfillGlobal.__MUI_STYLES__.withStyles) {
  _utils.ponyfillGlobal.__MUI_STYLES__.withStyles = withStylesOld;
}

var _default = function _default(styles, options) {
  return _utils.ponyfillGlobal.__MUI_STYLES__.withStyles(styles, (0, _extends3.default)({
    defaultTheme: defaultTheme
  }, options));
};

exports.default = _default;