"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _withFormControlContext = _interopRequireDefault(require("../FormControl/withFormControlContext"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _IconButton = _interopRequireDefault(require("../IconButton"));

// @inheritedComponent IconButton
var styles = {
  root: {
    display: 'inline-flex',
    alignItems: 'center',
    transition: 'none',
    '&:hover': {
      // Disable the hover effect for the IconButton.
      backgroundColor: 'transparent'
    }
  },
  checked: {},
  disabled: {},
  input: {
    cursor: 'inherit',
    position: 'absolute',
    opacity: 0,
    width: '100%',
    height: '100%',
    top: 0,
    left: 0,
    margin: 0,
    padding: 0
  }
};
/**
 * @ignore - internal component.
 */

exports.styles = styles;

var SwitchBase =
/*#__PURE__*/
function (_React$Component) {
  (0, _inherits2.default)(SwitchBase, _React$Component);

  function SwitchBase(props) {
    var _this;

    (0, _classCallCheck2.default)(this, SwitchBase);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(SwitchBase).call(this));

    _this.handleFocus = function (event) {
      if (_this.props.onFocus) {
        _this.props.onFocus(event);
      }

      var muiFormControl = _this.props.muiFormControl;

      if (muiFormControl && muiFormControl.onFocus) {
        muiFormControl.onFocus(event);
      }
    };

    _this.handleBlur = function (event) {
      if (_this.props.onBlur) {
        _this.props.onBlur(event);
      }

      var muiFormControl = _this.props.muiFormControl;

      if (muiFormControl && muiFormControl.onBlur) {
        muiFormControl.onBlur(event);
      }
    };

    _this.handleInputChange = function (event) {
      var checked = event.target.checked;

      if (!_this.isControlled) {
        _this.setState({
          checked: checked
        });
      }

      if (_this.props.onChange) {
        _this.props.onChange(event, checked);
      }
    };

    _this.isControlled = props.checked != null;
    _this.state = {};

    if (!_this.isControlled) {
      // not controlled, use internal state
      _this.state.checked = props.defaultChecked !== undefined ? props.defaultChecked : false;
    }

    return _this;
  }

  (0, _createClass2.default)(SwitchBase, [{
    key: "render",
    value: function render() {
      var _classNames;

      var _this$props = this.props,
          autoFocus = _this$props.autoFocus,
          checkedProp = _this$props.checked,
          checkedIcon = _this$props.checkedIcon,
          classes = _this$props.classes,
          classNameProp = _this$props.className,
          defaultChecked = _this$props.defaultChecked,
          disabledProp = _this$props.disabled,
          icon = _this$props.icon,
          id = _this$props.id,
          inputProps = _this$props.inputProps,
          inputRef = _this$props.inputRef,
          muiFormControl = _this$props.muiFormControl,
          name = _this$props.name,
          onBlur = _this$props.onBlur,
          onChange = _this$props.onChange,
          onFocus = _this$props.onFocus,
          readOnly = _this$props.readOnly,
          required = _this$props.required,
          tabIndex = _this$props.tabIndex,
          type = _this$props.type,
          value = _this$props.value,
          other = (0, _objectWithoutProperties2.default)(_this$props, ["autoFocus", "checked", "checkedIcon", "classes", "className", "defaultChecked", "disabled", "icon", "id", "inputProps", "inputRef", "muiFormControl", "name", "onBlur", "onChange", "onFocus", "readOnly", "required", "tabIndex", "type", "value"]);
      var disabled = disabledProp;

      if (muiFormControl) {
        if (typeof disabled === 'undefined') {
          disabled = muiFormControl.disabled;
        }
      }

      var checked = this.isControlled ? checkedProp : this.state.checked;
      var hasLabelFor = type === 'checkbox' || type === 'radio';
      return _react.default.createElement(_IconButton.default, (0, _extends2.default)({
        component: "span",
        className: (0, _classnames.default)(classes.root, (_classNames = {}, (0, _defineProperty2.default)(_classNames, classes.checked, checked), (0, _defineProperty2.default)(_classNames, classes.disabled, disabled), _classNames), classNameProp),
        disabled: disabled,
        tabIndex: null,
        role: undefined,
        onFocus: this.handleFocus,
        onBlur: this.handleBlur
      }, other), checked ? checkedIcon : icon, _react.default.createElement("input", (0, _extends2.default)({
        autoFocus: autoFocus,
        checked: checkedProp,
        defaultChecked: defaultChecked,
        className: classes.input,
        disabled: disabled,
        id: hasLabelFor && id,
        name: name,
        onChange: this.handleInputChange,
        readOnly: readOnly,
        ref: inputRef,
        required: required,
        tabIndex: tabIndex,
        type: type,
        value: value
      }, inputProps)));
    }
  }]);
  return SwitchBase;
}(_react.default.Component); // NB: If changed, please update Checkbox, Switch and Radio
// so that the API documentation is updated.


process.env.NODE_ENV !== "production" ? SwitchBase.propTypes = {
  /**
   * If `true`, the input will be focused during the first mount.
   */
  autoFocus: _propTypes.default.bool,

  /**
   * If `true`, the component is checked.
   */
  checked: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.string]),

  /**
   * The icon to display when the component is checked.
   */
  checkedIcon: _propTypes.default.node.isRequired,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css-api) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * @ignore
   */
  defaultChecked: _propTypes.default.bool,

  /**
   * If `true`, the switch will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the ripple effect will be disabled.
   */
  disableRipple: _propTypes.default.bool,

  /**
   * The icon to display when the component is unchecked.
   */
  icon: _propTypes.default.node.isRequired,

  /**
   * The id of the `input` element.
   */
  id: _propTypes.default.string,

  /**
   * Attributes applied to the `input` element.
   */
  inputProps: _propTypes.default.object,

  /**
   * Use that property to pass a ref callback to the native input component.
   */
  inputRef: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * @ignore
   */
  muiFormControl: _propTypes.default.object,

  /*
   * @ignore
   */
  name: _propTypes.default.string,

  /**
   * @ignore
   */
  onBlur: _propTypes.default.func,

  /**
   * Callback fired when the state is changed.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.checked`.
   * @param {boolean} checked The `checked` value of the switch
   */
  onChange: _propTypes.default.func,

  /**
   * @ignore
   */
  onFocus: _propTypes.default.func,

  /**
   * It prevents the user from changing the value of the field
   * (not from interacting with the field).
   */
  readOnly: _propTypes.default.bool,

  /**
   * If `true`, the input will be required.
   */
  required: _propTypes.default.bool,

  /**
   * @ignore
   */
  tabIndex: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * The input component property `type`.
   */
  type: _propTypes.default.string.isRequired,

  /**
   * The value of the component.
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.bool])
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiPrivateSwitchBase'
})((0, _withFormControlContext.default)(SwitchBase));

exports.default = _default;