"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _ButtonBase = _interopRequireDefault(require("../ButtonBase"));

var _helpers = require("../utils/helpers");

var _unsupportedProp = _interopRequireDefault(require("../utils/unsupportedProp"));

// @inheritedComponent ButtonBase
var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: (0, _extends3.default)({}, theme.typography.button, (0, _defineProperty2.default)({
      maxWidth: 264,
      minWidth: 72,
      position: 'relative',
      boxSizing: 'border-box',
      padding: 0,
      minHeight: 48,
      flexShrink: 0,
      overflow: 'hidden',
      whiteSpace: 'normal',
      textAlign: 'center'
    }, theme.breakpoints.up('md'), {
      fontSize: theme.typography.pxToRem(13),
      minWidth: 160
    })),

    /* Styles applied to the root element if both `icon` and `label` are provided. */
    labelIcon: {
      minHeight: 72,
      // paddingTop supposed to be 12px
      // - 3px from the paddingBottom
      paddingTop: 9 // paddingBottom supposed to be 12px
      // -3px for line-height of the label
      // -6px for label padding
      // = 3px

    },

    /* Styles applied to the root element if `textColor="inherit"`. */
    textColorInherit: {
      color: 'inherit',
      opacity: 0.7,
      '&$selected': {
        opacity: 1
      },
      '&$disabled': {
        opacity: 0.4
      }
    },

    /* Styles applied to the root element if `textColor="primary"`. */
    textColorPrimary: {
      color: theme.palette.text.secondary,
      '&$selected': {
        color: theme.palette.primary.main
      },
      '&$disabled': {
        color: theme.palette.text.disabled
      }
    },

    /* Styles applied to the root element if `textColor="secondary"`. */
    textColorSecondary: {
      color: theme.palette.text.secondary,
      '&$selected': {
        color: theme.palette.secondary.main
      },
      '&$disabled': {
        color: theme.palette.text.disabled
      }
    },

    /* Styles applied to the root element if `selected={true}` (controlled by the Tabs component). */
    selected: {},

    /* Styles applied to the root element if `disabled={true}` (controlled by the Tabs component). */
    disabled: {},

    /* Styles applied to the root element if `fullWidth={true}` (controlled by the Tabs component). */
    fullWidth: {
      flexShrink: 1,
      flexGrow: 1,
      maxWidth: 'none'
    },

    /* Styles applied to the `icon` and `label`'s wrapper element. */
    wrapper: {
      display: 'inline-flex',
      alignItems: 'center',
      justifyContent: 'center',
      width: '100%',
      flexDirection: 'column'
    },

    /* Styles applied to the label container element if `label` is provided. */
    labelContainer: (0, _defineProperty2.default)({
      width: '100%',
      // Fix an IE 11 issue
      boxSizing: 'border-box',
      padding: '6px 12px'
    }, theme.breakpoints.up('md'), {
      padding: '6px 24px'
    }),

    /* Styles applied to the label wrapper element if `label` is provided. */
    label: {},

    /* Deprecated, the styles will be removed in v4. */
    labelWrapped: {}
  };
};

exports.styles = styles;

var Tab =
/*#__PURE__*/
function (_React$Component) {
  (0, _inherits2.default)(Tab, _React$Component);

  function Tab() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, Tab);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(Tab)).call.apply(_getPrototypeOf2, [this].concat(args)));
    _this.state = {
      labelWrapped: false
    };

    _this.handleChange = function (event) {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          value = _this$props.value,
          onClick = _this$props.onClick;

      if (onChange) {
        onChange(event, value);
      }

      if (onClick) {
        onClick(event);
      }
    };

    _this.checkTextWrap = function () {
      if (_this.labelRef) {
        var labelWrapped = _this.labelRef.getClientRects().length > 1;

        if (_this.state.labelWrapped !== labelWrapped) {
          _this.setState({
            labelWrapped: labelWrapped
          });
        }
      }
    };

    return _this;
  }

  (0, _createClass2.default)(Tab, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.checkTextWrap();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (this.state.labelWrapped === prevState.labelWrapped) {
        /**
         * At certain text and tab lengths, a larger font size may wrap to two lines while the smaller
         * font size still only requires one line.  This check will prevent an infinite render loop
         * from occurring in that scenario.
         */
        this.checkTextWrap();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this,
          _classNames2;

      var _this$props2 = this.props,
          classes = _this$props2.classes,
          className = _this$props2.className,
          disabled = _this$props2.disabled,
          fullWidth = _this$props2.fullWidth,
          icon = _this$props2.icon,
          indicator = _this$props2.indicator,
          labelProp = _this$props2.label,
          onChange = _this$props2.onChange,
          selected = _this$props2.selected,
          textColor = _this$props2.textColor,
          value = _this$props2.value,
          other = (0, _objectWithoutProperties2.default)(_this$props2, ["classes", "className", "disabled", "fullWidth", "icon", "indicator", "label", "onChange", "selected", "textColor", "value"]);
      var label;

      if (labelProp !== undefined) {
        label = _react.default.createElement("span", {
          className: classes.labelContainer
        }, _react.default.createElement("span", {
          className: (0, _classnames.default)(classes.label, (0, _defineProperty2.default)({}, classes.labelWrapped, this.state.labelWrapped)),
          ref: function ref(_ref) {
            _this2.labelRef = _ref;
          }
        }, labelProp));
      }

      return _react.default.createElement(_ButtonBase.default, (0, _extends3.default)({
        focusRipple: true,
        className: (0, _classnames.default)(classes.root, classes["textColor".concat((0, _helpers.capitalize)(textColor))], (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, classes.disabled, disabled), (0, _defineProperty2.default)(_classNames2, classes.selected, selected), (0, _defineProperty2.default)(_classNames2, classes.labelIcon, icon && label), (0, _defineProperty2.default)(_classNames2, classes.fullWidth, fullWidth), _classNames2), className),
        role: "tab",
        "aria-selected": selected,
        disabled: disabled
      }, other, {
        onClick: this.handleChange
      }), _react.default.createElement("span", {
        className: classes.wrapper
      }, icon, label), indicator);
    }
  }]);
  return Tab;
}(_react.default.Component);

process.env.NODE_ENV !== "production" ? Tab.propTypes = {
  /**
   * This property isn't supported.
   * Use the `component` property if you need to change the children structure.
   */
  children: _unsupportedProp.default,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css-api) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * If `true`, the tab will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * @ignore
   */
  fullWidth: _propTypes.default.bool,

  /**
   * The icon element.
   */
  icon: _propTypes.default.node,

  /**
   * @ignore
   * For server-side rendering consideration, we let the selected tab
   * render the indicator.
   */
  indicator: _propTypes.default.node,

  /**
   * The label element.
   */
  label: _propTypes.default.node,

  /**
   * @ignore
   */
  onChange: _propTypes.default.func,

  /**
   * @ignore
   */
  onClick: _propTypes.default.func,

  /**
   * @ignore
   */
  selected: _propTypes.default.bool,

  /**
   * @ignore
   */
  textColor: _propTypes.default.oneOf(['secondary', 'primary', 'inherit']),

  /**
   * You can provide your own value. Otherwise, we fallback to the child position index.
   */
  value: _propTypes.default.any
} : void 0;
Tab.defaultProps = {
  disabled: false,
  textColor: 'inherit'
};

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiTab'
})(Tab);

exports.default = _default;