

CREATE TABLE `articles` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `source_link_id` int(11) NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_name` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `article` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `files` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `banners`
--

CREATE TABLE `banners` (
  `id` int(10) UNSIGNED NOT NULL,
  `prod_id` int(11) NOT NULL DEFAULT 0,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'banner',
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `banners`
--

INSERT INTO `banners` (`id`, `prod_id`, `image`, `description`, `type`, `status`, `created_at`, `updated_at`) VALUES
(4, 37, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff3192d1681d.jpg', 'Lipstick collection', 'banner', 9, '2021-01-04 12:33:33', '2021-01-04 12:34:57'),
(5, 54, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff3192d2fa7c.jpg', 'New', 'banner', 9, '2021-01-04 12:33:34', '2021-01-04 12:34:57'),
(6, 37, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff31958d7666.jpg', 'Pink shades collection', 'banner', 0, '2021-01-04 12:34:16', '2021-01-04 12:34:57'),
(7, 54, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff319590090b.jpg', 'New', 'banner', 0, '2021-01-04 12:34:17', '2021-01-04 12:34:57'),
(8, 45, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff31959ece03.jpg', 'Lipstick collection', 'banner', 0, '2021-01-04 12:34:18', '2021-01-04 12:34:57'),
(9, 37, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff31981ce3a6.jpg', 'Pink shades collection', 'banner', 1, '2021-01-04 12:34:57', '2021-01-04 12:34:57'),
(10, 54, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff31981e76b0.jpg', 'New', 'banner', 1, '2021-01-04 12:34:58', '2021-01-04 12:34:58'),
(11, 45, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff31982ce2a7.jpg', 'Lipstick collection', 'banner', 1, '2021-01-04 12:34:59', '2021-01-04 12:34:59'),
(12, 43, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff3198324cd5.jpg', 'Pink everywhere', 'banner', 1, '2021-01-04 12:34:59', '2021-01-04 12:34:59'),
(13, 54, 'http://modapascher.mangosoft.mk/storage/images/1/banner/5ff31983641e1.jpg', 'Autumn collection', 'banner', 1, '2021-01-04 12:34:59', '2021-01-04 12:34:59'),
(14, 0, 'http://modapascher.mangosoft.mk/storage/images/1/horizontal_products/5ff321a178814.jpg', NULL, 'horizontal_products', 0, '2021-01-04 13:09:37', '2021-01-04 13:09:43'),
(15, 0, 'http://modapascher.mangosoft.mk/storage/images/1/horizontal_products/5ff321a76cbde.jpg', NULL, 'horizontal_products', 1, '2021-01-04 13:09:43', '2021-01-04 13:09:43'),
(24, 0, 'http://modapascher.mangosoft.mk/storage/images/1/collection/5ff3240bc9cd4.jpeg', 'Lipstick', 'collection', 9, '2021-01-04 13:19:55', '2021-01-04 13:40:43'),
(25, 0, 'http://modapascher.mangosoft.mk/storage/images/1/collection/5ff3240be60ef.jpeg', 'Mouth', 'collection', 9, '2021-01-04 13:19:56', '2021-01-04 13:40:43'),
(26, 0, 'http://modapascher.mangosoft.mk/storage/images/1/collection/5ff32452b5564.jpeg', 'Lipstick', 'collection', 0, '2021-01-04 13:21:06', '2021-01-04 13:40:43'),
(27, 0, 'http://modapascher.mangosoft.mk/storage/images/1/collection/5ff32452d3dbc.jpeg', 'Mouth', 'collection', 0, '2021-01-04 13:21:06', '2021-01-04 13:40:43'),
(28, 0, 'http://modapascher.mangosoft.mk/storage/images/1/collection/5ff32452ed370.jpeg', NULL, 'collection', 0, '2021-01-04 13:21:07', '2021-01-04 13:40:43'),
(29, 40, 'http://modapascher.mangosoft.mk/storage/images/1/collection/5ff328eb9c676.jpeg', 'Lipstick', 'collection', 1, '2021-01-04 13:40:43', '2021-01-04 13:40:43'),
(30, 37, 'http://modapascher.mangosoft.mk/storage/images/1/collection/5ff328ebb8648.jpeg', 'Mouth', 'collection', 1, '2021-01-04 13:40:43', '2021-01-04 13:40:43'),
(31, 55, 'http://modapascher.mangosoft.mk/storage/images/1/collection/5ff328ebd2352.jpeg', 'Make up', 'collection', 1, '2021-01-04 13:40:43', '2021-01-04 13:40:43');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(10) UNSIGNED NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `title`, `icon`, `status`, `created_at`, `updated_at`) VALUES
(1, 'Maquillage', 'http://modapascher.mangosoft.mk/storage/images/1/category_icon/5ff32994514b3.jpg', 1, '2020-12-01 12:11:16', '2021-01-04 13:43:32'),
(2, 'Accessoire', 'http://modapascher.mangosoft.mk/storage/images/1/category_icon/5ff329f465672.jpg', 1, '2020-12-04 13:07:05', '2021-01-04 13:45:08'),
(3, 'Soin', 'http://modapascher.mangosoft.mk/storage/images/1/category_icon/5ff32abfad1be.jpg', 1, '2020-12-06 14:51:14', '2021-01-04 13:48:31'),
(4, 'Maison', 'http://modapascher.mangosoft.mk/storage/images/1/category_icon/5ff32d67b6177.jpg', 1, '2020-12-06 14:53:02', '2021-01-04 13:59:51'),
(5, 'Bijou', 'http://modapascher.mangosoft.mk/storage/images/1/category_icon/5ff32d0798fd0.jpg', 1, '2020-12-06 14:58:13', '2021-01-04 13:58:15'),
(6, 'Vêtements', NULL, 0, '2020-12-06 15:00:54', '2020-12-06 15:01:00');

-- --------------------------------------------------------

--
-- Table structure for table `category_sources`
--

CREATE TABLE `category_sources` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `in_order` int(11) NOT NULL DEFAULT 99999,
  `user_id` int(11) NOT NULL DEFAULT 1,
  `parent_id` int(11) NOT NULL DEFAULT 0,
  `article_id` int(11) NOT NULL DEFAULT 0,
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `colors`
--

CREATE TABLE `colors` (
  `id` int(10) UNSIGNED NOT NULL,
  `color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#000000',
  `prod_id` int(11) NOT NULL,
  `size_id` int(11) NOT NULL,
  `stock` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `colors`
--

INSERT INTO `colors` (`id`, `color`, `color_code`, `prod_id`, `size_id`, `stock`, `created_at`, `updated_at`) VALUES
(72, 'white', '#000000', 32, 48, 30, '2020-11-11 11:35:59', '2020-11-11 11:35:59'),
(166, 'black', '#000000', 66, 105, 40, '2020-11-12 01:24:18', '2020-11-12 01:24:18'),
(167, 'blue', '#000000', 67, 106, 30, '2020-11-12 01:30:38', '2020-11-12 01:30:38'),
(168, 'lightblue', '#000000', 67, 106, 30, '2020-11-12 01:30:38', '2020-11-12 01:30:38'),
(169, 'black', '#000000', 68, 107, 40, '2020-11-12 01:31:50', '2020-11-12 01:31:50'),
(170, 'white', '#000000', 69, 108, 9, '2020-11-12 01:43:55', '2020-11-14 13:22:32'),
(171, 'green', '#000000', 70, 109, 30, '2020-11-12 01:45:17', '2020-11-12 01:45:17'),
(172, 'green', '#000000', 71, 110, 39, '2020-11-12 01:46:36', '2020-11-28 08:38:18'),
(173, 'brown', '#000000', 72, 111, 50, '2020-11-12 01:48:08', '2020-11-12 01:48:08'),
(174, 'white', '#000000', 73, 112, 50, '2020-11-12 01:50:11', '2020-11-12 01:50:11'),
(175, 'black', '#000000', 74, 113, 50, '2020-11-12 01:52:25', '2020-11-12 01:52:25'),
(176, 'gray', '#000000', 75, 114, 199, '2020-11-12 02:00:27', '2020-11-13 22:43:20'),
(177, 'pink', '#000000', 75, 114, 200, '2020-11-12 02:00:27', '2020-11-12 02:00:27'),
(178, 'red', '#000000', 76, 115, 200, '2020-11-12 02:02:07', '2020-11-12 02:02:07'),
(179, 'green', '#000000', 76, 115, 200, '2020-11-12 02:02:07', '2020-11-12 02:02:07'),
(180, 'darkblue', '#000000', 76, 115, 200, '2020-11-12 02:02:07', '2020-11-12 02:02:07'),
(181, 'lightblue', '#000000', 76, 115, 200, '2020-11-12 02:02:07', '2020-11-12 02:02:07'),
(182, 'gray', '#000000', 77, 116, 200, '2020-11-12 02:03:18', '2020-11-12 02:03:18'),
(183, 'darkblue', '#000000', 78, 117, 30, '2020-11-12 02:07:22', '2020-11-12 02:07:22'),
(184, 'purple', '#000000', 78, 117, 30, '2020-11-12 02:07:22', '2020-11-12 02:07:22'),
(185, 'red', '#000000', 78, 117, 30, '2020-11-12 02:07:22', '2020-11-12 02:07:22'),
(186, 'pink', '#000000', 78, 117, 30, '2020-11-12 02:07:22', '2020-11-12 02:07:22'),
(221, 'nude', '#ffdd94', 40, 34, 240, '2021-01-02 16:05:05', '2021-01-02 16:05:05'),
(228, '001', '#c47878', 47, 41, 120, '2021-01-02 17:00:26', '2021-01-02 17:00:26'),
(229, '001', '#bd0000', 48, 42, 360, '2021-01-02 17:07:31', '2021-01-02 17:07:31'),
(230, '001', '#813b68', 49, 43, 240, '2021-01-02 17:32:52', '2021-01-02 17:32:52'),
(231, 'one color', '#ffc2c2', 50, 44, 240, '2021-01-02 17:40:38', '2021-01-02 17:40:38'),
(235, '001', '#bb5b56', 54, 48, 120, '2021-01-02 22:54:46', '2021-01-02 22:57:30'),
(329, '009', '#ba804a', 106, 100, 0, '2021-01-05 08:52:16', '2021-01-05 08:52:16'),
(330, '008', '#ba664a', 105, 99, 0, '2021-01-05 08:52:37', '2021-01-05 08:52:37'),
(331, '007', '#514848', 104, 98, 0, '2021-01-05 08:52:46', '2021-01-05 08:52:46'),
(332, '006', '#c27d66', 103, 97, 60, '2021-01-05 08:52:54', '2021-01-05 08:52:54'),
(333, '005', '#ac3e3e', 102, 96, 12, '2021-01-05 08:53:06', '2021-01-05 08:53:06'),
(334, '004', '#b37575', 101, 95, 54, '2021-01-05 08:53:18', '2021-01-05 08:53:18'),
(335, '003', '#6d2c2c', 100, 94, 24, '2021-01-05 08:53:43', '2021-01-05 08:53:43'),
(336, '002', '#bd4a3d', 99, 93, 60, '2021-01-05 08:53:57', '2021-01-05 08:53:57'),
(337, '001', '#ac6262', 98, 92, 30, '2021-01-05 08:54:27', '2021-01-05 08:54:27'),
(338, '001', '#e3c19b', 97, 91, 30, '2021-01-05 08:54:57', '2021-01-05 08:54:57'),
(339, '002', '#deb48a', 97, 91, 30, '2021-01-05 08:54:57', '2021-01-05 08:54:57'),
(340, '003', '#d5aa7f', 97, 91, 30, '2021-01-05 08:54:57', '2021-01-05 08:54:57'),
(341, '004', '#b59169', 97, 91, 30, '2021-01-05 08:54:57', '2021-01-05 08:54:57'),
(342, '001', '#ceb06f', 96, 90, 240, '2021-01-05 08:55:12', '2021-01-05 08:55:12'),
(343, '001', '#b60202', 66, 60, 120, '2021-01-05 08:55:28', '2021-01-05 08:55:28'),
(344, '002', '#09774d', 67, 61, 120, '2021-01-05 08:55:40', '2021-01-05 08:55:40'),
(345, '001', '#bb0cac', 68, 62, 120, '2021-01-05 08:55:50', '2021-01-05 08:55:50'),
(346, '001', '#4b1401', 36, 30, 240, '2021-01-05 08:56:44', '2021-01-05 08:56:44'),
(347, '001', '#d70404', 37, 31, 96, '2021-01-05 08:57:02', '2021-01-05 08:57:02'),
(348, '001', '#ff230a', 38, 32, 240, '2021-01-05 08:57:17', '2021-01-05 08:57:17'),
(349, '001', '#d48c8c', 39, 33, 240, '2021-01-05 08:57:34', '2021-01-05 08:57:34'),
(350, '001', '#a1814a', 41, 35, 240, '2021-01-05 08:57:48', '2021-01-05 08:57:48'),
(351, '001', '#ff7094', 42, 36, 240, '2021-01-05 08:58:23', '2021-01-05 08:58:23'),
(352, '001', '#f0bf7a', 43, 37, 240, '2021-01-05 08:58:54', '2021-01-05 08:58:54'),
(353, '001', '#e90101', 44, 38, 240, '2021-01-05 08:59:06', '2021-01-05 08:59:06'),
(354, '001', '#c70000', 45, 39, 240, '2021-01-05 08:59:31', '2021-01-05 08:59:31'),
(355, '012', '#400570', 46, 40, 120, '2021-01-05 09:00:31', '2021-01-05 09:00:31'),
(356, '007', '#d49b9b', 46, 40, 120, '2021-01-05 09:00:31', '2021-01-05 09:00:31'),
(357, '001', '#a8a8a8', 51, 45, 240, '2021-01-05 09:01:36', '2021-01-05 09:01:36'),
(358, '001', '#dfb9b9', 52, 46, 80, '2021-01-05 09:02:31', '2021-01-05 09:02:31'),
(359, '002', '#7f5c5c', 52, 46, 80, '2021-01-05 09:02:31', '2021-01-05 09:02:31'),
(360, '003', '#a84848', 52, 46, 80, '2021-01-05 09:02:31', '2021-01-05 09:02:31'),
(361, '001', '#fe849e', 53, 47, 120, '2021-01-05 09:03:15', '2021-01-05 09:03:15'),
(362, '002', '#a72525', 53, 47, 120, '2021-01-05 09:03:15', '2021-01-05 09:03:15'),
(363, '001', '#9a2230', 56, 50, 120, '2021-01-05 09:03:25', '2021-01-05 09:03:25'),
(364, '001', '#33191a', 55, 49, 120, '2021-01-05 09:03:35', '2021-01-05 09:03:35'),
(365, '001', '#c23838', 57, 51, 120, '2021-01-05 09:04:03', '2021-01-05 09:04:03'),
(366, '001', '#c8323c', 58, 52, 120, '2021-01-05 09:04:21', '2021-01-05 09:04:21'),
(367, '001', '#ca6868', 62, 56, 120, '2021-01-05 09:04:47', '2021-01-05 09:04:47'),
(368, '001', '#d48282', 61, 55, 120, '2021-01-05 09:05:01', '2021-01-05 09:05:01'),
(369, '001', '#d89292', 60, 54, 0, '2021-01-05 09:05:12', '2021-01-05 09:05:12'),
(370, '001', '#fa5284', 59, 53, 120, '2021-01-05 09:05:44', '2021-01-05 09:05:44'),
(371, '001', '#ffffff', 63, 57, 120, '2021-01-05 09:06:08', '2021-01-05 09:06:08'),
(372, '001', '#ff0088', 64, 58, 120, '2021-01-05 09:06:22', '2021-01-05 09:06:22'),
(373, '001', '#740101', 65, 59, 120, '2021-01-05 09:06:31', '2021-01-05 09:06:31'),
(374, '001', '#f1f38c', 69, 63, 120, '2021-01-05 09:07:50', '2021-01-05 09:07:50'),
(375, '001', '#b58b4f', 70, 64, 120, '2021-01-05 09:07:58', '2021-01-05 09:07:58'),
(376, '001', '#000000', 71, 65, 120, '2021-01-05 09:08:10', '2021-01-05 09:08:10'),
(377, '001', '#000000', 72, 66, 120, '2021-01-05 09:08:24', '2021-01-05 09:08:24'),
(378, '002', '#3b1302', 72, 66, 120, '2021-01-05 09:08:24', '2021-01-05 09:08:24'),
(379, '003', '#070529', 72, 66, 120, '2021-01-05 09:08:24', '2021-01-05 09:08:24'),
(380, '004', '#042801', 72, 66, 120, '2021-01-05 09:08:24', '2021-01-05 09:08:24'),
(381, '001', '#572300', 73, 67, 120, '2021-01-05 09:08:36', '2021-01-05 09:08:36'),
(382, '002', '#282525', 73, 67, 120, '2021-01-05 09:08:36', '2021-01-05 09:08:36'),
(383, '003', '#543117', 73, 67, 120, '2021-01-05 09:08:36', '2021-01-05 09:08:36'),
(384, '001', '#6e0202', 74, 68, 120, '2021-01-05 09:08:48', '2021-01-05 09:08:48'),
(385, '002', '#bf0d0d', 74, 68, 120, '2021-01-05 09:08:48', '2021-01-05 09:08:48'),
(386, '003', '#a05d40', 74, 68, 120, '2021-01-05 09:08:48', '2021-01-05 09:08:48'),
(387, '001', '#ffffff', 75, 69, 120, '2021-01-05 09:08:59', '2021-01-05 09:08:59'),
(388, '002', '#000000', 75, 69, 120, '2021-01-05 09:08:59', '2021-01-05 09:08:59'),
(389, '003', '#000357', 75, 69, 120, '2021-01-05 09:08:59', '2021-01-05 09:08:59'),
(390, '001', '#000000', 76, 70, 120, '2021-01-05 09:09:10', '2021-01-05 09:09:10'),
(391, '002', '#38270a', 76, 70, 120, '2021-01-05 09:09:10', '2021-01-05 09:09:10'),
(392, '003', '#210443', 76, 70, 120, '2021-01-05 09:09:10', '2021-01-05 09:09:10'),
(393, '001', '#000000', 77, 71, 120, '2021-01-05 09:09:20', '2021-01-05 09:09:20'),
(394, '001', '#ac8b5d', 78, 72, 120, '2021-01-05 09:09:37', '2021-01-05 09:09:37'),
(395, '002', '#f79f08', 78, 72, 120, '2021-01-05 09:09:37', '2021-01-05 09:09:37'),
(396, '003', '#bc0b0b', 78, 72, 120, '2021-01-05 09:09:37', '2021-01-05 09:09:37'),
(397, '004', '#f21818', 78, 72, 120, '2021-01-05 09:09:37', '2021-01-05 09:09:37'),
(398, '001', '#000000', 79, 73, 120, '2021-01-05 09:09:49', '2021-01-05 09:09:49'),
(399, '002', '#d7bd19', 79, 73, 120, '2021-01-05 09:09:49', '2021-01-05 09:09:49'),
(400, '003', '#055728', 79, 73, 120, '2021-01-05 09:09:49', '2021-01-05 09:09:49'),
(401, '004', '#091c49', 79, 73, 120, '2021-01-05 09:09:49', '2021-01-05 09:09:49'),
(402, '001', '#ffffff', 80, 74, 120, '2021-01-05 09:09:59', '2021-01-05 09:09:59'),
(403, '001', '#000000', 81, 75, 120, '2021-01-05 09:10:27', '2021-01-05 09:10:27'),
(404, '001', '#000000', 82, 76, 240, '2021-01-05 09:10:37', '2021-01-05 09:10:37'),
(405, '001', '#000000', 83, 77, 240, '2021-01-05 09:10:54', '2021-01-05 09:10:54'),
(406, '001', '#000000', 84, 78, 240, '2021-01-05 09:11:04', '2021-01-05 09:11:04'),
(407, '001', '#250462', 85, 79, 60, '2021-01-05 09:11:19', '2021-01-05 09:11:19'),
(408, '002', '#4d310a', 85, 79, 60, '2021-01-05 09:11:19', '2021-01-05 09:11:19'),
(409, '001', '#000000', 86, 80, 240, '2021-01-05 09:11:43', '2021-01-05 09:11:43'),
(410, '001', '#000000', 87, 81, 240, '2021-01-05 09:12:15', '2021-01-05 09:12:15'),
(411, '001', '#000000', 88, 82, 240, '2021-01-05 09:15:23', '2021-01-05 09:15:23'),
(412, '001', '#000000', 89, 83, 240, '2021-01-05 09:15:43', '2021-01-05 09:15:43'),
(413, '001', '#000000', 90, 84, 240, '2021-01-05 09:15:56', '2021-01-05 09:15:56'),
(414, '001', '#000000', 91, 85, 240, '2021-01-05 09:16:08', '2021-01-05 09:16:08'),
(415, '001', '#000000', 92, 86, 240, '2021-01-05 09:16:31', '2021-01-05 09:16:31'),
(416, '001', '#ffe485', 93, 87, 60, '2021-01-05 09:16:43', '2021-01-05 09:16:43'),
(417, '002', '#e6cd89', 93, 87, 60, '2021-01-05 09:16:43', '2021-01-05 09:16:43'),
(418, '003', '#f0de9d', 93, 87, 60, '2021-01-05 09:16:43', '2021-01-05 09:16:43'),
(419, '004', '#bb9c68', 93, 87, 60, '2021-01-05 09:16:43', '2021-01-05 09:16:43'),
(420, '01', '#f7d2bf', 94, 88, 30, '2021-01-05 09:17:03', '2021-01-05 09:17:03'),
(421, '02', '#fde1cc', 94, 88, 30, '2021-01-05 09:17:03', '2021-01-05 09:17:03'),
(422, '03', '#f5d0b3', 94, 88, 30, '2021-01-05 09:17:03', '2021-01-05 09:17:03'),
(423, '04', '#f7ceb1', 94, 88, 30, '2021-01-05 09:17:03', '2021-01-05 09:17:03'),
(424, '05', '#d5a082', 95, 89, 30, '2021-01-05 09:17:15', '2021-01-05 09:17:15'),
(425, '06', '#cf936d', 95, 89, 30, '2021-01-05 09:17:15', '2021-01-05 09:17:15'),
(426, '07', '#c68f69', 95, 89, 30, '2021-01-05 09:17:15', '2021-01-05 09:17:15'),
(427, '08', '#d18d70', 95, 89, 30, '2021-01-05 09:17:15', '2021-01-05 09:17:15');

-- --------------------------------------------------------

--
-- Table structure for table `coupons`
--

CREATE TABLE `coupons` (
  `id` int(10) UNSIGNED NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `c_limit` int(191) NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `coupons`
--

INSERT INTO `coupons` (`id`, `price`, `start_date`, `end_date`, `status`, `c_limit`, `code`, `type`, `image`, `created_at`, `updated_at`) VALUES
(1, '20.00', '2020-12-14', '2020-12-24', 1, 15, 'Aida20', '%', NULL, '2020-12-14 16:16:18', '2020-12-14 16:20:36');

-- --------------------------------------------------------

--
-- Table structure for table `deals`
--

CREATE TABLE `deals` (
  `id` int(10) UNSIGNED NOT NULL,
  `prod_id` int(11) NOT NULL,
  `deal_price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `galleries`
--

CREATE TABLE `galleries` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `main_id` int(11) NOT NULL,
  `article_id` int(11) NOT NULL,
  `url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `guest_users`
--

CREATE TABLE `guest_users` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `guest_users`
--

INSERT INTO `guest_users` (`id`, `name`, `address`, `city`, `zip`, `tel`, `status`, `created_at`, `updated_at`) VALUES
(1, 'Emels ', 'hdjurbdurb', 'ggdbhdb', '6336', '075976979', 1, '2020-12-28 12:32:19', '2020-12-28 12:32:19'),
(2, 'hdhrury', 'hdhdndb', 'jdjdhrh', '359592', '643464', 1, '2020-12-28 14:02:51', '2020-12-28 14:02:51'),
(3, 'grhdhd', 'jehehrhe', 'heudusue', '616161', '61616161', 1, '2020-12-28 16:40:52', '2020-12-28 16:40:52'),
(4, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 17:41:05', '2020-12-28 17:41:05'),
(5, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 17:43:02', '2020-12-28 17:43:02'),
(6, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 17:47:02', '2020-12-28 17:47:02'),
(7, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 18:01:06', '2020-12-28 18:01:06'),
(8, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 18:03:14', '2020-12-28 18:03:14'),
(9, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 18:17:52', '2020-12-28 18:17:52'),
(10, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 21:30:40', '2020-12-28 21:30:40'),
(11, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 21:30:59', '2020-12-28 21:30:59'),
(12, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 21:33:57', '2020-12-28 21:33:57'),
(13, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 23:01:45', '2020-12-28 23:01:45'),
(14, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 23:03:35', '2020-12-28 23:03:35'),
(15, 'Emel', 'hdhdhd', 'hxhdhdh', '9999', '96573494646', 1, '2020-12-28 23:07:22', '2020-12-28 23:07:22'),
(16, 'Emel', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-28 23:08:59', '2020-12-28 23:08:59'),
(17, 'hhgh', 'yttt', 'hyyg', '6666', '6555', 1, '2020-12-28 23:11:36', '2020-12-28 23:11:36'),
(18, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-29 14:55:21', '2020-12-29 14:55:21'),
(19, 'Emel Islamoski', 'Struga', 'Labunista', '6336', '075976979', 1, '2020-12-29 15:11:04', '2020-12-29 15:11:04'),
(20, 'Emel', 'struga', 'labunista', '6336', '075976979', 1, '2020-12-30 13:09:20', '2020-12-30 13:09:20'),
(21, 'Emel', 'Labunista', 'Struga', '6336', '875976979', 1, '2020-12-30 15:39:26', '2020-12-30 15:39:26');

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_10_12_000000_create_users_table', 1),
(2, '2014_10_12_100000_create_password_resets_table', 1),
(3, '2019_08_19_000000_create_failed_jobs_table', 1),
(4, '2020_07_22_114700_create_products_table', 1),
(5, '2020_07_22_133207_create_sizes_table', 1),
(6, '2020_07_22_133221_create_colors_table', 1),
(7, '2020_07_22_134442_create_orders_table', 1),
(8, '2020_07_22_134846_create_ordered_items_table', 1),
(9, '2020_07_22_135129_create_coupons_table', 1),
(10, '2020_08_03_130646_create_page_configs_table', 1),
(11, '2020_08_15_131857_create_sub_categories_table', 1),
(12, '2020_08_15_131909_create_categories_table', 1),
(13, '2020_08_15_132419_create_deals_table', 1),
(14, '2020_08_15_132616_create_banners_table', 1),
(15, '2020_09_30_130339_create_transactions_table', 2),
(16, '2020_11_09_135411_create_product_images_table', 3),
(17, '2020_11_10_143310_create_sections_table', 4),
(18, '2014_10_12_200000_add_two_factor_columns_to_users_table', 5),
(19, '2019_12_14_000001_create_personal_access_tokens_table', 5),
(20, '2020_09_15_141352_create_sessions_table', 5),
(21, '2020_09_19_104745_create_category_sources_table', 5),
(22, '2020_09_19_104911_create_articles_table', 5),
(23, '2020_10_01_102011_create_galleries_table', 5),
(24, '2020_10_08_140117_create_tags_table', 5),
(25, '2020_12_05_004038_create_shipping_prices_table', 6),
(26, '2020_12_28_115325_create_payment_processeds_table', 7),
(27, '2020_12_28_123012_create_guest_users_table', 7);

-- --------------------------------------------------------

--
-- Table structure for table `ordered_items`
--

CREATE TABLE `ordered_items` (
  `id` int(10) UNSIGNED NOT NULL,
  `order_id` int(11) NOT NULL,
  `prod_id` int(11) NOT NULL,
  `size_id` int(11) NOT NULL,
  `color_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ordered_items`
--

INSERT INTO `ordered_items` (`id`, `order_id`, `prod_id`, `size_id`, `color_id`, `quantity`, `price`, `total`, `status`, `created_at`, `updated_at`) VALUES
(1, 80, 4, 1, 187, 1, '6.00', '6.00', 1, '2020-12-04 08:36:31', '2020-12-04 08:36:31'),
(2, 1, 4, 1, 187, 1, '6.00', '6.00', 1, '2020-12-04 09:20:08', '2020-12-04 09:20:08'),
(3, 2, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-05 14:34:53', '2020-12-05 14:34:53'),
(4, 3, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-05 14:40:43', '2020-12-05 14:40:43'),
(5, 4, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-05 18:25:02', '2020-12-05 18:25:02'),
(6, 5, 12, 6, 192, 1, '2.50', '2.50', 1, '2020-12-05 18:40:35', '2020-12-05 18:40:35'),
(7, 6, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-05 18:42:19', '2020-12-05 18:42:19'),
(8, 7, 16, 10, 196, 1, '2.50', '2.50', 1, '2020-12-07 20:37:46', '2020-12-07 20:37:46'),
(9, 8, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-08 05:33:05', '2020-12-08 05:33:05'),
(10, 9, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-09 15:38:10', '2020-12-09 15:38:10'),
(11, 10, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-09 15:39:00', '2020-12-09 15:39:00'),
(12, 11, 4, 1, 187, 249, '2.50', '622.50', 1, '2020-12-11 11:13:58', '2020-12-11 11:13:58'),
(13, 12, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-11 11:41:08', '2020-12-11 11:41:08'),
(14, 13, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-23 08:56:49', '2020-12-23 08:56:49'),
(15, 14, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-25 11:26:06', '2020-12-25 11:26:06'),
(16, 15, 4, 1, 187, 2, '2.50', '5.00', 1, '2020-12-29 15:09:36', '2020-12-29 15:09:36'),
(17, 16, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-29 15:11:35', '2020-12-29 15:11:35'),
(18, 17, 4, 1, 187, 1, '2.50', '2.50', 1, '2020-12-30 15:37:01', '2020-12-30 15:37:01'),
(19, 18, 4, 1, 214, 1, '2.50', '2.50', 1, '2020-12-30 15:39:47', '2020-12-30 15:39:47');

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL,
  `stripe_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `sum` decimal(10,2) NOT NULL DEFAULT 0.00,
  `processing_fee` decimal(10,2) NOT NULL DEFAULT 0.00,
  `shipping_fee` decimal(10,2) NOT NULL DEFAULT 0.00,
  `subtotal` decimal(10,2) NOT NULL DEFAULT 0.00,
  `discount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_ip_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tel` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `info` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `orders`
--

INSERT INTO `orders` (`id`, `user_id`, `stripe_id`, `paypal_id`, `paypal_data`, `coupon`, `sum`, `processing_fee`, `shipping_fee`, `subtotal`, `discount`, `email`, `name`, `address`, `city`, `zip`, `schedule`, `user_ip_address`, `status`, `created_at`, `updated_at`, `tel`, `info`) VALUES
(1, 6, '2', NULL, NULL, 'None', '18.00', '0.00', '12.00', '6.00', '0.00', 'aida@gmail.com', 'Aida Dzafer', 'NPR', 'Ohrid', '6000', 'delivery', '46.217.60.78', 2, '2020-12-04 09:20:08', '2020-12-04 09:22:26', '5674843299', 'shipped'),
(2, 7, '3', NULL, NULL, '0', '7.00', '0.00', '4.50', '2.50', '0.00', 'test@test.com', 'Test Tester', 'Labunista', 'Struga', '6336', 'delivery', '62.77.142.106', 1, '2020-12-05 14:34:53', '2020-12-05 14:34:53', '8383838192', NULL),
(3, 6, '4', NULL, NULL, '0', '7.00', '0.00', '4.50', '2.50', '0.00', 'aida@gmail.com', 'Aida Dzafer', 'NPR', 'Ohrid', '6000', 'delivery', '46.217.201.185', 1, '2020-12-05 14:40:43', '2020-12-05 14:40:43', '5674843299', NULL),
(4, 8, '5', NULL, NULL, '0', '7.00', '0.00', '4.50', '2.50', '0.00', 'senolhasgeyer@gmail.com', 'Senol Hasgeyer', '3 alleee des templiers', 'Asnieres sur oise', '95270', 'delivery', '94.238.194.196', 1, '2020-12-05 18:25:02', '2020-12-05 18:25:02', '0650914464', NULL),
(5, 8, '6', NULL, NULL, '0', '7.00', '0.00', '4.50', '2.50', '0.00', 'senolhasgeyer@gmail.com', 'Senol Hasgeyer', '3 alleee des templiers', 'Asnieres sur oise', '95270', 'delivery', '94.238.194.196', 1, '2020-12-05 18:40:35', '2020-12-05 18:40:35', '0650914464', NULL),
(6, 8, '7', NULL, NULL, '0', '7.00', '0.00', '4.50', '2.50', '0.00', 'senolhasgeyer@gmail.com', 'Senol Hasgeyer', '3 alleee des templiers', 'Asnieres sur oise', '95270', 'delivery', '94.238.194.196', 1, '2020-12-05 18:42:19', '2020-12-05 18:42:19', '0650914464', NULL),
(7, 8, '8', NULL, NULL, '0', '7.00', '0.00', '4.50', '2.50', '0.00', 'senolhasgeyer@gmail.com', 'Senol Hasgeyer', '3 alleee des templiers', 'Asnieres sur oise', '95270', 'delivery', '82.231.8.74', 1, '2020-12-07 20:37:46', '2020-12-07 20:37:46', '0650914464', NULL),
(8, 8, '9', NULL, NULL, '0', '7.00', '0.00', '4.50', '2.50', '0.00', 'senolhasgeyer@gmail.com', 'Senol Hasgeyer', '3 alleee des templiers', 'Asnieres sur oise', '95270', 'delivery', '176.164.215.115', 2, '2020-12-08 05:33:05', '2020-12-08 11:35:19', '0650914464', 'shipped'),
(9, 7, NULL, '0NP29831J23579930', '{\"create_time\":\"2020-12-09T16:37:53Z\",\"update_time\":\"2020-12-09T16:38:07Z\",\"id\":\"0NP29831J23579930\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"33U04775KD177915R\",\"final_capture\":true,\"create_time\":\"2020-12-09T16:38:07Z\",\"update_time\":\"2020-12-09T16:38:07Z\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/33U04775KD177915R\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/33U04775KD177915R\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/0NP29831J23579930\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/0NP29831J23579930\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '7.00', '0.00', '4.50', '2.50', '0.00', 'test@test.com', 'Test Tester', 'Labunista', 'Struga', '6336', 'delivery', '185.100.245.223', 1, '2020-12-09 15:38:10', '2020-12-09 15:38:10', '8383838192', NULL),
(10, 7, NULL, '3K550184362473351', '{\"create_time\":\"2020-12-09T16:38:42Z\",\"update_time\":\"2020-12-09T16:38:56Z\",\"id\":\"3K550184362473351\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"8YP92810LV6551432\",\"final_capture\":true,\"create_time\":\"2020-12-09T16:38:56Z\",\"update_time\":\"2020-12-09T16:38:56Z\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/8YP92810LV6551432\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/8YP92810LV6551432\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/3K550184362473351\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/3K550184362473351\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '7.00', '0.00', '4.50', '2.50', '0.00', 'test@test.com', 'Test Tester', 'Labunista', 'Struga', '6336', 'delivery', '185.100.245.223', 1, '2020-12-09 15:39:00', '2020-12-09 15:39:00', '8383838192', NULL),
(11, 6, NULL, '798190793L5440327', '{\"create_time\":\"2020-12-11T12:11:36Z\",\"update_time\":\"2020-12-11T12:13:55Z\",\"id\":\"798190793L5440327\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"628.50\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"07882066CY209950X\",\"final_capture\":true,\"create_time\":\"2020-12-11T12:13:55Z\",\"update_time\":\"2020-12-11T12:13:55Z\",\"amount\":{\"value\":\"628.50\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/07882066CY209950X\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/07882066CY209950X\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/798190793L5440327\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/798190793L5440327\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '628.50', '0.00', '6.00', '622.50', '0.00', 'aida@gmail.com', 'Aida Dzafer', 'NPR', 'Ohriddddd', '6000', 'delivery', '37.25.85.240', 1, '2020-12-11 11:13:58', '2020-12-11 11:13:58', '5674843299', NULL),
(12, 7, NULL, '448653271S890231L', '{\"create_time\":\"2020-12-11T12:40:43Z\",\"update_time\":\"2020-12-11T12:41:06Z\",\"id\":\"448653271S890231L\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"1UJ04136B6810963R\",\"final_capture\":true,\"create_time\":\"2020-12-11T12:41:06Z\",\"update_time\":\"2020-12-11T12:41:06Z\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/1UJ04136B6810963R\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/1UJ04136B6810963R\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/448653271S890231L\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/448653271S890231L\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '7.00', '0.00', '4.50', '2.50', '0.00', 'test@test.com', 'Test Tester', 'Labunista', 'Struga', '6336', 'delivery', '192.168.1.1', 1, '2020-12-11 11:41:08', '2020-12-11 11:41:08', '8383838192', NULL),
(13, 7, NULL, '0B40652665925081A', '{\"create_time\":\"2020-12-23T09:56:18Z\",\"update_time\":\"2020-12-23T09:56:47Z\",\"id\":\"0B40652665925081A\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"5A58957295438342S\",\"final_capture\":true,\"create_time\":\"2020-12-23T09:56:47Z\",\"update_time\":\"2020-12-23T09:56:47Z\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/5A58957295438342S\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/5A58957295438342S\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/0B40652665925081A\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/0B40652665925081A\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '7.00', '0.00', '4.50', '2.50', '0.00', 'test@test.com', 'Test Testing', 'Labunista', 'Struga', '6336', 'delivery', '192.168.1.1', 1, '2020-12-23 08:56:49', '2020-12-23 08:56:49', '8383838192', NULL),
(14, 7, NULL, '945141618N562731K', '{\"create_time\":\"2020-12-25T12:25:50Z\",\"update_time\":\"2020-12-25T12:26:03Z\",\"id\":\"945141618N562731K\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"1A082013TL028940A\",\"final_capture\":true,\"create_time\":\"2020-12-25T12:26:03Z\",\"update_time\":\"2020-12-25T12:26:03Z\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/1A082013TL028940A\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/1A082013TL028940A\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/945141618N562731K\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/945141618N562731K\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '7.00', '0.00', '4.50', '2.50', '0.00', 'test@test.com', 'Test Testing', 'Labunista', 'Struga', '6336', 'delivery', '192.168.1.1', 1, '2020-12-25 11:26:06', '2020-12-25 11:26:06', '8383838192', NULL),
(15, 3, NULL, '91235184X0250605T', '{\"create_time\":\"2020-12-29T16:09:18Z\",\"update_time\":\"2020-12-29T16:09:35Z\",\"id\":\"91235184X0250605T\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"9.50\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"69P46825V3668343A\",\"final_capture\":true,\"create_time\":\"2020-12-29T16:09:35Z\",\"update_time\":\"2020-12-29T16:09:35Z\",\"amount\":{\"value\":\"9.50\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/69P46825V3668343A\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/69P46825V3668343A\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/91235184X0250605T\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/91235184X0250605T\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '9.50', '0.00', '4.50', '5.00', '0.00', 'No Email', 'grhdhd', 'jehehrhe', 'heudusue', '616161', 'delivery', '62.77.142.106', 1, '2020-12-29 15:09:36', '2020-12-29 15:09:36', '61616161', NULL),
(16, 19, NULL, '4XF16473LY530140R', '{\"create_time\":\"2020-12-29T16:11:11Z\",\"update_time\":\"2020-12-29T16:11:33Z\",\"id\":\"4XF16473LY530140R\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"3AD89617J03025635\",\"final_capture\":true,\"create_time\":\"2020-12-29T16:11:33Z\",\"update_time\":\"2020-12-29T16:11:33Z\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/3AD89617J03025635\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/3AD89617J03025635\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/4XF16473LY530140R\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/4XF16473LY530140R\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '7.00', '0.00', '4.50', '2.50', '0.00', 'No Email', 'Emel Islamoski', 'Struga', 'Labunista', '6336', 'delivery', '62.77.142.106', 1, '2020-12-29 15:11:35', '2020-12-29 15:11:35', '075976979', NULL),
(17, 7, NULL, '5CK9970456217540H', '{\"create_time\":\"2020-12-30T16:36:37Z\",\"update_time\":\"2020-12-30T16:36:59Z\",\"id\":\"5CK9970456217540H\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"20375978J36833202\",\"final_capture\":true,\"create_time\":\"2020-12-30T16:36:59Z\",\"update_time\":\"2020-12-30T16:36:59Z\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/20375978J36833202\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/20375978J36833202\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/5CK9970456217540H\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/5CK9970456217540H\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '7.00', '0.00', '4.50', '2.50', '0.00', 'test@test.com', 'Test Testing', 'Labunista', 'Struga', '6336', 'delivery', '62.77.142.106', 1, '2020-12-30 15:37:01', '2020-12-30 15:37:01', '8383838192', NULL),
(18, -21, NULL, '6HG020163W177291K', '{\"create_time\":\"2020-12-30T16:39:32Z\",\"update_time\":\"2020-12-30T16:39:45Z\",\"id\":\"6HG020163W177291K\",\"intent\":\"CAPTURE\",\"status\":\"COMPLETED\",\"payer\":{\"email_address\":\"sb-uxek83958109@personal.example.com\",\"payer_id\":\"YVG4SPS7QYWQC\",\"address\":{\"country_code\":\"CY\"},\"name\":{\"given_name\":\"John\",\"surname\":\"Doe\"}},\"purchase_units\":[{\"reference_id\":\"default\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"payee\":{\"email_address\":\"sb-5bc8d4003733@business.example.com\",\"merchant_id\":\"MLGEJDP8XTVRG\"},\"payments\":{\"captures\":[{\"status\":\"PENDING\",\"id\":\"1GM84667PB472050E\",\"final_capture\":true,\"create_time\":\"2020-12-30T16:39:45Z\",\"update_time\":\"2020-12-30T16:39:45Z\",\"amount\":{\"value\":\"7.00\",\"currency_code\":\"EUR\"},\"seller_protection\":{\"status\":\"ELIGIBLE\",\"dispute_categories\":[\"ITEM_NOT_RECEIVED\",\"UNAUTHORIZED_TRANSACTION\"]},\"status_details\":{\"reason\":\"RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION\"},\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/1GM84667PB472050E\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/payments\\/captures\\/1GM84667PB472050E\\/refund\",\"rel\":\"refund\",\"method\":\"POST\",\"title\":\"POST\"},{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/6HG020163W177291K\",\"rel\":\"up\",\"method\":\"GET\",\"title\":\"GET\"}]}]}}],\"links\":[{\"href\":\"https:\\/\\/api.sandbox.paypal.com\\/v2\\/checkout\\/orders\\/6HG020163W177291K\",\"rel\":\"self\",\"method\":\"GET\",\"title\":\"GET\"}]}', 'None', '7.00', '0.00', '4.50', '2.50', '0.00', 'No Email', 'Emel', 'Labunista', 'Struga', '6336', 'delivery', '62.77.142.106', 1, '2020-12-30 15:39:47', '2020-12-30 15:39:47', '875976979', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `page_configs`
--

CREATE TABLE `page_configs` (
  `id` int(10) UNSIGNED NOT NULL,
  `admin_id` int(11) NOT NULL,
  `company_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `about_desc` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `main_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hotline_support` tinyint(4) NOT NULL DEFAULT 0,
  `hotline_num` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_fee` decimal(10,2) NOT NULL DEFAULT 0.00,
  `min_o_free` decimal(10,2) NOT NULL DEFAULT 0.00,
  `processing_fee` decimal(10,2) NOT NULL DEFAULT 0.00,
  `currency` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '$',
  `cash_payment` tinyint(4) NOT NULL DEFAULT 0,
  `shipping_type` tinyint(4) NOT NULL DEFAULT 0,
  `privacy_policy` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `terms_condition` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `facebook` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `page_configs`
--

INSERT INTO `page_configs` (`id`, `admin_id`, `company_name`, `logo`, `about_desc`, `address`, `main_email`, `tel`, `hotline_support`, `hotline_num`, `shipping_fee`, `min_o_free`, `processing_fee`, `currency`, `cash_payment`, `shipping_type`, `privacy_policy`, `terms_condition`, `status`, `facebook`, `twitter`, `instagram`, `created_at`, `updated_at`) VALUES
(1, 1, 'Moda Pas Cher', 'http://modapascher.mangosoft.mk/storage/images/1/logo/logo.png', NULL, 'France', 'info@modapascher.com', NULL, 1, '075976979,3599785748,486845648', '8.00', '0.00', '0.00', '€', 0, 1, NULL, NULL, 1, 'https://www.facebook.com/ModaPasCherFR/videos/?ref=page_internal', NULL, 'https://www.instagram.com/modapascher/', '2020-08-31 06:54:23', '2020-12-07 09:11:28');

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payment_processeds`
--

CREATE TABLE `payment_processeds` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `guest_id` int(11) DEFAULT NULL,
  `products` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `schedule` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `coupon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `payment_processeds`
--

INSERT INTO `payment_processeds` (`id`, `user_id`, `guest_id`, `products`, `user`, `schedule`, `coupon`, `status`, `created_at`, `updated_at`) VALUES
(1, 1, NULL, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emels \",\"city\":\"ggdbhdb\",\"address\":\"hdjurbdurb\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 12:32:19', '2020-12-28 12:32:19'),
(2, NULL, 2, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"hdhrury\",\"city\":\"jdjdhrh\",\"address\":\"hdhdndb\",\"zip\":\"359592\",\"tel\":\"643464\"}', 'delivery', NULL, 0, '2020-12-28 14:02:51', '2020-12-29 15:07:26'),
(3, NULL, 3, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":2}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"grhdhd\",\"city\":\"heudusue\",\"address\":\"jehehrhe\",\"zip\":\"616161\",\"tel\":\"61616161\"}', 'delivery', NULL, 0, '2020-12-28 16:40:52', '2020-12-29 15:09:36'),
(4, NULL, 4, '[{\"id\":4,\"details\":{\"color\":214,\"size\":1,\"quantity\":4}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 17:41:05', '2020-12-28 17:41:05'),
(5, NULL, 5, '[{\"id\":8,\"details\":{\"color\":188,\"size\":2,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 17:43:02', '2020-12-28 17:43:02'),
(6, NULL, 6, '[{\"id\":21,\"details\":{\"color\":201,\"size\":15,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 17:47:02', '2020-12-28 17:47:02'),
(7, NULL, 7, '[{\"id\":8,\"details\":{\"color\":188,\"size\":2,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 18:01:06', '2020-12-28 18:01:06'),
(8, NULL, 8, '[{\"id\":8,\"details\":{\"color\":188,\"size\":2,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 18:03:14', '2020-12-28 18:03:14'),
(9, NULL, 9, '[{\"id\":8,\"details\":{\"color\":188,\"size\":2,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 18:17:52', '2020-12-28 18:17:52'),
(10, 10, NULL, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":3}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 21:30:40', '2020-12-28 21:30:40'),
(11, 11, NULL, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 21:30:59', '2020-12-28 21:30:59'),
(12, 12, NULL, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 21:33:57', '2020-12-28 21:33:57'),
(13, NULL, 13, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 23:01:45', '2020-12-28 23:01:45'),
(14, NULL, 14, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-28 23:03:35', '2020-12-28 23:03:35'),
(15, NULL, 15, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":2}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel\",\"city\":\"hxhdhdh\",\"address\":\"hdhdhd\",\"zip\":\"9999\",\"tel\":\"96573494646\"}', 'delivery', NULL, 1, '2020-12-28 23:07:22', '2020-12-28 23:07:22'),
(16, NULL, 16, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 0, '2020-12-28 23:08:59', '2020-12-29 15:04:01'),
(17, NULL, 17, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"hhgh\",\"city\":\"hyyg\",\"address\":\"yttt\",\"zip\":\"6666\",\"tel\":\"6555\"}', 'delivery', NULL, 1, '2020-12-28 23:11:36', '2020-12-28 23:11:36'),
(18, NULL, 18, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-29 14:55:21', '2020-12-29 14:55:21'),
(19, NULL, 19, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel Islamoski\",\"city\":\"Labunista\",\"address\":\"Struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 0, '2020-12-29 15:11:04', '2020-12-29 15:11:35'),
(20, NULL, 20, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel\",\"city\":\"labunista\",\"address\":\"struga\",\"zip\":\"6336\",\"tel\":\"075976979\"}', 'delivery', NULL, 1, '2020-12-30 13:09:20', '2020-12-30 13:09:20'),
(21, 7, NULL, '[{\"id\":4,\"details\":{\"color\":187,\"size\":1,\"quantity\":1}}]', 'Empty', 'delivery', NULL, 0, '2020-12-30 15:35:37', '2020-12-30 15:37:01'),
(22, NULL, 21, '[{\"id\":4,\"details\":{\"color\":214,\"size\":1,\"quantity\":1}}]', '{\"id\":0,\"email\":\"none\",\"name\":\"Emel\",\"city\":\"Struga\",\"address\":\"Labunista\",\"zip\":\"6336\",\"tel\":\"875976979\"}', 'delivery', NULL, 0, '2020-12-30 15:39:26', '2020-12-30 15:39:47'),
(23, 8, NULL, '[{\"id\":9,\"details\":{\"color\":189,\"size\":3,\"quantity\":1}}]', 'Empty', 'delivery', NULL, 0, '2020-12-30 17:26:14', '2020-12-30 17:26:49'),
(24, 8, NULL, '[{\"id\":9,\"details\":{\"color\":189,\"size\":3,\"quantity\":1}}]', 'Empty', 'delivery', NULL, 0, '2020-12-30 17:26:49', '2020-12-30 17:27:08'),
(25, 8, NULL, '[{\"id\":9,\"details\":{\"color\":189,\"size\":3,\"quantity\":1}}]', 'Empty', 'delivery', NULL, 0, '2020-12-30 17:27:08', '2020-12-30 17:29:47'),
(26, 8, NULL, '[{\"id\":9,\"details\":{\"color\":189,\"size\":3,\"quantity\":1}}]', 'Empty', 'delivery', NULL, 0, '2020-12-30 17:29:47', '2021-01-05 07:05:34'),
(27, 8, NULL, '[{\"id\":38,\"details\":{\"color\":219,\"size\":32,\"quantity\":1}}]', 'Empty', 'delivery', NULL, 0, '2021-01-05 07:05:34', '2021-01-05 07:23:26'),
(28, 8, NULL, '[{\"id\":36,\"details\":{\"color\":217,\"size\":30,\"quantity\":1}}]', 'Empty', 'delivery', NULL, 1, '2021-01-05 07:23:26', '2021-01-05 07:23:26');

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` int(10) UNSIGNED NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_category_id` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 1,
  `price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `weight` decimal(10,2) NOT NULL DEFAULT 0.00,
  `shipping_price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `title`, `description`, `code`, `image`, `sub_category_id`, `status`, `price`, `weight`, `shipping_price`, `created_at`, `updated_at`) VALUES
(36, 'Labiales / Labual Luquido ', 'Perfect Matte Lipstick', '00141-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff054c0eabf3.jpg', 2, 1, '3.50', '0.03', '0.00', '2021-01-02 10:10:57', '2021-01-02 10:10:57'),
(37, 'Barra De Labio', 'Perfect Shine Lipstick', '00144-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0552d1c710.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 10:12:45', '2021-01-02 10:12:45'),
(38, 'Barra De Labio ', 'Perfect Shine Lipstick', '00147-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0558d3104c.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 10:14:21', '2021-01-05 07:18:14'),
(39, 'Barra De Labio', 'Perfect Lipstick', '00151-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff055e6a5de8.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 10:15:50', '2021-01-05 07:18:30'),
(40, 'Barra De Labio', 'Perfect shining lipstick', '00152-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0a7c182562.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 16:05:05', '2021-01-02 16:05:05'),
(41, 'Barra De Labio', 'Perfect Lipstick', '00153-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0aacd34ecc.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 16:18:05', '2021-01-02 16:18:05'),
(42, 'Barra De Labio', 'lipstick', '00153-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0acf89450b.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 16:27:20', '2021-01-02 16:27:20'),
(43, 'Barras De Labio', 'Perfect shining lipstick', '00157-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0ada2752df.jpg', 2, 1, '3.00', '0.02', '0.00', '2021-01-02 16:30:10', '2021-01-02 16:30:27'),
(44, 'Barra De Labio', '\'Barra De Labio\' lipstick', '00162-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0af9acd8ef.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 16:38:35', '2021-01-02 16:38:35'),
(45, 'Brillos De LAbios', '24h lasting lipstick', '00202-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0b13269392.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 16:45:22', '2021-01-02 16:45:22'),
(46, 'Brillos De LAbios', 'perfect matte lipstick', '00205-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0b36428964.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 16:54:44', '2021-01-02 16:54:44'),
(47, 'Brillos De Labio', 'perfect matte lipstick', '00206-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0b4ba41e04.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 17:00:26', '2021-01-02 17:00:26'),
(48, 'Labial Liquido', 'lipstick', '00210-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0b6634d40e.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 17:07:31', '2021-01-02 17:07:31'),
(49, 'Labial Liquido', 'perfect matte', '00211-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0bc54ae198.png', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 17:32:52', '2021-01-02 17:32:52'),
(50, 'Brillos De LAbios', 'glowing lipstick', '00213', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0be2691205.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 17:40:38', '2021-01-02 17:40:38'),
(51, 'Brillos De Labios', 'shining beauty', '00216-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0bf8e5c46f.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 17:46:38', '2021-01-02 17:46:38'),
(52, 'Barra De Labio', 'perfect nude shades', '00217-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0c06f5739a.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 17:50:23', '2021-01-02 17:50:23'),
(53, 'Barra De Labio', 'red/pink shades', '00217-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0c24f75d67.jpg', 2, 1, '3.00', '0.03', '0.00', '2021-01-02 17:58:23', '2021-01-02 17:58:23'),
(54, 'Lapiz De Ojos', 'perfect line', '00302-007', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff107c693aa2.jpg', 4, 1, '2.00', '0.03', '0.00', '2021-01-02 22:54:46', '2021-01-02 22:54:46'),
(55, 'Lapiz De Ojos', 'perfect line', '00302-008', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff109b978620.jpg', 4, 1, '2.00', '0.03', '0.00', '2021-01-02 23:03:05', '2021-01-02 23:33:14'),
(56, 'Lapiz De Labios', 'perfect lips', '00302-012', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff10c1934634.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-02 23:13:13', '2021-01-02 23:33:00'),
(57, 'Lapiz De Labios', 'perfect lips', '00302-014', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff10f8f359d8.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-02 23:27:59', '2021-01-02 23:27:59'),
(58, 'Lapiz De Labios', 'perfect lips', '00302-015', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff11010054c1.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-02 23:30:08', '2021-01-02 23:30:08'),
(59, 'Lapiz De Labios', 'perfect lips', '00302-016', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff110a60c483.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-02 23:32:38', '2021-01-02 23:32:38'),
(60, 'Lapiz De Labios', 'perfect lips', '00302-017', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff111159946a.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-02 23:34:30', '2021-01-02 23:34:30'),
(61, 'Lapiz De Labios', 'perfect lips', '00302-018 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff11167ccf8a.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-02 23:35:52', '2021-01-02 23:35:52'),
(62, 'Lapiz De Labios', 'perfect lips', '00302-019', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff111d22d5c1.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-02 23:37:06', '2021-01-02 23:37:38'),
(63, 'Lapiz De Ojos ', 'perfect eyes', '00304-002', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b036b9221.jpg', 4, 1, '2.00', '0.03', '0.00', '2021-01-04 22:53:38', '2021-01-04 23:17:59'),
(64, 'Lapiz De Labio De Goma', 'perfect lips', '00311-003 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3aefda7a72.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-04 23:12:46', '2021-01-04 23:12:46'),
(65, 'Lapiz De Labio De Goma', 'perfect lips', '00311-005', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3afad9dce5.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-04 23:15:42', '2021-01-04 23:15:42'),
(66, 'Lapiz De Labio De Goma', 'perfect lips', '00311-006', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b078c9967.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-04 23:19:05', '2021-01-04 23:19:05'),
(67, 'Lapiz De Labio De Goma 2 120', 'perfect eyes', '00312-001', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b0e47f93d.jpg', 4, 1, '2.00', '0.03', '0.00', '2021-01-04 23:20:52', '2021-01-04 23:20:52'),
(68, 'Lapiz De Labio De Goma', 'perfect lips', '00312-003', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b19f1ad38.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-04 23:23:59', '2021-01-04 23:23:59'),
(69, 'Lapiz De Labio De Goma', 'yellow trendy lips', '00312-004 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b1f37dd90.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-04 23:25:24', '2021-01-04 23:25:24'),
(70, 'Lapiz De Labio De Goma', 'perfect lips', '00312-005', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b286019c5.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-04 23:27:50', '2021-01-04 23:27:50'),
(71, 'Lapiz De Labio De Goma', 'eyes and lips', '00312-006', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b2d140ade.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-04 23:29:05', '2021-01-04 23:29:05'),
(72, 'Lapiz De Ojos', 'perfect eyes', '00312-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b36a55ea8.jpg', 4, 1, '2.00', '0.03', '0.00', '2021-01-04 23:31:38', '2021-01-04 23:31:38'),
(73, 'Lapiz De Cejas', 'Eyebrow pencil', '00316-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b4a5e1cf0.jpg', 4, 1, '2.50', '0.03', '0.00', '2021-01-04 23:36:54', '2021-01-04 23:36:54'),
(74, 'Lapiz De Labios Con Sacapuntas', ' Lip Pencil With Sharpener', '00317-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b51d98506.jpg', 2, 1, '2.50', '0.03', '0.00', '2021-01-04 23:38:53', '2021-01-04 23:38:53'),
(75, 'Lapiz De Ojos Con Sacapuntas', ' Eyes Pencil With Sharpener', '00317-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b5c2162d9.jpg', 4, 1, '2.50', '0.03', '0.00', '2021-01-04 23:41:38', '2021-01-04 23:41:38'),
(76, 'Lapiz De Ojos', 'for perfect eyes', '00317-03', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b63674c10.jpg', 4, 1, '2.50', '0.03', '0.00', '2021-01-04 23:43:34', '2021-01-04 23:43:34'),
(77, 'Lapiz De Ojos', 'perfect eye line', '00318-001', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b68348fad.jpg', 4, 1, '2.00', '0.03', '0.00', '2021-01-04 23:44:51', '2021-01-04 23:44:51'),
(78, 'Lapiz De Labios Con Sacapuntas', 'Lip Pencil With Sharpener', '00320-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b71bd4906.jpg', 2, 1, '2.00', '0.03', '0.00', '2021-01-04 23:47:24', '2021-01-04 23:47:24'),
(79, 'Lapiz De Ojos', 'perfect eyes ', '00320-02', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b7a2bc968.jpg', 4, 1, '2.00', '0.03', '0.00', '2021-01-04 23:49:38', '2021-01-04 23:49:38'),
(80, 'Sombra De Ojos En Lapiz ', 'Pencil Eyeshadow', '00321-007', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b84339a84.jpg', 4, 1, '3.00', '0.03', '0.00', '2021-01-04 23:52:19', '2021-01-04 23:52:19'),
(81, 'Sombra De Ojos En Lapiz', 'Pencil Eyeshadow', '00321-015', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b88a421eb.jpg', 4, 1, '3.00', '0.03', '0.00', '2021-01-04 23:53:30', '2021-01-04 23:53:30'),
(82, 'Mascaras', 'perfect volume', '00410-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b923ca2f6.jpg', 4, 1, '4.00', '0.03', '0.00', '2021-01-04 23:56:03', '2021-01-04 23:56:03'),
(83, 'Mascara de Pestanas', 'Eyelash Longlasting Mascara', '00414-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b980c020e.jpg', 4, 1, '3.00', '0.03', '0.00', '2021-01-04 23:57:36', '2021-01-04 23:57:36'),
(84, 'Mascara de Pestanas', 'Eyelash Longlasting Volume Mascara', '00416', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b9cadf8f8.jpg', 4, 1, '3.00', '0.03', '0.00', '2021-01-04 23:58:51', '2021-01-04 23:58:51'),
(85, 'Mascara Volume Ultra Azul y Marron', 'Volume Ultra Blue and Brown Mascara', '00418-02 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3ba602b0bf.jpg', 4, 1, '4.00', '0.03', '0.00', '2021-01-05 00:01:20', '2021-01-05 00:01:20'),
(86, 'Mascaras', 'Longlasting mascara', '00422-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3baa7b688e.jpg', 4, 1, '4.00', '0.03', '0.00', '2021-01-05 00:02:31', '2021-01-05 00:02:31'),
(87, 'Mascaras', 'Long lasting mascara', '00424-01 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3baf3413d8.jpg', 4, 1, '3.00', '0.03', '0.00', '2021-01-05 00:03:47', '2021-01-05 00:03:47'),
(88, 'Mascaras', 'Long lasting mascara', '00425-01 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bb5115c66.jpg', 4, 1, '4.00', '0.03', '0.00', '2021-01-05 00:05:21', '2021-01-05 00:05:21'),
(89, 'Eyeliner Luquido', 'perfect eyeliner', '00519-01 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bbacc61df.jpg', 4, 1, '4.00', '0.03', '0.00', '2021-01-05 00:06:52', '2021-01-05 00:06:52'),
(90, 'Eyeliner Luquido', 'perfect eyeliner', '00521-01 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bbe577c03.jpg', 4, 1, '3.50', '0.03', '0.00', '2021-01-05 00:07:49', '2021-01-05 00:07:49'),
(91, 'Eyeliner Luquido', 'perfect eyeliner', '00522-01 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bc2934e05.jpg', 4, 1, '2.50', '0.03', '0.00', '2021-01-05 00:08:57', '2021-01-05 00:08:57'),
(92, 'Eyeliner Luquido', 'perfect eyeliner', '00527-01 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bc81f1707.jpg', 4, 1, '3.00', '0.03', '0.00', '2021-01-05 00:10:26', '2021-01-05 00:10:26'),
(93, 'Fondo De Maquillaje Fluido', 'Fluid Foundation', '00603-03 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bd765fd0f.jpg', 27, 1, '4.00', '30.00', '0.00', '2021-01-05 00:14:30', '2021-01-05 00:15:11'),
(94, 'Maquillaje Fluido', 'Make-up Fluid', '00604-01 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3beebbef1b.jpg', 27, 1, '5.00', '30.00', '0.00', '2021-01-05 00:20:43', '2021-01-05 00:20:43'),
(95, 'Maquillaje Fluido', 'Make-up Fluid', '00604-02 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bfdde238c.jpg', 27, 1, '5.00', '30.00', '0.00', '2021-01-05 00:24:46', '2021-01-05 00:24:46'),
(96, 'Fondo De Maquillaje Fluido', 'Makeup  Fluid ', '00611-01 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c09b53e13.jpg', 27, 1, '3.00', '30.00', '0.00', '2021-01-05 00:27:55', '2021-01-05 00:27:55'),
(97, 'Fondo De Maquillaje Fluido', 'Makeup Fluid Base', '00612-01', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c195d18dd.jpg', 27, 1, '5.00', '30.00', '0.00', '2021-01-05 00:32:06', '2021-01-05 00:32:06'),
(98, 'Sombra De Ojos', 'Eyeshadow', '00806-087 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c206d24cc.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:33:59', '2021-01-05 00:33:59'),
(99, 'Sombra De Ojos', 'Eyeshadow', '00806-089 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c265a19f9.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:35:33', '2021-01-05 00:37:44'),
(100, 'Sombra De Ojos ', 'Perfect Eyeshadow', '00806-099', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c2cb70f43.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:37:15', '2021-01-05 00:37:15'),
(101, 'Sombra De Ojos', 'Perfect Eyeshadow', '00806-108 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c3c1667f8.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:40:41', '2021-01-05 00:41:21'),
(102, 'Sombra De Ojos', 'Perfect Eyeshadow', '00806-109 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c42e3fd9f.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:43:10', '2021-01-05 00:43:10'),
(103, 'Sombra De Ojos ', 'Perfect Eyeshadow', '00806-122 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c4c587c65.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:45:41', '2021-01-05 00:45:41'),
(104, 'Sombra De Ojos ', 'Perfect Eyeshadow', '00806-74 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c527a5093.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:47:19', '2021-01-05 00:47:19'),
(105, 'Sombra De Ojos', 'Perfect eyeshadow', '00806-55 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c59cce2a8.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:49:16', '2021-01-05 00:49:16'),
(106, 'Sombra De Ojos', 'Eyeshadow', '00806-13 ', 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c5f414512.jpg', 4, 1, '3.00', '0.30', '0.00', '2021-01-05 00:50:44', '2021-01-05 00:50:44');

-- --------------------------------------------------------

--
-- Table structure for table `product_images`
--

CREATE TABLE `product_images` (
  `id` int(10) UNSIGNED NOT NULL,
  `prod_id` int(11) NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `product_images`
--

INSERT INTO `product_images` (`id`, `prod_id`, `image`, `status`, `created_at`, `updated_at`) VALUES
(23, 8, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc762140ee0d.png', 1, '2020-12-02 08:49:53', '2020-12-02 08:49:53'),
(35, 17, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8a49300d22.png', 1, '2020-12-03 07:40:51', '2020-12-03 07:40:51'),
(36, 18, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8a6902fe92.png', 1, '2020-12-03 07:49:20', '2020-12-03 07:49:20'),
(38, 20, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8a73e592e7.png', 1, '2020-12-03 07:52:14', '2020-12-03 07:52:14'),
(43, 23, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8f507088a9.png', 1, '2020-12-03 13:24:07', '2020-12-03 13:24:07'),
(46, 24, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8f76780a5f.png', 1, '2020-12-03 13:34:15', '2020-12-03 13:34:15'),
(47, 26, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc902e4da587.jpg', 1, '2020-12-03 14:23:16', '2020-12-03 14:23:16'),
(48, 27, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc9060bc037a.jpg', 1, '2020-12-03 14:36:43', '2020-12-03 14:36:43'),
(49, 28, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc90629a2300.jpg', 1, '2020-12-03 14:37:13', '2020-12-03 14:37:13'),
(52, 31, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc90834b4f28.jpg', 1, '2020-12-03 14:45:56', '2020-12-03 14:45:56'),
(56, 29, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc91cb55a11d.png', 1, '2020-12-03 16:13:25', '2020-12-03 16:13:25'),
(64, 15, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7b15f3c797.png', 1, '2020-12-04 12:45:06', '2020-12-04 12:45:06'),
(66, 19, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8a703ad31e.png', 1, '2020-12-04 12:45:25', '2020-12-04 12:45:25'),
(68, 22, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8e77a1b1f6.png', 1, '2020-12-04 12:46:14', '2020-12-04 12:46:14'),
(69, 32, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc9091d0ed3e.png', 1, '2020-12-04 12:46:27', '2020-12-04 12:46:27'),
(71, 30, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc90a3329c32.png', 1, '2020-12-04 12:47:07', '2020-12-04 12:47:07'),
(72, 25, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8f72b11346.png', 1, '2020-12-04 12:47:20', '2020-12-04 12:47:20'),
(73, 16, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7b1e9059f4.png', 1, '2020-12-04 12:48:21', '2020-12-04 12:48:21'),
(75, 9, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7aabd84198.png', 1, '2020-12-05 13:44:49', '2020-12-05 13:44:49'),
(76, 10, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7ad39c1487.png', 1, '2020-12-05 13:45:10', '2020-12-05 13:45:10'),
(77, 11, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7afa79e58e.png', 1, '2020-12-05 13:45:45', '2020-12-05 13:45:45'),
(78, 12, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7b01561ece.png', 1, '2020-12-05 13:45:57', '2020-12-05 13:45:57'),
(79, 21, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc8e636e73dc.png', 1, '2020-12-05 13:46:24', '2020-12-05 13:46:24'),
(80, 13, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7b06450ec3.png', 1, '2020-12-05 13:46:57', '2020-12-05 13:46:57'),
(81, 14, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7b0f03381a.png', 1, '2020-12-05 13:47:23', '2020-12-05 13:47:23'),
(84, 33, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc909ccf3bc2.png', 1, '2020-12-07 14:53:17', '2020-12-07 14:53:17'),
(89, 4, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5fc7aa8ff3157.png', 1, '2020-12-23 11:19:07', '2020-12-23 11:19:07'),
(90, 34, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff04e39e1be7.jpg', 1, '2021-01-02 09:43:05', '2021-01-02 09:43:05'),
(91, 35, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0534a8eac2.jpg', 1, '2021-01-02 10:04:42', '2021-01-02 10:04:42'),
(96, 40, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0a7c182562.jpg', 1, '2021-01-02 16:05:05', '2021-01-02 16:05:05'),
(104, 47, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0b4ba41e04.jpg', 1, '2021-01-02 17:00:26', '2021-01-02 17:00:26'),
(106, 48, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0b6634d40e.jpg', 1, '2021-01-02 17:07:31', '2021-01-02 17:07:31'),
(107, 49, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0bc54ae198.png', 1, '2021-01-02 17:32:52', '2021-01-02 17:32:52'),
(108, 50, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0be2691205.jpg', 1, '2021-01-02 17:40:38', '2021-01-02 17:40:38'),
(114, 54, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff107c693aa2.jpg', 1, '2021-01-02 22:57:30', '2021-01-02 22:57:30'),
(180, 107, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff42cde87acb.jpg', 1, '2021-01-05 08:15:15', '2021-01-05 08:15:15'),
(196, 108, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff42f2c00c39.jpg', 1, '2021-01-05 08:38:27', '2021-01-05 08:38:27'),
(197, 109, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff4345c91062.jpg', 1, '2021-01-05 08:41:48', '2021-01-05 08:41:48'),
(200, 110, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff4368c37a10.jpg', 1, '2021-01-05 08:51:41', '2021-01-05 08:51:41'),
(201, 106, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c5f414512.jpg', 1, '2021-01-05 08:52:16', '2021-01-05 08:52:16'),
(202, 105, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c59cce2a8.jpg', 1, '2021-01-05 08:52:37', '2021-01-05 08:52:37'),
(203, 104, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c527a5093.jpg', 1, '2021-01-05 08:52:46', '2021-01-05 08:52:46'),
(204, 103, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c4c587c65.jpg', 1, '2021-01-05 08:52:54', '2021-01-05 08:52:54'),
(205, 102, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c42e3fd9f.jpg', 1, '2021-01-05 08:53:06', '2021-01-05 08:53:06'),
(206, 101, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c3c1667f8.jpg', 1, '2021-01-05 08:53:18', '2021-01-05 08:53:18'),
(207, 100, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c2cb70f43.jpg', 1, '2021-01-05 08:53:43', '2021-01-05 08:53:43'),
(208, 99, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c265a19f9.jpg', 1, '2021-01-05 08:53:57', '2021-01-05 08:53:57'),
(209, 98, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c206d24cc.jpg', 1, '2021-01-05 08:54:27', '2021-01-05 08:54:27'),
(210, 97, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c195d18dd.jpg', 1, '2021-01-05 08:54:57', '2021-01-05 08:54:57'),
(211, 96, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3c09b53e13.jpg', 1, '2021-01-05 08:55:12', '2021-01-05 08:55:12'),
(212, 66, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b078c9967.jpg', 1, '2021-01-05 08:55:28', '2021-01-05 08:55:28'),
(213, 67, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b0e47f93d.jpg', 1, '2021-01-05 08:55:40', '2021-01-05 08:55:40'),
(214, 68, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b19f1ad38.jpg', 1, '2021-01-05 08:55:50', '2021-01-05 08:55:50'),
(215, 36, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff054c0eabf3.jpg', 1, '2021-01-05 08:56:44', '2021-01-05 08:56:44'),
(216, 37, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0552d1c710.jpg', 1, '2021-01-05 08:57:02', '2021-01-05 08:57:02'),
(217, 38, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0558d3104c.jpg', 1, '2021-01-05 08:57:17', '2021-01-05 08:57:17'),
(218, 39, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff055e6a5de8.jpg', 1, '2021-01-05 08:57:34', '2021-01-05 08:57:34'),
(219, 41, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0aacd34ecc.jpg', 1, '2021-01-05 08:57:48', '2021-01-05 08:57:48'),
(220, 42, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0acf89450b.jpg', 1, '2021-01-05 08:58:23', '2021-01-05 08:58:23'),
(221, 43, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0ada2752df.jpg', 1, '2021-01-05 08:58:54', '2021-01-05 08:58:54'),
(222, 44, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0af9acd8ef.jpg', 1, '2021-01-05 08:59:06', '2021-01-05 08:59:06'),
(223, 45, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0b13269392.jpg', 1, '2021-01-05 08:59:31', '2021-01-05 08:59:31'),
(224, 46, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0b36428964.jpg', 1, '2021-01-05 09:00:31', '2021-01-05 09:00:31'),
(225, 51, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0bf8e5c46f.jpg', 1, '2021-01-05 09:01:36', '2021-01-05 09:01:36'),
(226, 52, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0c06f5739a.jpg', 1, '2021-01-05 09:02:31', '2021-01-05 09:02:31'),
(227, 53, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff0c24f75d67.jpg', 1, '2021-01-05 09:03:15', '2021-01-05 09:03:15'),
(228, 56, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff10c1934634.jpg', 1, '2021-01-05 09:03:25', '2021-01-05 09:03:25'),
(229, 55, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff109b978620.jpg', 1, '2021-01-05 09:03:35', '2021-01-05 09:03:35'),
(230, 57, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff10f8f359d8.jpg', 1, '2021-01-05 09:04:03', '2021-01-05 09:04:03'),
(231, 58, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff11010054c1.jpg', 1, '2021-01-05 09:04:21', '2021-01-05 09:04:21'),
(232, 62, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff111d22d5c1.jpg', 1, '2021-01-05 09:04:47', '2021-01-05 09:04:47'),
(233, 61, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff11167ccf8a.jpg', 1, '2021-01-05 09:05:01', '2021-01-05 09:05:01'),
(234, 60, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff111159946a.jpg', 1, '2021-01-05 09:05:12', '2021-01-05 09:05:12'),
(235, 59, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff110a60c483.jpg', 1, '2021-01-05 09:05:44', '2021-01-05 09:05:44'),
(236, 63, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b036b9221.jpg', 1, '2021-01-05 09:06:08', '2021-01-05 09:06:08'),
(237, 64, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3aefda7a72.jpg', 1, '2021-01-05 09:06:22', '2021-01-05 09:06:22'),
(238, 65, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3afad9dce5.jpg', 1, '2021-01-05 09:06:31', '2021-01-05 09:06:31'),
(239, 69, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b1f37dd90.jpg', 1, '2021-01-05 09:07:50', '2021-01-05 09:07:50'),
(240, 70, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b286019c5.jpg', 1, '2021-01-05 09:07:58', '2021-01-05 09:07:58'),
(241, 71, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b2d140ade.jpg', 1, '2021-01-05 09:08:10', '2021-01-05 09:08:10'),
(242, 72, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b36a55ea8.jpg', 1, '2021-01-05 09:08:24', '2021-01-05 09:08:24'),
(243, 73, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b4a5e1cf0.jpg', 1, '2021-01-05 09:08:36', '2021-01-05 09:08:36'),
(244, 74, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b51d98506.jpg', 1, '2021-01-05 09:08:48', '2021-01-05 09:08:48'),
(245, 75, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b5c2162d9.jpg', 1, '2021-01-05 09:08:59', '2021-01-05 09:08:59'),
(246, 76, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b63674c10.jpg', 1, '2021-01-05 09:09:10', '2021-01-05 09:09:10'),
(247, 77, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b68348fad.jpg', 1, '2021-01-05 09:09:20', '2021-01-05 09:09:20'),
(248, 78, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b71bd4906.jpg', 1, '2021-01-05 09:09:37', '2021-01-05 09:09:37'),
(249, 79, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b7a2bc968.jpg', 1, '2021-01-05 09:09:49', '2021-01-05 09:09:49'),
(250, 80, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b84339a84.jpg', 1, '2021-01-05 09:09:59', '2021-01-05 09:09:59'),
(251, 81, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b88a421eb.jpg', 1, '2021-01-05 09:10:27', '2021-01-05 09:10:27'),
(252, 82, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b923ca2f6.jpg', 1, '2021-01-05 09:10:37', '2021-01-05 09:10:37'),
(253, 83, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b980c020e.jpg', 1, '2021-01-05 09:10:54', '2021-01-05 09:10:54'),
(254, 84, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3b9cadf8f8.jpg', 1, '2021-01-05 09:11:04', '2021-01-05 09:11:04'),
(255, 85, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3ba602b0bf.jpg', 1, '2021-01-05 09:11:19', '2021-01-05 09:11:19'),
(256, 86, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3baa7b688e.jpg', 1, '2021-01-05 09:11:43', '2021-01-05 09:11:43'),
(257, 87, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3baf3413d8.jpg', 1, '2021-01-05 09:12:15', '2021-01-05 09:12:15'),
(258, 88, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bb5115c66.jpg', 1, '2021-01-05 09:15:23', '2021-01-05 09:15:23'),
(259, 89, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bbacc61df.jpg', 1, '2021-01-05 09:15:43', '2021-01-05 09:15:43'),
(260, 90, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bbe577c03.jpg', 1, '2021-01-05 09:15:56', '2021-01-05 09:15:56'),
(261, 91, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bc2934e05.jpg', 1, '2021-01-05 09:16:08', '2021-01-05 09:16:08'),
(262, 92, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bc81f1707.jpg', 1, '2021-01-05 09:16:31', '2021-01-05 09:16:31'),
(263, 93, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bd765fd0f.jpg', 1, '2021-01-05 09:16:43', '2021-01-05 09:16:43'),
(264, 94, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3beebbef1b.jpg', 1, '2021-01-05 09:17:03', '2021-01-05 09:17:03'),
(265, 95, 'http://modapascher.mangosoft.mk/storage/images/1/product_image/5ff3bfdde238c.jpg', 1, '2021-01-05 09:17:15', '2021-01-05 09:17:15');

-- --------------------------------------------------------

--
-- Table structure for table `sections`
--

CREATE TABLE `sections` (
  `id` int(10) UNSIGNED NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `about_desc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `styling` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sections`
--

INSERT INTO `sections` (`id`, `title`, `about_desc`, `image`, `styling`, `type`, `status`, `created_at`, `updated_at`) VALUES
(41, '1. WHO WE ARE. ', 'We are SKS Shop Online Macedonia and we process your personal data as joint controllers.\nThis means that we are jointly responsible for how we process and protect your\ndata. \nThese are some terms we regularly use in this Privacy and Cookies Policy:\no When we speak about our Platform, we refer, in general, digital channels you may have used to interact with us. The main ones are:\n▪ Our Website, www.sks.mangosoft.mk and our SKS App, this includes the mobile application you installed on\nyour mobile device.\n', '', 'No Image', 'privacy', '9', '2020-11-12 11:22:07', '2020-12-03 12:56:59'),
(42, '2. WHAT WE USE YOUR DATA FOR. ', 'We will use your data(collected online), among other purposes, to manage your\nregistration as a user, to manage your purchases of products or services, to\nrespond to your queries, and, if you wish, to send you our customised\ncommunications', '', 'No Image', 'privacy', '9', '2020-11-12 11:22:07', '2020-12-03 12:56:59'),
(43, '3. WHY WE USE YOUR DATA.', 'We have legal standing to process your\ndata for various reasons. The main reason is that we need to process your data to\nperform the contract that you accept with us when you register and when you\nmake a purchase or enjoy any of our services or functionalities. We also use your\ndata for other reasons, for example, to respond to your queries or to send you\nnewsletters or help that you have asked to receive from us.', '', 'No Image', 'privacy', '9', '2020-11-12 11:22:07', '2020-12-03 12:56:59'),
(44, '4. WHO WE SHARE YOUR DATA WITH. ', 'We share your data with\nservice providers who provide us with assistance or support.', '', 'No Image', 'privacy', '9', '2020-11-12 11:22:07', '2020-12-03 12:56:59'),
(45, '5. YOUR RIGHTS.', 'You have the right to access, rectify or delete your\npersonal data. In certain cases, you are also entitled to other rights, such as, for\nexample, to object to us using your data, or to transferring your data, as explained\nin depth below.\nWe encourage you to read our full Privacy and Cookies Policy below to\nunderstand in depth the manner in which we will use your personal data and your\nrights over your data.', 'http://sks.mangosoft.mk/storage/images/1/privacy/5fad28ef13e63.jpg', 'Image Left', 'privacy', '9', '2020-11-12 11:22:07', '2020-12-03 12:56:59'),
(88, '1. INTRODUCTION ', 'This document (together with any documents herein mentioned) sets forth the terms and conditions\ngoverning the use of this website and the purchase of items through this website (hereinafter, the\n\"Terms\"). Please read through these Terms, our Cookies Policy and our Privacy Policy (together the \"Data\nProtection Policies\") prior to using this website.\nBy using this website or placing an order through it, you are consenting to be bound by these Terms and\nour Data Protection Policies. If you do not agree to all of the Terms and the Data Protection Policies, do\nnot use this website. These Terms and the Data Protection Policies may be amended. It is your\nresponsibility to regularly read through them, as the Terms and the Data Protection Policies in force at the\ntime that you use this website or at the time of the formation of the Contract (as defined below) shall be\nthe applicable ones.\nBy purchasing any product from this website, you enter into a contract with us on these terms. ', '', 'No Image', 'terms', '9', '2020-11-12 11:44:13', '2020-11-12 12:38:48'),
(89, '2. YOUR DETAILS AND YOUR VISITS TO THIS WEBSITE ', 'The information or personal details that you provide us with shall be processed pursuant to the Data\nProtection Policies. By using this website you are consenting to the processing of such information and\ndetails and you represent that the whole information or details you have provided us with are true and\naccurate. ', '', 'No Image', 'terms', '9', '2020-11-12 11:44:13', '2020-11-12 12:38:48'),
(90, '3. SERVICE AVAILABILITY', 'Items offered over this website are only available for delivery to Macedonia and Albania.', '', 'No Image', 'terms', '9', '2020-11-12 11:44:13', '2020-11-12 12:38:48'),
(91, '4. AVAILABILITY OF ITEMS ', 'All orders for items are subject to availability and in this regard, in the event of supply difficulties or\nbecause items are no longer in stock, we reserve the right to give you information about related items\nof an equal or higher quality and value which you can order. ', 'http://sks.mangosoft.mk/storage/images/1/terms/5fad2e1de2bdb.png', 'Image Left', 'terms', '9', '2020-11-12 11:44:13', '2020-11-12 12:38:48'),
(92, '5. DELIVERY ', 'If our supply of the items is delayed by an event outside our control, then we will contact you as soon as\npossible to let you know, and we will take steps to minimise the effect of the delay. Provided we do this,\nwe will not be liable for delays caused by the event, but if there is a risk of substantial delay you may\ncontact us to end the Contract and receive a refund for any items you have paid for but not received. With\nregard to the virtual gift card, we will send it on the date indicated by you when you place your order.\nPlease note however that we do not deliver on Saturdays or Sundays, except in the case of the virtual gift\ncard which will be delivered on the date indicated by you. ', '', 'No Image', 'terms', '9', '2020-11-12 11:44:13', '2020-11-12 12:38:48'),
(93, '6. REFUSAL OF ORDER ', 'We reserve the right to withdraw any items from this website at any time and/or remove or edit any\nmaterials or content on this website. Whilst we will use our reasonable endeavours to process all the\norders submitted to us, there may be exceptional circumstances which mean that we may need to refuse\nto process or accept an order after we have received it or sent you an Order Confirmation, which we\nreserve the right to do at any time. We will not be liable to you or any other third party by reason of our\nwithdrawing any item from this website, removing or editing any materials or content on this website, or\nfor refusing to process or accept an order after we have received it or sent you an Order Confirmation. \n', 'http://sks.mangosoft.mk/storage/images/1/terms/5fad2e1de9ebb.jpg', 'Image Right', 'terms', '9', '2020-11-12 11:44:13', '2020-11-12 12:38:48'),
(100, 'Our Vision', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Phasellus hendrerit. Pellentesque aliquet nibh nec urna. In nisi neque, aliquet vel, dapibus id, mattis vel, nisi. Sed pretium, ligula sollicitudin laoreet viverra, tortor libero sodales leo, eget blandit nunc tortor eu nibh.\n\n', '', 'No Image', 'about', '9', '2020-11-12 12:09:13', '2020-11-12 12:38:18'),
(101, 'Our Mission', 'Sed egestas, ante et vulputate volutpat, eros pede semper est, vitae luctus metus libero eu augue. Morbi purus libero, faucibus adipiscing, commodo quis, gravida id, est. Sed lectus.\nPraesent elementum hendrerit tortor. Sed semper lorem at felis.\n\n', '', 'No Image', 'about', '9', '2020-11-12 12:09:13', '2020-11-12 12:38:18'),
(102, 'Who We Are', ' ღ  FROM TWO SISTERS TO ANOTHER ღ \n', 'http://sks.mangosoft.mk/storage/images/1/about/5fac093fbd400.png', 'Image Right', 'about', '9', '2020-11-12 12:09:13', '2020-11-12 12:38:18'),
(103, '1. WHO WE ARE. ', 'We are SKS Shop Online Macedonia and we process your personal data as joint controllers.\nThis means that we are jointly responsible for how we process and protect your\ndata. \nThese are some terms we regularly use in this Privacy and Cookies Policy:\no When we speak about our Platform, we refer, in general, digital channels you may have used to interact with us. The main ones are:\n▪ Our Website, www.sks.mangosoft.mk and our SKS App, this includes the mobile application you installed on\nyour mobile device.\n', '', 'No Image', 'privacy', '0', '2020-11-12 12:09:53', '2020-12-03 12:56:59'),
(104, '2. WHAT WE USE YOUR DATA FOR. ', 'We will use your data(collected online), among other purposes, to manage your\nregistration as a user, to manage your purchases of products or services, to\nrespond to your queries, and, if you wish, to send you our customised\ncommunications', '', 'No Image', 'privacy', '0', '2020-11-12 12:09:53', '2020-12-03 12:56:59'),
(105, '3. WHY WE USE YOUR DATA.', 'We have legal standing to process your\ndata for various reasons. The main reason is that we need to process your data to\nperform the contract that you accept with us when you register and when you\nmake a purchase or enjoy any of our services or functionalities. We also use your\ndata for other reasons, for example, to respond to your queries or to send you\nnewsletters or help that you have asked to receive from us.', '', 'No Image', 'privacy', '0', '2020-11-12 12:09:53', '2020-12-03 12:56:59'),
(106, '4. WHO WE SHARE YOUR DATA WITH. ', 'We share your data with\nservice providers who provide us with assistance or support.', '', 'No Image', 'privacy', '0', '2020-11-12 12:09:53', '2020-12-03 12:56:59'),
(107, '5. YOUR RIGHTS.', 'You have the right to access, rectify or delete your\npersonal data. In certain cases, you are also entitled to other rights, such as, for\nexample, to object to us using your data, or to transferring your data, as explained\nin depth below.\nWe encourage you to read our full Privacy and Cookies Policy below to\nunderstand in depth the manner in which we will use your personal data and your\nrights over your data.', 'http://sks.mangosoft.mk/storage/images/1/privacy/5fad28ef13e63.jpg', 'Image Bottom', 'privacy', '0', '2020-11-12 12:09:53', '2020-12-03 12:56:59'),
(108, '1. INTRODUCTION ', 'This document (together with any documents herein mentioned) sets forth the terms and conditions\ngoverning the use of this website and the purchase of items through this website (hereinafter, the\n\"Terms\"). Please read through these Terms, our Cookies Policy and our Privacy Policy (together the \"Data\nProtection Policies\") prior to using this website.\nBy using this website or placing an order through it, you are consenting to be bound by these Terms and\nour Data Protection Policies. If you do not agree to all of the Terms and the Data Protection Policies, do\nnot use this website. These Terms and the Data Protection Policies may be amended. It is your\nresponsibility to regularly read through them, as the Terms and the Data Protection Policies in force at the\ntime that you use this website or at the time of the formation of the Contract (as defined below) shall be\nthe applicable ones.\nBy purchasing any product from this website, you enter into a contract with us on these terms. ', '', 'No Image', 'terms', '0', '2020-11-12 12:35:18', '2020-11-12 12:38:48'),
(109, '2. YOUR DETAILS AND YOUR VISITS TO THIS WEBSITE ', 'The information or personal details that you provide us with shall be processed pursuant to the Data\nProtection Policies. By using this website you are consenting to the processing of such information and\ndetails and you represent that the whole information or details you have provided us with are true and\naccurate. ', '', 'No Image', 'terms', '0', '2020-11-12 12:35:18', '2020-11-12 12:38:48'),
(110, '3. SERVICE AVAILABILITY', 'Items offered over this website are only available for delivery to Macedonia and Albania.', '', 'No Image', 'terms', '0', '2020-11-12 12:35:18', '2020-11-12 12:38:48'),
(111, '4. AVAILABILITY OF ITEMS ', 'All orders for items are subject to availability and in this regard, in the event of supply difficulties or\nbecause items are no longer in stock, we reserve the right to give you information about related items\nof an equal or higher quality and value which you can order. ', 'http://sks.mangosoft.mk/storage/images/1/terms/5fad2e1de2bdb.png', 'Image Bottom', 'terms', '0', '2020-11-12 12:35:18', '2020-11-12 12:38:48'),
(112, '5. DELIVERY ', 'If our supply of the items is delayed by an event outside our control, then we will contact you as soon as\npossible to let you know, and we will take steps to minimise the effect of the delay. Provided we do this,\nwe will not be liable for delays caused by the event, but if there is a risk of substantial delay you may\ncontact us to end the Contract and receive a refund for any items you have paid for but not received. With\nregard to the virtual gift card, we will send it on the date indicated by you when you place your order.\nPlease note however that we do not deliver on Saturdays or Sundays, except in the case of the virtual gift\ncard which will be delivered on the date indicated by you. ', '', 'No Image', 'terms', '0', '2020-11-12 12:35:18', '2020-11-12 12:38:48'),
(113, '6. REFUSAL OF ORDER ', 'We reserve the right to withdraw any items from this website at any time and/or remove or edit any\nmaterials or content on this website. Whilst we will use our reasonable endeavours to process all the\norders submitted to us, there may be exceptional circumstances which mean that we may need to refuse\nto process or accept an order after we have received it or sent you an Order Confirmation, which we\nreserve the right to do at any time. We will not be liable to you or any other third party by reason of our\nwithdrawing any item from this website, removing or editing any materials or content on this website, or\nfor refusing to process or accept an order after we have received it or sent you an Order Confirmation. \n', 'http://sks.mangosoft.mk/storage/images/1/terms/5fad2e1de9ebb.jpg', 'Image Right', 'terms', '0', '2020-11-12 12:35:18', '2020-11-12 12:38:48'),
(114, 'Our Vision', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Phasellus hendrerit. Pellentesque aliquet nibh nec urna. In nisi neque, aliquet vel, dapibus id, mattis vel, nisi. Sed pretium, ligula sollicitudin laoreet viverra, tortor libero sodales leo, eget blandit nunc tortor eu nibh.\n\n', '', 'No Image', 'about', '0', '2020-11-12 12:37:46', '2020-11-12 12:38:18'),
(115, 'Our Mission', 'Sed egestas, ante et vulputate volutpat, eros pede semper est, vitae luctus metus libero eu augue. Morbi purus libero, faucibus adipiscing, commodo quis, gravida id, est. Sed lectus.\nPraesent elementum hendrerit tortor. Sed semper lorem at felis.\n\n', '', 'No Image', 'about', '0', '2020-11-12 12:37:46', '2020-11-12 12:38:18'),
(116, 'Who We Are', ' ღ  FROM TWO SISTERS TO ANOTHER ღ \n', 'http://sks.mangosoft.mk/storage/images/1/about/5fac093fbd400.png', 'Image Bottom', 'about', '0', '2020-11-12 12:37:46', '2020-11-12 12:38:18'),
(117, 'Our Vision', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Phasellus hendrerit. Pellentesque aliquet nibh nec urna. In nisi neque, aliquet vel, dapibus id, mattis vel, nisi. Sed pretium, ligula sollicitudin laoreet viverra, tortor libero sodales leo, eget blandit nunc tortor eu nibh.\n\n', '', 'No Image', 'about', '1', '2020-11-12 12:38:18', '2020-11-12 12:38:18'),
(118, 'Our Mission', 'Sed egestas, ante et vulputate volutpat, eros pede semper est, vitae luctus metus libero eu augue. Morbi purus libero, faucibus adipiscing, commodo quis, gravida id, est. Sed lectus.\nPraesent elementum hendrerit tortor. Sed semper lorem at felis.\n\n', '', 'No Image', 'about', '1', '2020-11-12 12:38:18', '2020-11-12 12:38:18'),
(119, 'Who We Are', ' ღ  FROM TWO SISTERS TO ANOTHER ღ \n', 'http://sks.mangosoft.mk/storage/images/1/about/5fac093fbd400.png', 'Image Right', 'about', '1', '2020-11-12 12:38:18', '2020-11-12 12:38:18'),
(120, '1. INTRODUCTION ', 'This document (together with any documents herein mentioned) sets forth the terms and conditions\ngoverning the use of this website and the purchase of items through this website (hereinafter, the\n\"Terms\"). Please read through these Terms, our Cookies Policy and our Privacy Policy (together the \"Data\nProtection Policies\") prior to using this website.\nBy using this website or placing an order through it, you are consenting to be bound by these Terms and\nour Data Protection Policies. If you do not agree to all of the Terms and the Data Protection Policies, do\nnot use this website. These Terms and the Data Protection Policies may be amended. It is your\nresponsibility to regularly read through them, as the Terms and the Data Protection Policies in force at the\ntime that you use this website or at the time of the formation of the Contract (as defined below) shall be\nthe applicable ones.\nBy purchasing any product from this website, you enter into a contract with us on these terms. ', '', 'No Image', 'terms', '1', '2020-11-12 12:38:48', '2020-11-12 12:38:48'),
(121, '2. YOUR DETAILS AND YOUR VISITS TO THIS WEBSITE ', 'The information or personal details that you provide us with shall be processed pursuant to the Data\nProtection Policies. By using this website you are consenting to the processing of such information and\ndetails and you represent that the whole information or details you have provided us with are true and\naccurate. ', '', 'No Image', 'terms', '1', '2020-11-12 12:38:48', '2020-11-12 12:38:48'),
(122, '3. SERVICE AVAILABILITY', 'Items offered over this website are only available for delivery to Macedonia and Albania.', '', 'No Image', 'terms', '1', '2020-11-12 12:38:48', '2020-11-12 12:38:48'),
(123, '4. AVAILABILITY OF ITEMS ', 'All orders for items are subject to availability and in this regard, in the event of supply difficulties or\nbecause items are no longer in stock, we reserve the right to give you information about related items\nof an equal or higher quality and value which you can order. ', 'http://sks.mangosoft.mk/storage/images/1/terms/5fad2e1de2bdb.png', 'Image Left', 'terms', '1', '2020-11-12 12:38:48', '2020-11-12 12:38:48'),
(124, '5. DELIVERY ', 'If our supply of the items is delayed by an event outside our control, then we will contact you as soon as\npossible to let you know, and we will take steps to minimise the effect of the delay. Provided we do this,\nwe will not be liable for delays caused by the event, but if there is a risk of substantial delay you may\ncontact us to end the Contract and receive a refund for any items you have paid for but not received. With\nregard to the virtual gift card, we will send it on the date indicated by you when you place your order.\nPlease note however that we do not deliver on Saturdays or Sundays, except in the case of the virtual gift\ncard which will be delivered on the date indicated by you. ', '', 'No Image', 'terms', '1', '2020-11-12 12:38:48', '2020-11-12 12:38:48'),
(125, '6. REFUSAL OF ORDER ', 'We reserve the right to withdraw any items from this website at any time and/or remove or edit any\nmaterials or content on this website. Whilst we will use our reasonable endeavours to process all the\norders submitted to us, there may be exceptional circumstances which mean that we may need to refuse\nto process or accept an order after we have received it or sent you an Order Confirmation, which we\nreserve the right to do at any time. We will not be liable to you or any other third party by reason of our\nwithdrawing any item from this website, removing or editing any materials or content on this website, or\nfor refusing to process or accept an order after we have received it or sent you an Order Confirmation. \n', 'http://sks.mangosoft.mk/storage/images/1/terms/5fad2e1de9ebb.jpg', 'Image Right', 'terms', '1', '2020-11-12 12:38:48', '2020-11-12 12:38:48'),
(126, '1. WHO WE ARE. ', 'We are Moda Pas Cher and we process your personal data as joint controllers.\nThis means that we are jointly responsible for how we process and protect your\ndata. \nThese are some terms we regularly use in this Privacy and Cookies Policy:\no When we speak about our Platform, we refer, in general, digital channels you may have used to interact with us. The main ones are:\n▪ includes the mobile application you installed on your mobile device.\n', '', 'No Image', 'privacy', '1', '2020-12-03 12:56:59', '2020-12-03 12:56:59'),
(127, '2. WHAT WE USE YOUR DATA FOR. ', 'We will use your data(collected online), among other purposes, to manage your\nregistration as a user, to manage your purchases of products or services, to\nrespond to your queries, and, if you wish, to send you our customised\ncommunications', '', 'No Image', 'privacy', '1', '2020-12-03 12:56:59', '2020-12-03 12:56:59'),
(128, '3. WHY WE USE YOUR DATA.', 'We have legal standing to process your\ndata for various reasons. The main reason is that we need to process your data to\nperform the contract that you accept with us when you register and when you\nmake a purchase or enjoy any of our services or functionalities. We also use your\ndata for other reasons, for example, to respond to your queries or to send you\nnewsletters or help that you have asked to receive from us.', '', 'No Image', 'privacy', '1', '2020-12-03 12:56:59', '2020-12-03 12:56:59'),
(129, '4. WHO WE SHARE YOUR DATA WITH. ', 'We share your data with\nservice providers who provide us with assistance or support.', '', 'No Image', 'privacy', '1', '2020-12-03 12:56:59', '2020-12-03 12:56:59'),
(130, '5. YOUR RIGHTS.', 'You have the right to access, rectify or delete your\npersonal data. In certain cases, you are also entitled to other rights, such as, for\nexample, to object to us using your data, or to transferring your data, as explained\nin depth below.\nWe encourage you to read our full Privacy and Cookies Policy below to\nunderstand in depth the manner in which we will use your personal data and your\nrights over your data.', '', 'No Image', 'privacy', '1', '2020-12-03 12:56:59', '2020-12-03 12:56:59');

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shipping_prices`
--

CREATE TABLE `shipping_prices` (
  `id` int(10) UNSIGNED NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `from` decimal(10,2) NOT NULL,
  `to` decimal(10,2) NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'weight',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `shipping_prices`
--

INSERT INTO `shipping_prices` (`id`, `price`, `from`, `to`, `type`, `created_at`, `updated_at`) VALUES
(10, '4.50', '0.00', '250.00', 'weight', '2020-12-05 19:03:55', '2020-12-05 19:03:55'),
(11, '6.00', '251.00', '500.00', 'weight', '2020-12-05 19:03:55', '2020-12-05 19:03:55');

-- --------------------------------------------------------

--
-- Table structure for table `sizes`
--

CREATE TABLE `sizes` (
  `id` int(10) UNSIGNED NOT NULL,
  `size` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stock` int(11) NOT NULL,
  `prod_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sizes`
--

INSERT INTO `sizes` (`id`, `size`, `stock`, `prod_id`, `created_at`, `updated_at`) VALUES
(30, 'One Size', 240, 36, '2021-01-02 10:10:57', '2021-01-02 10:10:57'),
(31, 'One Size', 96, 37, '2021-01-02 10:12:45', '2021-01-02 10:12:45'),
(32, 'One Size', 240, 38, '2021-01-02 10:14:21', '2021-01-02 10:14:21'),
(33, 'One Size', 240, 39, '2021-01-02 10:15:50', '2021-01-02 10:15:50'),
(34, 'One Size', 240, 40, '2021-01-02 16:05:05', '2021-01-02 16:05:05'),
(35, 'One Size', 240, 41, '2021-01-02 16:18:05', '2021-01-02 16:18:05'),
(36, 'One Size', 240, 42, '2021-01-02 16:27:20', '2021-01-02 16:27:20'),
(37, 'One Size', 240, 43, '2021-01-02 16:30:10', '2021-01-02 16:30:10'),
(38, 'One Size', 240, 44, '2021-01-02 16:38:35', '2021-01-02 16:38:35'),
(39, 'One Size', 240, 45, '2021-01-02 16:45:22', '2021-01-02 16:45:22'),
(40, 'One Size', 240, 46, '2021-01-02 16:54:44', '2021-01-02 17:03:59'),
(41, 'One Size', 120, 47, '2021-01-02 17:00:26', '2021-01-02 17:00:26'),
(42, 'One Size', 360, 48, '2021-01-02 17:07:31', '2021-01-02 17:07:31'),
(43, 'One Size', 240, 49, '2021-01-02 17:32:52', '2021-01-02 17:32:52'),
(44, 'One Size', 240, 50, '2021-01-02 17:40:38', '2021-01-02 17:40:38'),
(45, 'One Size', 240, 51, '2021-01-02 17:46:38', '2021-01-02 17:46:38'),
(46, 'One Size', 240, 52, '2021-01-02 17:50:23', '2021-01-02 17:50:23'),
(47, 'One Size', 240, 53, '2021-01-02 17:58:23', '2021-01-02 17:58:23'),
(48, 'One Size', 120, 54, '2021-01-02 22:54:46', '2021-01-02 22:57:30'),
(49, 'One Size', 120, 55, '2021-01-02 23:03:05', '2021-01-02 23:03:05'),
(50, 'One Size', 120, 56, '2021-01-02 23:13:13', '2021-01-02 23:13:13'),
(51, 'One Size', 120, 57, '2021-01-02 23:27:59', '2021-01-02 23:27:59'),
(52, 'One Size', 120, 58, '2021-01-02 23:30:08', '2021-01-02 23:30:08'),
(53, 'One Size', 120, 59, '2021-01-02 23:32:38', '2021-01-02 23:32:38'),
(54, 'One Size', 0, 60, '2021-01-02 23:34:30', '2021-01-02 23:34:30'),
(55, 'One Size', 120, 61, '2021-01-02 23:35:52', '2021-01-02 23:35:52'),
(56, 'One Size', 120, 62, '2021-01-02 23:37:06', '2021-01-05 09:04:47'),
(57, 'One Size', 120, 63, '2021-01-04 22:53:38', '2021-01-04 22:53:38'),
(58, 'One Size', 120, 64, '2021-01-04 23:12:46', '2021-01-04 23:12:46'),
(59, 'One Size', 120, 65, '2021-01-04 23:15:42', '2021-01-04 23:15:42'),
(60, 'One Size', 120, 66, '2021-01-04 23:19:05', '2021-01-04 23:19:05'),
(61, 'One Size', 120, 67, '2021-01-04 23:20:52', '2021-01-04 23:20:52'),
(62, 'One Size', 120, 68, '2021-01-04 23:23:59', '2021-01-04 23:23:59'),
(63, 'One Size', 120, 69, '2021-01-04 23:25:24', '2021-01-04 23:25:24'),
(64, 'One Size', 120, 70, '2021-01-04 23:27:50', '2021-01-04 23:27:50'),
(65, 'One Size', 120, 71, '2021-01-04 23:29:05', '2021-01-04 23:29:05'),
(66, 'One Size', 480, 72, '2021-01-04 23:31:38', '2021-01-04 23:31:38'),
(67, 'One Size', 360, 73, '2021-01-04 23:36:54', '2021-01-04 23:36:54'),
(68, 'One Size', 360, 74, '2021-01-04 23:38:53', '2021-01-04 23:38:53'),
(69, 'One Size', 360, 75, '2021-01-04 23:41:38', '2021-01-04 23:41:38'),
(70, 'One Size', 360, 76, '2021-01-04 23:43:34', '2021-01-04 23:43:34'),
(71, 'One Size', 120, 77, '2021-01-04 23:44:51', '2021-01-04 23:44:51'),
(72, 'One Size', 480, 78, '2021-01-04 23:47:24', '2021-01-04 23:47:24'),
(73, 'One Size', 480, 79, '2021-01-04 23:49:38', '2021-01-04 23:49:38'),
(74, 'One Size', 120, 80, '2021-01-04 23:52:19', '2021-01-04 23:52:19'),
(75, 'One Size', 120, 81, '2021-01-04 23:53:30', '2021-01-04 23:53:30'),
(76, 'One Size', 240, 82, '2021-01-04 23:56:03', '2021-01-04 23:56:03'),
(77, 'One Size', 240, 83, '2021-01-04 23:57:36', '2021-01-04 23:57:36'),
(78, 'One Size', 240, 84, '2021-01-04 23:58:51', '2021-01-04 23:58:51'),
(79, 'One Size', 120, 85, '2021-01-05 00:01:20', '2021-01-05 00:01:20'),
(80, 'One Size', 240, 86, '2021-01-05 00:02:31', '2021-01-05 00:02:31'),
(81, 'One Size', 240, 87, '2021-01-05 00:03:47', '2021-01-05 00:03:47'),
(82, 'One Size', 240, 88, '2021-01-05 00:05:21', '2021-01-05 00:05:21'),
(83, 'One Size', 240, 89, '2021-01-05 00:06:52', '2021-01-05 00:06:52'),
(84, 'One Size', 240, 90, '2021-01-05 00:07:49', '2021-01-05 00:07:49'),
(85, 'One Size', 240, 91, '2021-01-05 00:08:57', '2021-01-05 00:08:57'),
(86, 'One Size', 240, 92, '2021-01-05 00:10:26', '2021-01-05 00:10:26'),
(87, 'One Size', 240, 93, '2021-01-05 00:14:30', '2021-01-05 00:14:30'),
(88, 'One Size', 120, 94, '2021-01-05 00:20:43', '2021-01-05 00:20:43'),
(89, 'One Size', 120, 95, '2021-01-05 00:24:46', '2021-01-05 00:24:46'),
(90, 'One Size', 240, 96, '2021-01-05 00:27:55', '2021-01-05 00:27:55'),
(91, 'One Size', 120, 97, '2021-01-05 00:32:06', '2021-01-05 00:32:06'),
(92, 'One Size', 30, 98, '2021-01-05 00:33:59', '2021-01-05 00:33:59'),
(93, 'One Size', 60, 99, '2021-01-05 00:35:33', '2021-01-05 00:35:33'),
(94, 'One Size', 24, 100, '2021-01-05 00:37:15', '2021-01-05 00:37:15'),
(95, 'One Size', 54, 101, '2021-01-05 00:40:41', '2021-01-05 00:40:41'),
(96, 'One Size', 12, 102, '2021-01-05 00:43:10', '2021-01-05 00:43:10'),
(97, 'One Size', 60, 103, '2021-01-05 00:45:41', '2021-01-05 00:45:41'),
(98, 'One Size', 0, 104, '2021-01-05 00:47:19', '2021-01-05 00:47:19'),
(99, 'One Size', 0, 105, '2021-01-05 00:49:16', '2021-01-05 00:49:16'),
(100, 'One Size', 0, 106, '2021-01-05 00:50:44', '2021-01-05 00:50:44');

-- --------------------------------------------------------

--
-- Table structure for table `sub_categories`
--

CREATE TABLE `sub_categories` (
  `id` int(10) UNSIGNED NOT NULL,
  `cat_id` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sub_categories`
--

INSERT INTO `sub_categories` (`id`, `cat_id`, `title`, `status`, `created_at`, `updated_at`) VALUES
(1, 1, 'Ongles', 1, '2020-12-01 12:19:35', '2020-12-01 12:19:35'),
(2, 1, 'Lèvres', 1, '2020-12-01 12:21:06', '2020-12-01 12:21:06'),
(3, 2, 'Mode', 1, '2020-12-04 13:07:56', '2020-12-06 14:52:38'),
(4, 1, 'Yeux', 1, '2020-12-06 14:49:49', '2020-12-06 14:50:01'),
(5, 1, 'Teint', 1, '2020-12-06 14:50:28', '2020-12-06 14:50:28'),
(6, 1, 'Accessoires', 1, '2020-12-06 14:50:57', '2020-12-06 14:50:57'),
(7, 3, 'Visage', 1, '2020-12-06 14:51:28', '2020-12-06 14:51:28'),
(8, 3, 'Corps', 1, '2020-12-06 14:51:45', '2020-12-06 14:51:45'),
(9, 3, 'Cheveux', 1, '2020-12-06 14:51:58', '2020-12-06 14:51:58'),
(10, 2, 'Cheveux', 1, '2020-12-06 14:52:51', '2020-12-06 14:52:51'),
(11, 4, 'Galet parfumé', 1, '2020-12-06 14:53:11', '2020-12-06 14:53:11'),
(12, 4, 'Tablette parfumée', 1, '2020-12-06 14:53:49', '2020-12-06 14:53:49'),
(13, 4, 'Suspension penderie', 1, '2020-12-06 14:54:06', '2020-12-06 14:54:06'),
(14, 4, 'Savon naturel parfumé', 1, '2020-12-06 14:54:23', '2020-12-06 14:54:23'),
(15, 4, 'Brûleur', 1, '2020-12-06 14:54:43', '2020-12-06 14:54:43'),
(16, 5, 'Collier', 1, '2020-12-06 14:58:23', '2020-12-06 14:58:23'),
(17, 5, 'Bracelet', 1, '2020-12-06 14:58:34', '2020-12-06 14:58:34'),
(18, 5, 'Bague', 1, '2020-12-06 14:58:51', '2020-12-06 14:58:51'),
(19, 5, 'Montre', 1, '2020-12-06 14:59:03', '2020-12-06 14:59:03'),
(20, 5, 'Bijou fantaisie', 1, '2020-12-06 14:59:34', '2020-12-06 14:59:34'),
(21, 6, 'Hauts', 0, '2020-12-06 15:01:19', '2020-12-06 15:01:20'),
(22, 6, 'Pantalons', 0, '2020-12-06 15:01:44', '2020-12-06 15:01:50'),
(23, 6, 'Jeans', 1, '2020-12-06 15:02:13', '2020-12-06 15:02:13'),
(24, 6, 'Shorts', 1, '2020-12-06 15:02:28', '2020-12-06 15:02:28'),
(25, 6, 'Robes', 1, '2020-12-06 15:02:47', '2020-12-06 15:02:47'),
(27, 1, 'Visage', 1, '2021-01-05 00:12:39', '2021-01-05 00:12:39');

-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `main_id` int(11) NOT NULL,
  `article_id` int(11) NOT NULL,
  `en` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `al` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mk` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

CREATE TABLE `transactions` (
  `id` int(10) UNSIGNED NOT NULL,
  `trans_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trans_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `transactions`
--

INSERT INTO `transactions` (`id`, `trans_id`, `trans_data`, `created_at`, `updated_at`) VALUES
(1, 'ch_1HuaiIGcwIzl8WLrYxwY7dhG', '{\"id\":\"ch_1HuaiIGcwIzl8WLrYxwY7dhG\",\"object\":\"charge\",\"amount\":1800,\"amount_captured\":1800,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1HuaiIGcwIzl8WLrRnKZJXea\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607074590,\"currency\":\"eur\",\"customer\":\"cus_IVbw1wL8AcM2wN\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":58,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1HuaiHGcwIzl8WLr8Buyxe4e\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":9,\"exp_year\":2022,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1HuaiIGcwIzl8WLrYxwY7dhG\\/rcpt_IVbwhj3nthZZ4iPzSfx9akiI3gD9sL5\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1HuaiIGcwIzl8WLrYxwY7dhG\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1HuaiHGcwIzl8WLr8Buyxe4e\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IVbw1wL8AcM2wN\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":9,\"exp_year\":2022,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-04 08:36:31', '2020-12-04 08:36:31'),
(2, 'ch_1HubOVGcwIzl8WLrTWpaQ8o6', '{\"id\":\"ch_1HubOVGcwIzl8WLrTWpaQ8o6\",\"object\":\"charge\",\"amount\":1800,\"amount_captured\":1800,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1HubOVGcwIzl8WLrlQJMj9LT\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607077207,\"currency\":\"eur\",\"customer\":\"cus_IVcdGfqh2TgvjB\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":38,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1HubOTGcwIzl8WLrYBMNUElq\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":12,\"exp_year\":2022,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1HubOVGcwIzl8WLrTWpaQ8o6\\/rcpt_IVcd9vfseELlVaZd7BOJwIDY0ZybfYx\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1HubOVGcwIzl8WLrTWpaQ8o6\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1HubOTGcwIzl8WLrYBMNUElq\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IVcdGfqh2TgvjB\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":12,\"exp_year\":2022,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-04 09:20:08', '2020-12-04 09:20:08'),
(3, 'ch_1Hv2mdGcwIzl8WLreajd6uOo', '{\"id\":\"ch_1Hv2mdGcwIzl8WLreajd6uOo\",\"object\":\"charge\",\"amount\":700,\"amount_captured\":700,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1Hv2mdGcwIzl8WLrjemGeE0O\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607182491,\"currency\":\"eur\",\"customer\":\"cus_IW4wbYUPFJz6Ru\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":6,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1Hv2mcGcwIzl8WLrwhtdYJWp\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":12,\"exp_year\":2022,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1Hv2mdGcwIzl8WLreajd6uOo\\/rcpt_IW4wwfGtoiwjMHA6odEYSlXwFRjmvDP\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1Hv2mdGcwIzl8WLreajd6uOo\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1Hv2mcGcwIzl8WLrwhtdYJWp\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IW4wbYUPFJz6Ru\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":12,\"exp_year\":2022,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-05 14:34:53', '2020-12-05 14:34:53'),
(4, 'ch_1Hv2sHGcwIzl8WLrAlabVYpY', '{\"id\":\"ch_1Hv2sHGcwIzl8WLrAlabVYpY\",\"object\":\"charge\",\"amount\":700,\"amount_captured\":700,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1Hv2sHGcwIzl8WLrXweuOOwc\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607182841,\"currency\":\"eur\",\"customer\":\"cus_IW52QXvjNba2A9\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":46,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1Hv2sGGcwIzl8WLr58aJQqOt\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":12,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1Hv2sHGcwIzl8WLrAlabVYpY\\/rcpt_IW52FHAiJTR0CLv7O7eqMV94ibe5O1L\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1Hv2sHGcwIzl8WLrAlabVYpY\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1Hv2sGGcwIzl8WLr58aJQqOt\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IW52QXvjNba2A9\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":12,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-05 14:40:43', '2020-12-05 14:40:43'),
(5, 'ch_1Hv6NMGcwIzl8WLrPn7jNmp5', '{\"id\":\"ch_1Hv6NMGcwIzl8WLrPn7jNmp5\",\"object\":\"charge\",\"amount\":700,\"amount_captured\":700,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1Hv6NMGcwIzl8WLremzHTYXh\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607196300,\"currency\":\"eur\",\"customer\":\"cus_IW8ebf07NTArZx\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":13,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1Hv6NLGcwIzl8WLrTB20OTR4\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1Hv6NMGcwIzl8WLrPn7jNmp5\\/rcpt_IW8eqcWBw6PMGIoJ2dgPpQCu3nJJSRP\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1Hv6NMGcwIzl8WLrPn7jNmp5\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1Hv6NLGcwIzl8WLrTB20OTR4\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IW8ebf07NTArZx\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-05 18:25:02', '2020-12-05 18:25:02'),
(6, 'ch_1Hv6cOGcwIzl8WLrxnnUET89', '{\"id\":\"ch_1Hv6cOGcwIzl8WLrxnnUET89\",\"object\":\"charge\",\"amount\":700,\"amount_captured\":700,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1Hv6cPGcwIzl8WLrUP9RFd8b\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607197232,\"currency\":\"eur\",\"customer\":\"cus_IW8ugR7C4P02zV\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":43,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1Hv6cNGcwIzl8WLrXXwvxEhV\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1Hv6cOGcwIzl8WLrxnnUET89\\/rcpt_IW8ud5U8gn603dPeHAgi6bpVkYiGIC1\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1Hv6cOGcwIzl8WLrxnnUET89\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1Hv6cNGcwIzl8WLrXXwvxEhV\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IW8ugR7C4P02zV\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-05 18:40:35', '2020-12-05 18:40:35'),
(7, 'ch_1Hv6e5GcwIzl8WLrrtKXSlkn', '{\"id\":\"ch_1Hv6e5GcwIzl8WLrrtKXSlkn\",\"object\":\"charge\",\"amount\":700,\"amount_captured\":700,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1Hv6e5GcwIzl8WLrC63cqrTR\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607197337,\"currency\":\"eur\",\"customer\":\"cus_IW8vlhWww33zsx\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":30,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1Hv6e4GcwIzl8WLrRfE5LZk5\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1Hv6e5GcwIzl8WLrrtKXSlkn\\/rcpt_IW8voyyGUMHHbwnZVL5qL7NJ6DpgV31\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1Hv6e5GcwIzl8WLrrtKXSlkn\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1Hv6e4GcwIzl8WLrRfE5LZk5\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IW8vlhWww33zsx\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-05 18:42:19', '2020-12-05 18:42:19'),
(8, 'ch_1HvrOuGcwIzl8WLr70vYpGia', '{\"id\":\"ch_1HvrOuGcwIzl8WLr70vYpGia\",\"object\":\"charge\",\"amount\":700,\"amount_captured\":700,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1HvrOuGcwIzl8WLrjV8YF82s\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607377064,\"currency\":\"eur\",\"customer\":\"cus_IWvForaVN7Lkeo\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":29,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1HvrOsGcwIzl8WLrmBXZh4x6\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1HvrOuGcwIzl8WLr70vYpGia\\/rcpt_IWvFy4VeiUxnjh7rXfWHcMhQWnfQHxj\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1HvrOuGcwIzl8WLr70vYpGia\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1HvrOsGcwIzl8WLrmBXZh4x6\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IWvForaVN7Lkeo\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-07 20:37:45', '2020-12-07 20:37:45'),
(9, 'ch_1HvzkxGcwIzl8WLrtvha41zm', '{\"id\":\"ch_1HvzkxGcwIzl8WLrtvha41zm\",\"object\":\"charge\",\"amount\":700,\"amount_captured\":700,\"amount_refunded\":0,\"application\":null,\"application_fee\":null,\"application_fee_amount\":null,\"balance_transaction\":\"txn_1HvzkyGcwIzl8WLrja34dFVv\",\"billing_details\":{\"address\":{\"city\":null,\"country\":null,\"line1\":null,\"line2\":null,\"postal_code\":null,\"state\":null},\"email\":null,\"name\":null,\"phone\":null},\"calculated_statement_descriptor\":\"Stripe\",\"captured\":true,\"created\":1607409183,\"currency\":\"eur\",\"customer\":\"cus_IX3sIbKSHRHoRe\",\"description\":null,\"destination\":null,\"dispute\":null,\"disputed\":false,\"failure_code\":null,\"failure_message\":null,\"fraud_details\":[],\"invoice\":null,\"livemode\":false,\"metadata\":[],\"on_behalf_of\":null,\"order\":null,\"outcome\":{\"network_status\":\"approved_by_network\",\"reason\":null,\"risk_level\":\"normal\",\"risk_score\":31,\"seller_message\":\"Payment complete.\",\"type\":\"authorized\"},\"paid\":true,\"payment_intent\":null,\"payment_method\":\"card_1HvzkwGcwIzl8WLrYGpeAbGR\",\"payment_method_details\":{\"card\":{\"brand\":\"visa\",\"checks\":{\"address_line1_check\":null,\"address_postal_code_check\":null,\"cvc_check\":\"pass\"},\"country\":\"US\",\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"installments\":null,\"last4\":\"4242\",\"network\":\"visa\",\"three_d_secure\":null,\"wallet\":null},\"type\":\"card\"},\"receipt_email\":null,\"receipt_number\":null,\"receipt_url\":\"https:\\/\\/pay.stripe.com\\/receipts\\/acct_1GiHQqGcwIzl8WLr\\/ch_1HvzkxGcwIzl8WLrtvha41zm\\/rcpt_IX3s07RrLN2rFJjZJE6tYnaf73P5ewM\",\"refunded\":false,\"refunds\":{\"object\":\"list\",\"data\":[],\"has_more\":false,\"total_count\":0,\"url\":\"\\/v1\\/charges\\/ch_1HvzkxGcwIzl8WLrtvha41zm\\/refunds\"},\"review\":null,\"shipping\":null,\"source\":{\"id\":\"card_1HvzkwGcwIzl8WLrYGpeAbGR\",\"object\":\"card\",\"address_city\":null,\"address_country\":null,\"address_line1\":null,\"address_line1_check\":null,\"address_line2\":null,\"address_state\":null,\"address_zip\":null,\"address_zip_check\":null,\"brand\":\"Visa\",\"country\":\"US\",\"customer\":\"cus_IX3sIbKSHRHoRe\",\"cvc_check\":\"pass\",\"dynamic_last4\":null,\"exp_month\":1,\"exp_year\":2023,\"fingerprint\":\"OxjgglvgM00Iu9Kl\",\"funding\":\"credit\",\"last4\":\"4242\",\"metadata\":[],\"name\":null,\"tokenization_method\":null},\"source_transfer\":null,\"statement_descriptor\":null,\"statement_descriptor_suffix\":null,\"status\":\"succeeded\",\"transfer_data\":null,\"transfer_group\":null}', '2020-12-08 05:33:05', '2020-12-08 05:33:05');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `two_factor_secret` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `two_factor_recovery_codes` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `city`, `address`, `zip`, `tel`, `password`, `two_factor_secret`, `two_factor_recovery_codes`, `token`, `device_id`, `status`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 'Shop Admin', 'test@admin.com', NULL, NULL, NULL, NULL, '$2y$10$sB6gIy5W9mj9y0JLMPwbh.X4uogAOiMCNtURZOgaY6QQWuxWmql8C', NULL, NULL, '$2y$10$/ciBjeKzb8xI/yWvo4edu.aPIiL3aPKLSlLOvu/zZPlCe.V5zhkOG', NULL, 2, NULL, '2020-12-04 09:00:44', '2021-01-05 08:18:12'),
(6, 'Aida Dzafer', 'aida@gmail.com', 'Ohriddddd', 'NPR', '6000', '5674843299', '$2y$10$.61VYLNnzvJUgfG5uJDHM.62V4fFOFDOSblWkoij3Z5F9nTzDH3Xq', NULL, NULL, '$2y$10$SzCFpatvL41ugH15pkKt3eSFWWqwJYupSX9NLbxgBALJLlX0VFH1m', 'd4039c23-0ad7-456c-96a6-9461f27eadd3', 1, NULL, '2020-12-04 09:17:44', '2020-12-24 07:31:40'),
(7, 'Test Testing', 'test@test.com', 'Struga', 'Labunista', '6336', '8383838192', '$2y$10$4Mb8SNYUdkdpB9euF9IMEeLWUcnT6ABjtAN/G804xmPIsFkS6EjQi', NULL, NULL, NULL, NULL, 1, NULL, '2020-12-04 15:03:52', '2020-12-30 15:39:07'),
(8, 'Senol Hasgeyer', 'senolhasgeyer@gmail.com', 'Asnieres sur oise', '3 alleee des templiers', '95270', '0650914464', '$2y$10$7Kn3Y0k6hBD8RZycRov0nudWnQJtSzeheVJfPuwUtWI8vnWAnlj.6', NULL, NULL, '$2y$10$y4ATTCZHpgaJQcnrd8ZGIORFGwcbTSQX0ebeMsfS54g3Z60RVMTHa', '073290b2-71a0-4527-a6a1-54bf675ad74f', 1, NULL, '2020-12-05 17:47:36', '2020-12-21 10:43:04'),
(9, 'milot kolomona', 'milot.hoxha7@gmail.com', 'nfcj', 'nfkfj', '474757', '356555', '$2y$10$lDp8jdRUFhS03b9fA99nq.FFl6jOmpQk/4xn8fAD0bmtzTIRp7lJy', NULL, NULL, '$2y$10$OX01qtZqbd2cyNPYNn7hAuSEENs/pnUS4FlBz09SripUogD8yZ0au', NULL, 1, NULL, '2020-12-05 17:57:18', '2020-12-05 17:57:19');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `articles`
--
ALTER TABLE `articles`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `banners`
--
ALTER TABLE `banners`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `category_sources`
--
ALTER TABLE `category_sources`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `colors`
--
ALTER TABLE `colors`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `coupons`
--
ALTER TABLE `coupons`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `deals`
--
ALTER TABLE `deals`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `galleries`
--
ALTER TABLE `galleries`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `guest_users`
--
ALTER TABLE `guest_users`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ordered_items`
--
ALTER TABLE `ordered_items`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `page_configs`
--
ALTER TABLE `page_configs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `password_resets`
--
ALTER TABLE `password_resets`
  ADD KEY `password_resets_email_index` (`email`);

--
-- Indexes for table `payment_processeds`
--
ALTER TABLE `payment_processeds`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `product_images`
--
ALTER TABLE `product_images`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sections`
--
ALTER TABLE `sections`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `shipping_prices`
--
ALTER TABLE `shipping_prices`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sizes`
--
ALTER TABLE `sizes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sub_categories`
--
ALTER TABLE `sub_categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tags`
--
ALTER TABLE `tags`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `transactions`
--
ALTER TABLE `transactions`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `articles`
--
ALTER TABLE `articles`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `banners`
--
ALTER TABLE `banners`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `category_sources`
--
ALTER TABLE `category_sources`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `colors`
--
ALTER TABLE `colors`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=428;

--
-- AUTO_INCREMENT for table `coupons`
--
ALTER TABLE `coupons`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `deals`
--
ALTER TABLE `deals`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `galleries`
--
ALTER TABLE `galleries`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `guest_users`
--
ALTER TABLE `guest_users`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT for table `ordered_items`
--
ALTER TABLE `ordered_items`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- AUTO_INCREMENT for table `page_configs`
--
ALTER TABLE `page_configs`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `payment_processeds`
--
ALTER TABLE `payment_processeds`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=29;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=111;

--
-- AUTO_INCREMENT for table `product_images`
--
ALTER TABLE `product_images`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=266;

--
-- AUTO_INCREMENT for table `sections`
--
ALTER TABLE `sections`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=131;

--
-- AUTO_INCREMENT for table `shipping_prices`
--
ALTER TABLE `shipping_prices`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `sizes`
--
ALTER TABLE `sizes`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=105;

--
-- AUTO_INCREMENT for table `sub_categories`
--
ALTER TABLE `sub_categories`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT for table `tags`
--
ALTER TABLE `tags`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `transactions`
--
ALTER TABLE `transactions`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;
COMMIT;
