<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id');
            $table->string('stripe_id');
            $table->string('coupon');
            $table->string('email');
            $table->string('name');
            $table->string('address');
            $table->string('city');
            $table->string('zip');
            $table->string('tel');
            $table->string('delivery');
            $table->string('user_ip_address');
            $table->decimal('sum', 10,2)->default(0);
            $table->decimal('discount', 10,2)->default(0);
            $table->integer('status')->default(1);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
