<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class Products extends Model
{
    public function sizes() {
        return $this->hasMany(Sizes::class, 'prod_id')->with('colors');
    }
    public function scopeFiltsize(Builder $query, $size) {
        return $query->whereHas('sizes', function ($q) use ($size) {
            $q->where('size', $size[0]);
            foreach ($size as $s) {
                if ($s != $size[0])
                    $q->orWhere('size', $s);
            }
            return $q;
        });
    }
    public function scopeFiltswcolors(Builder $query, $size, $color) {
        return $query->whereHas('sizes', function ($q) use ($size, $color) {
            $q->where('size', $size[0]);
            foreach ($size as $s) {
                if ($s != $size[0])
                    $q->orWhere('size', $s);
            }
            return $q->filtcolors($color);
        });
    }
    public function scopeFiltercolor(Builder $query, $color) {
        return $query->whereHas('sizes', function ($q) use($color) {
           return $q->filtcolors($color);
        });
    }
    public function sub_cat() {
        return $this->belongsTo(SubCategory::class, 'sub_category_id')->with('category');
    }
    public function scopeFiltercat(Builder $query, $cat_id) {
        return $query->whereHas('sub_cat', function ($q) use ($cat_id) {
            return $q->where('cat_id', $cat_id);
        });
    }
    public function images() {
        return $this->hasMany(ProductImage::class, 'prod_id')->where('status', 1);
    }
}
