<?php

namespace App\Http\Controllers\ApiV1;

use App\Http\Controllers\ApiV1\BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class UserController extends BaseController
{
    public function getUser() {
        $user = $this->checkToken(request('token'));
        return $this->returnData(true, 'user', $user);
    }
    public function updateUser() {
        $user = $this->checkToken(request('token'));

        $data = \request()->all();
        $email_verify = '';
        if( $user -> email != \request('email') ) {
            $email_verify= 'unique:users';
        }

        $validate = Validator::make($data,[
            'email'      =>  [ 'required', 'email', $email_verify],
            'name'       =>  [ 'required', 'string'],
            'city'       =>  [ 'required', 'string'],
            'address'    =>  [ 'required', 'string'],
            'zip'        =>  [ 'required', 'string'],
            'phone'        =>  [ 'required', 'numeric'],
        ]);
        if($validate->errors()->messages() != null){
            return $this->returnData(false, $validate->errors()->first(), null);
        }

        $user -> name       = $data['name'];
        $user -> email      = $data['email'];
        $user -> city       = $data['city'];
        $user -> address    = $data['address'];
        $user -> zip        = $data['zip'];
        $user -> tel        = $data['phone'];

        $user -> save();

        return $this->returnData(true, 'Your data has been successfully changed.', $user);
    }
    public function changePsw() {
        $user = $this->checkToken(\request('token'));
        $data = \request()->all();

        $validate = Validator::make($data, [
            'current_password' => 'required',
            'password' => 'required|confirmed',
//            'confirm_password' => ['required']
        ]);

        if($validate->errors()->messages() != null){
            return $this->returnData(false, $validate->errors()->first(), null);
        }
        if (Hash::check($data['current_password'], $user->password)) {
            $user -> password = Hash::make($data['password']);
            $user -> save();
            return $this->returnData(true, 'You have successfully changed your password.', null);
        } else {
            return $this->returnData(false, 'Your current password does not match.', null);

        }
    }
    public function setDeviceId() {
        $user = $this->checkToken(request('token'));
        $user->device_id = request('device_id');
        $user->save();
        return $this->returnData(true, "Device id set.",$user);
    }

}
