<?php

namespace App\Http\Controllers\ApiV1;

use App\Banners;
use App\Category;
use App\Coupons;
use App\Http\Controllers\Controller;
use App\PageConfig;
use App\Products;
use App\Section;
use App\ShippingPrice;
use App\SubCategory;
use Illuminate\Http\Request;

class HomeController extends BaseController
{

    public function getBanners(){
//        $user = $this->checkToken(request('token'));
        $banners = Banners::whereStatus(1)->whereType("banner")->get();
        return $this->returnData(true, 'Banners', $banners);
    }
    public function getCollections(){
//        $user = $this->checkToken(request('token'));
        $collections = Banners::whereStatus(1)->whereType("collection")->inRandomOrder()->limit(3)->get();
        return $this->returnData(true, 'Collections', $collections);
    }
    public function getAllCollections(){
//        $user = $this->checkToken(request('token'));
        $collections = Banners::whereStatus(1)->whereType("collection")->get();
        return $this->returnData(true, 'Collections', $collections);
    }
    public function productBanners(){
        $collections = Banners::whereStatus(1)->whereType("horizontal_products")->get();
        return $this->returnData(true, 'Horizontal', $collections);
    }
    public function getTopProducts(){
//        $user = $this->checkToken(request('token'));
        $topProducts = Products::whereStatus(1)->with('sizes')->with('images')->inRandomOrder()->limit(4)->get();
        return $this->returnData(true, 'Top Products', $topProducts);
    }
    public function getCategories(){
        $categories = Category::whereStatus(1)->with('subCategories')->orderBy('ordered_by', 'asc')->get();
        return $this->returnData(true, 'Categories', $categories);
    }
    public function getSingleCategory(){
        $categories = SubCategory::whereStatus(1)->where('cat_id',\request('cat_id'))->with('products')->get();
        return $this->returnData(true, 'Single category', $categories);
    }
    public function getSubCategory(){
        $subCategory = SubCategory::whereId(\request('sub_id'))->whereStatus(1)->with('category')->with('products')->first();
        return $this->returnData(true, 'Sub Categories', $subCategory);
    }

    public function getSubProducts(){
        $products = Products::where('sub_category_id',\request('sub_id'))->whereStatus(1)->paginate(15);
        return $this->returnData(true, 'Sub prods', $products);
    }
    public function relatedProds(){
        $subCategory = SubCategory::whereId(\request('sub_id'))->whereStatus(1)->with('related')->first();
        return $this->returnData(true, 'Related', $subCategory);
    }
    public function getAllCategories(){
        $categories = Category::with('subCategories')->orderBy('ordered_by', 'asc')->get();
        return $this->returnData(true, 'Categories', $categories);
    }
    public function getShopConfig(){
        $conf = PageConfig::where('admin_id', 1)->where('status', 1)->first();
        return $this->returnData(true, 'Shop configuration', $conf);
    }
    public function getAllCoupons(){
        Coupons::where('status', 1)->where("end_date","<",date("Y-m-d",strtotime("now")))->where("start_date",">",date("Y-m-d",strtotime("now")))->update(["status"=>0]);
        $coupons = Coupons::all();
        return $this->returnData(true, 'Coupons', $coupons);
    }
    public function getCoupons(){
        $coupons = Coupons::where('status', 1)->where("end_date",">=",date("Y-m-d",strtotime("now")))->where("start_date","<=",date("Y-m-d",strtotime("now")))->get();
        return $this->returnData(true, 'Coupons', $coupons);
    }
    public function getSections(){
        $about      = Section::where('type', 'about')->whereStatus(1)->get();
        $terms      = Section::where('type', 'terms')->whereStatus(1)->get();
        $privacy    = Section::where('type', 'privacy')->whereStatus(1)->get();
        $ret = [];
        $ret[] = $about; $ret[] = $terms; $ret[] = $privacy;
        return $this->returnData(true, 'Sections', $ret);
    }
    public function getAbout() {
        $about      = Section::where('type', 'about')->whereStatus(1)->get();
        return $this->returnData(true, 'About', $about);
    }
    public function getTerms() {
        $terms      = Section::where('type', 'terms')->whereStatus(1)->get();
        return $this->returnData(true, 'Terms', $terms);
    }
    public function getPrivacy() {
        $privacy      = Section::where('type', 'privacy')->whereStatus(1)->get();
        return $this->returnData(true, 'Privacy', $privacy);
    }
    public function getShippingPrices() {
        $p      = ShippingPrice::all();
        return $this->returnData(true, 'Prices', $p);
    }
}
