<?php

namespace App\Http\Controllers\ApiV1;

use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Berkayk\OneSignal\OneSignalFacade as OneSignal;

class AuthController extends BaseController
{
    public function login(){
//        dd((array)request()->all());
        auth()->attempt(['email'=>request('email'),'password'=>request('password'), 'status' => 1]);
        if(auth()->check()){
            $user = auth()->user();
            $user->token = bcrypt(uniqid());
            $user->save();
            return $this->returnData(true, 'You have been logged in.', $user);
        }else{
            return $this->returnData(false, 'Credentials are not valid.',request()->all());
        }
    }
    public function logout(){
        $user = $this->checkToken(request('token'));
        $user->token = null;
        $user->device_id = null;
        $user->save();
        return $this->returnData(true,'Logged Out',$user);
    }
    public function signup(Request $request)
    {
        $data = $request->all();
        $validator = Validator::make($data, [
            'name' => 'required|string',
            'email' => 'required|string|email|unique:users',
            'password' => ['required', 'string', 'min:8', 'confirmed'],
//            'confirm_password' => ['required', 'same: password'],
            'city' => 'required|string',
            'zip_code' => 'required|string',
            'street_name' => 'required|string',
            'mobile_number' => 'required|string',
        ]);
        if ($validator->fails()) {
            return $this->returnData(false, $validator->errors()->first(), null); // will return only the errors
        }

//        $six_digit_random_number = mt_rand(100000, 999999);
        $user = new User();
        $name = request('name');
        $user->name = $name;
        $user->email = request('email');
        $user->password =  Hash::make(request('password'));
        $user->city = request('city');
        $user->zip = request('zip_code');
        $user->address = request('street_name');
        $user->tel = request('mobile_number');
        $user->save();

        $admin = User::where('status', 2)->first();
        $params = [];
        if($admin !=null && $admin->device_id != null && $admin->device_id != "") {
            $userId = $admin->device_id;

            $params['include_player_ids'] = array($userId);
            $headers = [
                "en" => 'New User',
            ];
            $contents = [
                "en" => 'A new user, '. $user->name.' has registered an account to your platform.',
            ];
            $params['contents'] = $contents;
            $params['headings'] = $headers;
            OneSignal::sendNotificationCustom($params);
        }
//        Mail::to($user->email)->send(new EmailVerification($six_digit_random_number));
        return $this->returnData(true, 'Account Created', $user);
    }
}
