<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class LanguageController extends Controller
{
    public function languages(){
        if(request()->isMethod('post')){

            $langVar = request('langVar');
            $languageExist = Language::where('variable',$langVar)->first();
            if($languageExist!=null){
                return redirect()->back()->withErrors(['error'=>'Variable already exist !']);
            }
            $language = new Language();
            $language->variable = strtolower(request('langVar'));
            $language->en = request('en');
            $language->de = request('de');
            $language->save();
            return redirect('admin/languages');
        }
        $languages = Language::all();
        return view('admin.views.languages',compact('languages'));
    }
    //Changing language variables value serves as API and only values for each language are possible to be changes
    public function changeLanguageVariable(){
        $langVar = strtolower(request('langVar'));
        $language = Language::where('variable',$langVar)->first();
        $language->en = request('en');
        $language->de = request('de');
        $language->save();
        return response()->json($this->responseAPI(true,null,null,null));
    }
    private function responseAPI($status, $message,$val,$error){
        $values = [
            'status'=>$status,
            'message'=>$message,
            'values'=> $val,
            'error'=>$error
        ];
        return $values;
    }
    //Foreach language we create language files in system which are accessed from Laravel language system
    public function generateLanguages(){
        $languages = array('en' => 'en', 'mk' => 'mk','al' => 'al', 'tur' => 'tur');
        $variables = Language::all();
        $myLanguage = [];
        $response = 0;
        foreach($languages as $key => $lang){
            $myVars = "";
            $langstr="<?php
                return [ \n
            ";
            $langJson = "{ \n";
            foreach ($variables as $key2 => $variable){
                $langstr.= "'".$variable->variable."' => '".addslashes($variable[$lang])."',\n";
                $langJson.= '"'.$variable->variable.'" : "'.addslashes($variable[$lang]).'"';
                if ($key2 != count($variables)-1)
                    $langJson .=", \n";
                $myVars.= "'".$variable->variable."' => '".addslashes($variable[$lang])."',\n";
            }
            $langstr .= ']; ';
            $langJson .= "\n }";
            if (!file_exists('../resources/lang/'.$key.'/')) { mkdir('../resources/lang/'.$key.'/',0775, true);}
            $write = File::put('../resources/lang/'.$key.'/website.php', $langstr);
//            $write = File::put('../resources/lang/'.$key.'/lang.json', $langJson);
            if (!file_exists('../public/lang/'.$key.'/')) { mkdir('../public/lang/'.$key.'/',0775, true);}
            $write = File::put('../public/lang/'.$key.'/'.$key.'.json', $langJson);
//            if ($key == 'en') {
//            } else if($key == 'de') {
//                $write = File::put('../public/lang/de-DE/de-DE.json', $langJson);
//
//            }
//            dd(asset('lang'));
            if($write){
                $response++;
            }
            $myLanguage[$key] = $myVars;
        }
        return redirect('admin/languages');
    }
    public function deleteLanguageVariable($id){
        $langVar = Language::find($id);
        $langVar->delete();
        return redirect('admin/languages');
    }
}
